/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.cacheadmin;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import java.util.Calendar;
import java.util.Collections;
import org.opencms.main.CmsEvent;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.cacheadmin.CmsFlushCache;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsDateField;

public class CmsImageCacheCleanDialog
extends CmsBasicDialog
implements CmsFlushCache.I_CloseableDialog {
    private static final long serialVersionUID = -6902585433676013120L;
    Runnable m_closeRunnable;
    Runnable m_okRunnable;
    private Button m_cancelButton;
    private CmsDateField m_dateField;
    private Label m_icon;
    private Button m_okButton;

    public CmsImageCacheCleanDialog() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_icon.setContentMode(ContentMode.HTML);
        this.m_icon.setValue(FontOpenCms.WARNING.getHtml());
        Calendar cal = Calendar.getInstance();
        cal.add(12, -30);
        this.m_dateField.setDate(cal.getTime());
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 8281661241498918564L;

            public void buttonClick(Button.ClickEvent event) {
                CmsImageCacheCleanDialog.this.flushCache();
                CmsImageCacheCleanDialog.this.m_closeRunnable.run();
                if (CmsImageCacheCleanDialog.this.m_okRunnable != null) {
                    CmsImageCacheCleanDialog.this.m_okRunnable.run();
                }
            }
        });
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -936541994114016527L;

            public void buttonClick(Button.ClickEvent event) {
                CmsImageCacheCleanDialog.this.m_closeRunnable.run();
            }
        });
    }

    @Override
    public void setCloseRunnable(Runnable closeRunnable) {
        this.m_closeRunnable = closeRunnable;
    }

    @Override
    public void setOkRunnable(Runnable okRunnable) {
        this.m_okRunnable = okRunnable;
    }

    void flushCache() {
        float age = (float)(System.currentTimeMillis() - this.m_dateField.getDate().getTime()) / 3600000.0f;
        OpenCms.fireCmsEvent(new CmsEvent(5, Collections.singletonMap("_IMAGES_CACHE_", "" + age)));
    }
}

