/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.cacheadmin;

import com.alkacon.simapi.Simapi;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.loader.CmsImageLoader;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsImageCacheHelper {
    private Map<String, String> m_filePaths = new HashMap<String, String>();
    private Map m_lengths = new HashMap();
    private Map m_sizes = new HashMap();
    private Map m_variations = new HashMap();
    private int m_variationsCount;
    private int m_variationsSize;

    public CmsImageCacheHelper(CmsObject cms, boolean withVariations, boolean showSize, boolean statsOnly) {
        this.init(cms, withVariations, showSize, statsOnly);
    }

    public List getAllCachedImages() {
        ArrayList ret = new ArrayList(this.m_variations.keySet());
        Collections.sort(ret);
        return ret;
    }

    public int getFilesCount() {
        return this.m_variations.keySet().size();
    }

    public String getLength(String imgName) {
        String ret = (String)this.m_lengths.get(imgName);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public String getSingleSize(CmsObject cms, String resPath) throws CmsException {
        CmsResource res = this.getClonedCmsObject(cms).readResource(resPath);
        return this.getSingleSize(cms, res);
    }

    public String getSize(String imgName) {
        String ret = (String)this.m_sizes.get(imgName);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public List getVariations(String imgName) {
        List ret = (List)this.m_variations.get(imgName);
        if (ret == null) {
            return new ArrayList();
        }
        Collections.sort(ret);
        return ret;
    }

    public int getVariationsCount() {
        return this.m_variationsCount;
    }

    public int getVariationsSize() {
        return this.m_variationsSize;
    }

    String getFilePath(String resName) {
        return this.m_filePaths.get(resName);
    }

    private CmsObject getClonedCmsObject(CmsObject cms) throws CmsException {
        CmsObject clonedCms = OpenCms.initCmsObject(cms);
        clonedCms.getRequestContext().setCurrentProject(clonedCms.readProject(CmsProject.ONLINE_PROJECT_ID));
        clonedCms.getRequestContext().setSiteRoot("");
        return clonedCms;
    }

    private String getSingleSize(CmsObject cms, CmsResource res) {
        try {
            BufferedImage img = Simapi.read((byte[])cms.readFile(res).getContents());
            return "" + img.getWidth() + " x " + img.getHeight() + "px";
        }
        catch (IOException | CmsException e) {
            return "";
        }
    }

    private void init(CmsObject cms, boolean withVariations, boolean showSize, boolean statsOnly) {
        File basedir = new File(CmsImageLoader.getImageRepositoryPath());
        try {
            CmsObject clonedCms = this.getClonedCmsObject(cms);
            this.visitImages(clonedCms, basedir, withVariations, showSize, statsOnly);
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_variations = Collections.unmodifiableMap(this.m_variations);
        this.m_sizes = Collections.unmodifiableMap(this.m_sizes);
        this.m_lengths = Collections.unmodifiableMap(this.m_lengths);
    }

    private void visitImage(CmsObject cms, File f, boolean withVariations, boolean showSize, boolean statsOnly) {
        BufferedImage img;
        ++this.m_variationsCount;
        this.m_variationsSize = (int)((long)this.m_variationsSize + f.length());
        String oName = f.getAbsolutePath().substring(CmsImageLoader.getImageRepositoryPath().length());
        if (!(oName = CmsStringUtil.substitute(oName, "\\", "/")).startsWith("/")) {
            oName = "/" + oName;
        }
        String imgName = oName;
        CmsResource res = null;
        boolean found = false;
        while (!found) {
            String path = CmsResource.getParentFolder(imgName);
            String name = imgName.substring(path.length());
            String ext = CmsFileUtil.getExtension(imgName);
            String nameWoExt = name.substring(0, name.length() - ext.length());
            int pos = nameWoExt.lastIndexOf("_");
            String newName = path;
            found = pos < 0;
            newName = !found ? newName + nameWoExt.substring(0, pos) : newName + nameWoExt;
            newName = newName + ext;
            try {
                res = cms.readResource(newName, CmsResourceFilter.ALL);
                found = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            imgName = newName;
        }
        if (res != null) {
            oName = res.getRootPath();
        }
        this.m_filePaths.put(oName, f.getAbsolutePath());
        ArrayList<String> variations = (ArrayList<String>)this.m_variations.get(oName);
        if (variations == null) {
            variations = new ArrayList<String>();
            this.m_variations.put(oName, variations);
            if (statsOnly) {
                return;
            }
            if (res != null) {
                this.m_lengths.put(oName, "" + res.getLength() + " Bytes");
                if (showSize) {
                    this.m_sizes.put(oName, this.getSingleSize(cms, res));
                }
            } else {
                this.m_lengths.put(oName, "" + f.length() + " Bytes");
                if (showSize) {
                    try {
                        img = Simapi.read((File)f);
                        this.m_sizes.put(oName, "" + img.getWidth() + " x " + img.getHeight() + "px");
                    }
                    catch (Throwable img2) {
                        // empty catch block
                    }
                }
            }
        }
        if (!withVariations) {
            return;
        }
        oName = oName + " (";
        if (showSize) {
            try {
                img = Simapi.read((File)f);
                oName = oName + "" + img.getWidth() + " x " + img.getHeight() + "px - ";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        oName = oName + f.length() + " Bytes)";
        variations.add(oName);
    }

    private void visitImages(CmsObject cms, File directory, boolean withVariations, boolean showSize, boolean statsOnly) {
        if (!directory.canRead() || !directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                this.visitImages(cms, f, withVariations, showSize, statsOnly);
                continue;
            }
            this.visitImage(cms, f, withVariations, showSize, statsOnly);
        }
    }
}

