/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.cacheadmin;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.loader.CmsImageLoader;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.apps.cacheadmin.CmsVariationBean;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsImageCacheHolder {
    private static Map<String, String> PATH_TO_VFS_NAME = new HashMap<String, String>();
    private Map m_filePaths = new HashMap();
    private Map m_lengths = new HashMap();
    private Map m_sizes = new HashMap();
    private Map m_variations = new HashMap();
    private FilenameFilter m_filter;
    protected CmsObject m_clonedCms;

    public CmsImageCacheHolder(final String search) {
        try {
            this.m_clonedCms = this.getClonedCmsObject(A_CmsUI.getCmsObject());
        }
        catch (CmsException e) {
            this.m_clonedCms = A_CmsUI.getCmsObject();
        }
        this.m_filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String spatt = search.replace("*", "");
                if (new File(dir, name).isDirectory()) {
                    return true;
                }
                String fullPath = dir.getAbsolutePath() + "/" + name;
                fullPath = fullPath.substring(CmsImageLoader.getImageRepositoryPath().length() - 1);
                return CmsImageCacheHolder.this.getVFSName(CmsImageCacheHolder.this.m_clonedCms, fullPath).contains(spatt);
            }
        };
        if (!search.startsWith("*") & search.startsWith("/")) {
            String root = this.getRootFromPattern(search);
            if (root.length() > 1) {
                this.readAllImagesAndVariations(root.substring(1).replace("*", ""));
            } else {
                this.readAllImagesAndVariations("");
            }
        } else {
            this.readAllImagesAndVariations("");
        }
    }

    public List<String> getAllCachedImages() {
        ArrayList<String> ret = new ArrayList<String>(this.m_variations.keySet());
        Collections.sort(ret);
        return ret;
    }

    public List<CmsVariationBean> getVariations(String resource) {
        List ret = (List)this.m_filePaths.get(resource);
        ArrayList<CmsVariationBean> res = new ArrayList<CmsVariationBean>();
        if (ret == null) {
            return new ArrayList<CmsVariationBean>();
        }
        for (String r : ret) {
            res.add(new CmsVariationBean(r));
        }
        return res;
    }

    public int getVariationsCount(String resource) {
        return ((List)this.m_variations.get(resource)).size();
    }

    String getVFSName(CmsObject cms, String oName) {
        if (!(oName = CmsStringUtil.substitute(oName, "\\", "/")).startsWith("/")) {
            oName = "/" + oName;
        }
        if (PATH_TO_VFS_NAME.containsKey(oName)) {
            return PATH_TO_VFS_NAME.get(oName);
        }
        String imgName = oName;
        CmsResource res = null;
        boolean found = false;
        while (!found) {
            String path = CmsResource.getParentFolder(imgName);
            String name = imgName.substring(path.length());
            String ext = CmsFileUtil.getExtension(imgName);
            String nameWoExt = name.substring(0, name.length() - ext.length());
            int pos = nameWoExt.lastIndexOf("_");
            String newName = path;
            found = pos < 0;
            newName = !found ? newName + nameWoExt.substring(0, pos) : newName + nameWoExt;
            newName = newName + ext;
            try {
                res = cms.readResource(newName, CmsResourceFilter.ALL);
                found = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            imgName = newName;
        }
        if (res != null) {
            PATH_TO_VFS_NAME.put(oName, res.getRootPath());
            return res.getRootPath();
        }
        return "";
    }

    private CmsObject getClonedCmsObject(CmsObject cms) throws CmsException {
        CmsObject clonedCms = OpenCms.initCmsObject(cms);
        clonedCms.getRequestContext().setCurrentProject(clonedCms.readProject(CmsProject.ONLINE_PROJECT_ID));
        clonedCms.getRequestContext().setSiteRoot("");
        return clonedCms;
    }

    private String getRootFromPattern(String pattern) {
        String res = pattern.substring(0, pattern.lastIndexOf("/"));
        return res;
    }

    private void readAllImagesAndVariations(String root) {
        File basedir = new File(CmsImageLoader.getImageRepositoryPath() + root);
        this.visitImages(this.m_clonedCms, basedir);
        this.m_variations = Collections.unmodifiableMap(this.m_variations);
        this.m_sizes = Collections.unmodifiableMap(this.m_sizes);
        this.m_lengths = Collections.unmodifiableMap(this.m_lengths);
    }

    private void visitImage(CmsObject cms, File f) {
        f.length();
        String oName = f.getAbsolutePath().substring(CmsImageLoader.getImageRepositoryPath().length());
        oName = this.getVFSName(cms, oName);
        ArrayList<String> files = (ArrayList<String>)this.m_filePaths.get(oName);
        if (files == null) {
            files = new ArrayList<String>();
            this.m_filePaths.put(oName, files);
        }
        files.add(f.getAbsolutePath());
        ArrayList<String> variations = (ArrayList<String>)this.m_variations.get(oName);
        if (variations == null) {
            variations = new ArrayList<String>();
            this.m_variations.put(oName, variations);
        }
        oName = oName + " (";
        oName = oName + f.length() + " Bytes)";
        variations.add(oName);
    }

    private void visitImages(CmsObject cms, File directory) {
        if (!directory.canRead() || !directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles(this.m_filter);
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                this.visitImages(cms, f);
                continue;
            }
            this.visitImage(cms, f);
        }
    }
}

