/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.cacheadmin;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.cacheadmin.CmsCacheViewApp;
import org.opencms.ui.apps.cacheadmin.CmsImageCacheHolder;
import org.opencms.ui.apps.cacheadmin.CmsVariationsDialog;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsImageCacheTable
extends Table {
    protected static CmsImageCacheHolder HELPER;
    static Log LOG;
    private static final String PROP_ICON = "icon";
    private static final String PROP_NAME = "name";
    private static final String PROP_VARIATIONS = "variations";
    private static final long serialVersionUID = -5559186186646954045L;
    CmsContextMenu m_menu;
    private IndexedContainer m_container;
    private VerticalLayout m_intro;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;
    private VerticalLayout m_nullResult;
    private CmsObject m_rootCms;
    private TextField m_siteTableFilter;

    public CmsImageCacheTable(VerticalLayout intro, VerticalLayout nullResult, TextField siteTableFilter) {
        this.m_intro = intro;
        this.m_nullResult = nullResult;
        this.m_siteTableFilter = siteTableFilter;
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.m_container = new IndexedContainer(){
            private static final long serialVersionUID = -8679153149897733835L;

            public Collection<?> getSortableContainerPropertyIds() {
                return Collections.singleton(CmsImageCacheTable.PROP_NAME);
            }
        };
        this.m_container.addContainerProperty((Object)PROP_ICON, Resource.class, (Object)CmsResourceUtil.getBigIconResource(OpenCms.getWorkplaceManager().getExplorerTypeSetting(CmsResourceTypeImage.getStaticTypeName()), null));
        this.m_container.addContainerProperty((Object)PROP_NAME, String.class, (Object)"");
        this.m_container.addContainerProperty((Object)PROP_VARIATIONS, Integer.class, (Object)"");
        this.setContainerDataSource((Container)this.m_container);
        this.setColumnHeader(PROP_NAME, CmsVaadinUtils.getMessageText("GUI_CACHE_IMAGECACHE_LIST_COLS_RESOURCE_0", new Object[0]));
        this.setColumnHeader(PROP_VARIATIONS, CmsVaadinUtils.getMessageText("GUI_CACHE_IMAGECACHE_LIST_COLS_VARIATIONS_0", new Object[0]));
        this.setItemIconPropertyId(PROP_ICON);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnWidth(null, 40);
        this.setSelectable(true);
        this.addGeneratedColumn(PROP_VARIATIONS, new VariationsColumn());
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = -4738296706762013443L;

            public void itemClick(ItemClickEvent event) {
                CmsImageCacheTable.this.setValue(null);
                CmsImageCacheTable.this.select(event.getItemId());
                if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || event.getPropertyId() == null) {
                    CmsImageCacheTable.this.m_menu.setEntries(CmsImageCacheTable.this.getMenuEntries(), Collections.singleton((String)CmsImageCacheTable.this.getValue()));
                    CmsImageCacheTable.this.m_menu.openForTable((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId(), CmsImageCacheTable.this);
                }
                if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) & CmsImageCacheTable.PROP_NAME.equals(event.getPropertyId())) {
                    CmsImageCacheTable.this.showVariationsWindow((String)CmsImageCacheTable.this.getValue());
                }
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                if (CmsImageCacheTable.PROP_NAME.equals(propertyId)) {
                    return " o-hover-column";
                }
                return null;
            }
        });
        this.setColumnWidth(PROP_VARIATIONS, 100);
    }

    public void filterTable(String search) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)PROP_NAME, search, true, false)}));
        }
        if (this.getValue() != null) {
            this.setCurrentPageFirstItemId(this.getValue());
        }
    }

    public void load(String search) {
        HELPER = new CmsImageCacheHolder(search);
        this.loadTable();
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EntryVariations());
            this.m_menuEntries.add(new ExplorerEntry());
        }
        return this.m_menuEntries;
    }

    CmsObject getRootCms() {
        try {
            if (this.m_rootCms == null) {
                this.m_rootCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                this.m_rootCms.getRequestContext().setSiteRoot("");
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return this.m_rootCms;
    }

    void openExplorerForParent(String rootPath, String uuid) {
        String parentPath = CmsResource.getParentFolder(rootPath);
        CmsAppWorkplaceUi.get().getNavigator().navigateTo("explorer/" + A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().getUuid() + "!!" + A_CmsUI.getCmsObject().getRequestContext().getSiteRoot() + "!!" + parentPath.substring(A_CmsUI.getCmsObject().getRequestContext().getSiteRoot().length()) + "!!" + uuid + "!!");
    }

    void showVariationsWindow(String resource) {
        final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
        CmsVariationsDialog variationsDialog = new CmsVariationsDialog(resource, new Runnable(){

            @Override
            public void run() {
                window.close();
            }
        }, CmsCacheViewApp.Mode.ImageCache);
        try {
            CmsResource resourceObject = this.getRootCms().readResource(resource);
            variationsDialog.displayResourceInfo(Collections.singletonList(resourceObject));
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_CACHE_VIEW_FLEX_VARIATIONS_1", resource));
        window.setContent((Component)variationsDialog);
        A_CmsUI.get().addWindow(window);
        window.center();
    }

    private void loadTable() {
        this.m_nullResult.setVisible(false);
        this.m_intro.setVisible(false);
        this.setVisible(true);
        this.m_siteTableFilter.setVisible(true);
        this.m_container.removeAllItems();
        this.setVisibleColumns(new Object[]{PROP_NAME, PROP_VARIATIONS});
        List<String> resources = HELPER.getAllCachedImages();
        for (String res : resources) {
            Item item = this.m_container.addItem((Object)res);
            item.getItemProperty((Object)PROP_NAME).setValue((Object)res);
        }
        if (resources.size() == 0) {
            this.m_nullResult.setVisible(true);
            this.setVisible(false);
            this.m_siteTableFilter.setVisible(false);
        }
    }

    static {
        LOG = CmsLog.getLog(CmsImageCacheTable.class.getName());
    }

    class VariationsColumn
    implements Table.ColumnGenerator {
        private static final long serialVersionUID = -4569513960107614645L;

        VariationsColumn() {
        }

        public Object generateCell(Table source, Object itemId, Object columnId) {
            return HELPER.getVariationsCount((String)itemId);
        }
    }

    class ExplorerEntry
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        ExplorerEntry() {
        }

        @Override
        public void executeAction(Set<String> data) {
            try {
                CmsResource res = CmsImageCacheTable.this.getRootCms().readResource(data.iterator().next());
                CmsImageCacheTable.this.openExplorerForParent(res.getRootPath(), res.getStructureId().getStringValue());
            }
            catch (CmsException e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return Messages.get().getBundle(locale).key("GUI_EXPLORER_TITLE_0");
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            if (data == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            String res = data.iterator().next();
            if (!A_CmsUI.getCmsObject().getRequestContext().getSiteRoot().equals("") && !res.startsWith(A_CmsUI.getCmsObject().getRequestContext().getSiteRoot())) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EntryVariations
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EntryVariations() {
        }

        @Override
        public void executeAction(Set<String> data) {
            String resource = data.iterator().next();
            CmsImageCacheTable.this.showVariationsWindow(resource);
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_CACHE_FLEXCACHE_LABEL_STATS_VARIATIONS_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> data) {
            return data != null && data.size() == 1 ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }
}

