/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.VerticalLayout;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.dbmanager.CmsImportFile;
import org.opencms.ui.apps.dbmanager.I_CmsReportApp;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.util.CmsUUID;

public abstract class A_CmsImportForm
extends VerticalLayout {
    private static final Log LOG = CmsLog.getLog(A_CmsImportForm.class);
    private static final long serialVersionUID = -4074089542763339000L;
    protected I_CmsReportApp m_app;
    protected CmsImportFile m_importFile;

    public A_CmsImportForm(I_CmsReportApp app) {
        CmsObject cms = A_CmsUI.getCmsObject();
        this.m_app = app;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.getOkButton().setEnabled(false);
        IndexedContainer availableSites = CmsVaadinUtils.getAvailableSitesContainer(cms, "caption");
        this.getSiteSelector().setContainerDataSource((Container)availableSites);
        if (availableSites.getItem((Object)cms.getRequestContext().getSiteRoot()) != null) {
            this.getSiteSelector().setValue((Object)cms.getRequestContext().getSiteRoot());
        }
        this.getSiteSelector().setNullSelectionAllowed(false);
        this.getSiteSelector().setItemCaptionPropertyId((Object)"caption");
        this.getProjectSelector().setContainerDataSource((Container)CmsVaadinUtils.getProjectsContainer(A_CmsUI.getCmsObject(), "caption"));
        this.getProjectSelector().setItemCaptionPropertyId((Object)"caption");
        this.getProjectSelector().select((Object)A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().getUuid());
        this.getProjectSelector().setNewItemsAllowed(false);
        this.getProjectSelector().setNullSelectionAllowed(false);
        this.getProjectSelector().setTextInputAllowed(false);
        if (this.getCancelButton() != null) {
            this.getCancelButton().addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = -3475214711731413636L;

                public void buttonClick(Button.ClickEvent event) {
                    A_CmsImportForm.this.m_app.goToMainView();
                }
            });
        }
        this.getOkButton().addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5651452508587710734L;

            public void buttonClick(Button.ClickEvent event) {
                A_CmsImportForm.this.m_app.openReport(A_CmsImportForm.this.getReportPath(), A_CmsImportForm.this.getThread(), A_CmsImportForm.this.getTitle());
            }
        });
    }

    protected abstract Button getCancelButton();

    protected CmsObject getCmsObject() {
        try {
            CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            cms.getRequestContext().setSiteRoot((String)this.getSiteSelector().getValue());
            cms.getRequestContext().setCurrentProject(cms.readProject((CmsUUID)this.getProjectSelector().getValue()));
            return cms;
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to get CmsObject", (Throwable)e);
            return null;
        }
    }

    protected abstract Button getOkButton();

    protected abstract ComboBox getProjectSelector();

    protected abstract String getReportPath();

    protected abstract ComboBox getSiteSelector();

    protected abstract A_CmsReportThread getThread();

    protected abstract String getTitle();

    protected String processFileName(String name) {
        int pos = name.lastIndexOf("/");
        if (pos >= 0) {
            name = name.substring(pos + 1);
        }
        if ((pos = name.lastIndexOf("\\")) >= 0) {
            name = name.substring(pos + 1);
        }
        return name;
    }

    protected void validateModuleFile() {
        try {
            this.m_importFile.loadAndValidate();
            String importSite = this.m_importFile.getModule().getImportSite();
            if (importSite != null) {
                this.getSiteSelector().setEnabled(false);
                this.getSiteSelector().setValue((Object)importSite);
            }
            this.getOkButton().setEnabled(true);
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_importFile = null;
            this.getOkButton().setEnabled(false);
            CmsErrorDialog.showErrorDialog(e);
        }
    }
}

