/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import java.io.File;
import org.opencms.main.OpenCms;
import org.opencms.ui.apps.dbmanager.A_CmsImportForm;
import org.opencms.ui.apps.dbmanager.CmsImportFile;
import org.opencms.ui.apps.dbmanager.I_CmsReportApp;

public abstract class A_CmsServerImportForm
extends A_CmsImportForm {
    private static final long serialVersionUID = 5493880295543227220L;

    public A_CmsServerImportForm(I_CmsReportApp app, String pathToServer, final boolean validate) {
        super(app);
        IndexedContainer options = new IndexedContainer();
        options.addContainerProperty((Object)"label", String.class, (Object)"");
        this.getImportSelect().setContainerDataSource((Container)options);
        this.getImportSelect().setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.getImportSelect().setItemCaptionPropertyId((Object)"label");
        this.getImportSelect().setNullSelectionAllowed(false);
        String moduleDir = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(pathToServer);
        File moduleDirFile = new File(moduleDir);
        if (moduleDirFile.exists()) {
            for (File file : moduleDirFile.listFiles()) {
                String path = file.getAbsolutePath();
                String name = file.getName();
                options.addItem((Object)path).getItemProperty((Object)"label").setValue((Object)name);
            }
        }
        this.getImportSelect().addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -8550460711407604364L;

            public void valueChange(Property.ValueChangeEvent event) {
                String path = (String)event.getProperty().getValue();
                A_CmsServerImportForm.this.m_importFile = new CmsImportFile(path);
                if (validate) {
                    A_CmsServerImportForm.this.getOkButton().setEnabled(false);
                    A_CmsServerImportForm.this.validateModuleFile();
                    return;
                }
                A_CmsServerImportForm.this.getOkButton().setEnabled(true);
            }
        });
    }

    public abstract ComboBox getImportSelect();
}

