/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.google.common.base.Supplier;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.importexport.CmsExportParameters;
import org.opencms.importexport.CmsVfsImportExportHandler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.dbmanager.CmsDbManager;
import org.opencms.ui.apps.dbmanager.CmsExportThreadDialog;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsDateField;
import org.opencms.ui.components.editablegroup.CmsEditableGroup;
import org.opencms.ui.components.editablegroup.I_CmsEditableGroupRow;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.threads.CmsExportThread;

public class CmsDbExportView
extends VerticalLayout {
    static Log LOG = CmsLog.getLog(CmsDbExportView.class.getName());
    private static final long serialVersionUID = -2571459807662862053L;
    protected CmsObject m_cms;
    private CheckBox m_asFiles;
    private CmsDateField m_changedSince;
    private CmsExportParameters m_exportParams;
    private CheckBox m_includeAccount;
    private CheckBox m_includeProject;
    private CheckBox m_includeResource;
    private CheckBox m_includeSystem;
    private CheckBox m_includeUnchanged;
    private CheckBox m_modified;
    private Button m_ok;
    private CheckBox m_recursive;
    private VerticalLayout m_resources;
    private CmsEditableGroup m_resourcesGroup;
    private ComboBox m_site;
    private ComboBox m_target;
    private ComboBox m_project;

    public CmsDbExportView() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        try {
            this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
        }
        catch (CmsException e) {
            LOG.error((Object)"Failed to clone CmsObject", (Throwable)e);
        }
        this.m_resourcesGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_resources, new Supplier<Component>(){

            public Component get() {
                return CmsDbExportView.this.getResourceRow("");
            }
        }, CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_EXPORT_ADD_RESOURCE_0", new Object[0]));
        this.m_resourcesGroup.init();
        this.m_resourcesGroup.addRow(this.getResourceRow(""));
        this.m_exportParams = new CmsExportParameters();
        this.setupCheckBoxes();
        this.setupComboBoxFile();
        this.setupComboBoxSite();
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -4224924796312615674L;

            public void buttonClick(Button.ClickEvent event) {
                CmsDbExportView.this.addResourceIfEmpty();
                CmsDbExportView.this.addValidators();
                if (CmsDbExportView.this.isFormValid()) {
                    CmsDbExportView.this.startThread();
                }
            }
        });
    }

    protected void addResourceIfEmpty() {
        if (this.m_resourcesGroup.getRows().size() == 0) {
            this.m_resourcesGroup.addRow(this.getResourceRow(""));
        }
    }

    protected void addValidators() {
        this.m_target.removeAllValidators();
        this.m_target.addValidator((Validator)new TargetValidator());
        for (I_CmsEditableGroupRow row : this.m_resourcesGroup.getRows()) {
            FormLayout layout = (FormLayout)row.getComponent();
            CmsPathSelectField field = (CmsPathSelectField)layout.getComponent(0);
            field.removeAllValidators();
            field.addValidator(new ResourceValidator());
        }
    }

    protected void changeSite() {
        this.m_cms.getRequestContext().setSiteRoot((String)this.m_site.getValue());
    }

    protected Component getResourceRow(String path) {
        FormLayout res = new FormLayout();
        CmsPathSelectField field = new CmsPathSelectField();
        field.setCaption(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_EXPORT_RESOURCES_0", new Object[0]));
        field.setDescription(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_EXPORT_RESOURCES_HELP_0", new Object[0]));
        field.setCmsObject(this.m_cms);
        res.addComponent((Component)field);
        return res;
    }

    protected boolean isFormValid() {
        return this.m_target.isValid() & this.allResourcesValid();
    }

    protected void removeUnvalidPathFields() {
        boolean counter = false;
        ArrayList<I_CmsEditableGroupRow> rowsToRemove = new ArrayList<I_CmsEditableGroupRow>();
        for (I_CmsEditableGroupRow row : this.m_resourcesGroup.getRows()) {
            FormLayout layout = (FormLayout)row.getComponent();
            CmsPathSelectField field = (CmsPathSelectField)layout.getComponent(0);
            if (this.m_cms.existsResource(field.getValue())) continue;
            rowsToRemove.add(row);
        }
        for (I_CmsEditableGroupRow row : rowsToRemove) {
            this.m_resourcesGroup.remove(row);
        }
    }

    protected void startThread() {
        try {
            this.m_cms.getRequestContext().setCurrentProject(this.m_cms.readProject((CmsUUID)this.m_project.getValue()));
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to set project", (Throwable)e);
        }
        this.updateExportParams();
        CmsVfsImportExportHandler handler = new CmsVfsImportExportHandler();
        handler.setExportParams(this.m_exportParams);
        CmsExportThread exportThread = new CmsExportThread(this.m_cms, handler, false);
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
        window.setContent((Component)new CmsExportThreadDialog(exportThread, window));
        A_CmsUI.get().addWindow(window);
        exportThread.start();
    }

    private boolean allResourcesValid() {
        boolean valid = true;
        for (I_CmsEditableGroupRow row : this.m_resourcesGroup.getRows()) {
            FormLayout layout = (FormLayout)row.getComponent();
            CmsPathSelectField field = (CmsPathSelectField)layout.getComponent(0);
            if (field.isValid()) continue;
            valid = false;
        }
        return valid;
    }

    private List<String> getResources() {
        ArrayList<String> res = new ArrayList<String>();
        for (I_CmsEditableGroupRow row : this.m_resourcesGroup.getRows()) {
            FormLayout layout = (FormLayout)row.getComponent();
            CmsPathSelectField field = (CmsPathSelectField)layout.getComponent(0);
            if (!(!field.getValue().isEmpty() & !res.contains(field.getValue()))) continue;
            res.add(field.getValue());
        }
        return res;
    }

    private void setupCheckBoxes() {
        this.m_includeResource.setValue((Object)new Boolean(true));
        this.m_includeUnchanged.setValue((Object)new Boolean(true));
        this.m_includeSystem.setValue((Object)new Boolean(true));
        this.m_recursive.setValue((Object)new Boolean(true));
    }

    private void setupComboBoxFile() {
        this.m_target.setInputPrompt(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_EXPORT_FILE_NAME_EMPTY_0", new Object[0]));
        this.m_target.setNewItemsAllowed(true);
        List<String> files = CmsDbManager.getFileListFromServer(true);
        for (String file : files) {
            this.m_target.addItem((Object)file);
        }
    }

    private void setupComboBoxSite() {
        IndexedContainer container = CmsVaadinUtils.getAvailableSitesContainer(A_CmsUI.getCmsObject(), "title");
        this.m_site.setContainerDataSource((Container)container);
        this.m_site.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.m_site.setItemCaptionPropertyId((Object)"title");
        this.m_site.setNullSelectionAllowed(false);
        this.m_site.setTextInputAllowed(false);
        this.m_site.setValue((Object)A_CmsUI.getCmsObject().getRequestContext().getSiteRoot());
        this.m_site.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -1019243885633462477L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsDbExportView.this.changeSite();
                CmsDbExportView.this.removeUnvalidPathFields();
            }
        });
        this.m_project.setContainerDataSource((Container)CmsVaadinUtils.getProjectsContainer(A_CmsUI.getCmsObject(), "caption"));
        this.m_project.setItemCaptionPropertyId((Object)"caption");
        this.m_project.select((Object)A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().getUuid());
        this.m_project.setNewItemsAllowed(false);
        this.m_project.setNullSelectionAllowed(false);
        this.m_project.setTextInputAllowed(false);
    }

    private void updateExportParams() {
        this.m_exportParams.setExportAccountData((Boolean)this.m_includeAccount.getValue());
        this.m_exportParams.setExportAsFiles((Boolean)this.m_asFiles.getValue());
        this.m_exportParams.setExportProjectData((Boolean)this.m_includeProject.getValue());
        this.m_exportParams.setExportResourceData((Boolean)this.m_includeResource.getValue());
        this.m_exportParams.setInProject((Boolean)this.m_modified.getValue());
        this.m_exportParams.setIncludeSystemFolder((Boolean)this.m_includeSystem.getValue());
        this.m_exportParams.setIncludeUnchangedResources((Boolean)this.m_includeUnchanged.getValue());
        String exportFileName = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSystemInfo().getPackagesRfsPath() + File.separator + (String)this.m_target.getValue());
        this.m_exportParams.setPath(exportFileName);
        this.m_exportParams.setRecursive((Boolean)this.m_recursive.getValue());
        this.m_exportParams.setResources(this.getResources());
        if (this.m_changedSince.getValue() != null) {
            this.m_exportParams.setContentAge(this.m_changedSince.getDate().getTime());
        } else {
            this.m_exportParams.setContentAge(0L);
        }
    }

    class TargetValidator
    implements Validator {
        private static final long serialVersionUID = 7530400504930612299L;

        TargetValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (value == null) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_EXPORT_INVALID_TARGET_0", new Object[0]));
            }
        }
    }

    class ResourceValidator
    implements Validator {
        private static final long serialVersionUID = -4341247963641286345L;

        ResourceValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            String resourcePath = (String)value;
            if (value == null) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_EXPORT_INVALID_RESOURCE_EMPTY_0", new Object[0]));
            }
            if (resourcePath.isEmpty()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_EXPORT_INVALID_RESOURCE_EMPTY_0", new Object[0]));
            }
            if (!CmsDbExportView.this.m_cms.existsResource(resourcePath)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_EXPORT_INVALID_RESOURCE_NOTFOUND_0", new Object[0]));
            }
        }
    }
}

