/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.google.common.collect.Maps;
import com.vaadin.ui.Component;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.A_CmsAttributeAwareApp;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.dbmanager.CmsDbImportHTTP;
import org.opencms.ui.apps.dbmanager.CmsDbImportServer;
import org.opencms.ui.apps.dbmanager.I_CmsReportApp;
import org.opencms.ui.components.CmsBasicReportPage;
import org.opencms.util.CmsStringUtil;

public class CmsDbImportApp
extends A_CmsAttributeAwareApp
implements I_CmsReportApp {
    public static final String PATH_REPORT_HTTP = "reportHTTP";
    public static final String PATH_REPORT_SERVER = "reportserver";
    private IdentityHashMap<A_CmsReportThread, String> m_labels = new IdentityHashMap();
    private Map<String, A_CmsReportThread> m_reports = Maps.newHashMap();
    private Mode m_mode;

    public CmsDbImportApp(Mode mode) {
        this.m_mode = mode;
    }

    @Override
    public void goToMainView() {
        this.openSubView("", true);
    }

    @Override
    public void openReport(String path, A_CmsReportThread thread, String title) {
        this.m_reports.put(path, thread);
        this.m_labels.put(thread, title);
        this.openSubView(path, true);
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state) | state.startsWith(PATH_REPORT_HTTP) | state.startsWith(PATH_REPORT_SERVER)) {
            if (this.m_mode.equals((Object)Mode.HTTP)) {
                crumbs.put("", CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_IMPORTHTTP_ADMIN_TOOL_NAME_0", new Object[0]));
            } else {
                crumbs.put("", CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_IMPORTSERVER_ADMIN_TOOL_NAME_0", new Object[0]));
            }
            return crumbs;
        }
        return new LinkedHashMap<String, String>();
    }

    @Override
    protected Component getComponentForState(String state) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            if (this.m_mode.equals((Object)Mode.HTTP)) {
                return new CmsDbImportHTTP(this);
            }
            return new CmsDbImportServer(this);
        }
        if (state.startsWith(PATH_REPORT_SERVER) | state.startsWith(PATH_REPORT_HTTP)) {
            CmsBasicReportPage reportForm = new CmsBasicReportPage(this.m_labels.get(this.m_reports.get(state)), this.m_reports.get(state), new Runnable(){

                @Override
                public void run() {
                    CmsDbImportApp.this.openSubView("", true);
                }
            });
            reportForm.setHeight("100%");
            return reportForm;
        }
        return null;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    protected static enum Mode {
        HTTP,
        SERVER;

    }
}

