/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.dbmanager.CmsRemovePropertyFromResourcesThread;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.report.CmsReportWidget;

public class CmsPropertyDeleteDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = -3397853426667893254L;
    static Log LOG = CmsLog.getLog(CmsPropertyDeleteDialog.class.getName());
    protected List<CmsResource> m_resources;
    private VerticalLayout m_forceDeleteLayout;
    protected VerticalLayout m_start;
    private Label m_icon;
    protected Button m_cancelButton;
    protected Button m_okButton;
    protected CheckBox m_forceDelete;
    protected FormLayout m_threadReport;
    protected Panel m_report;
    private CmsObject m_cms;

    public CmsPropertyDeleteDialog(final String propName, final Window window, final Runnable runnable) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.displayResourceInfoDirectly(Collections.singletonList(new CmsResourceInfo(propName, "", (Resource)new CmsCssIcon("oc-icon-24-database"))));
        this.m_icon.setContentMode(ContentMode.HTML);
        this.m_icon.setValue(FontOpenCms.WARNING.getHtml());
        this.m_report.setVisible(false);
        try {
            this.m_resources = this.getCms().readResourcesWithProperty(propName);
            this.m_forceDeleteLayout.setVisible(!this.m_resources.isEmpty());
            this.m_okButton.setEnabled(this.m_resources.isEmpty());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 4788359189538313935L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
        this.m_forceDelete.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 7482690600008082762L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsPropertyDeleteDialog.this.m_okButton.setEnabled(((Boolean)CmsPropertyDeleteDialog.this.m_forceDelete.getValue()).booleanValue());
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -7861406021237202016L;

            public void buttonClick(Button.ClickEvent event) {
                if (!CmsPropertyDeleteDialog.this.m_resources.isEmpty()) {
                    CmsPropertyDeleteDialog.this.m_start.setVisible(false);
                    CmsPropertyDeleteDialog.this.m_report.setVisible(true);
                    CmsPropertyDeleteDialog.this.m_okButton.setEnabled(false);
                    CmsRemovePropertyFromResourcesThread thread = new CmsRemovePropertyFromResourcesThread(CmsPropertyDeleteDialog.this.getCms(), propName);
                    CmsPropertyDeleteDialog.this.m_threadReport.addComponent((Component)new CmsReportWidget(thread));
                    thread.start();
                    CmsPropertyDeleteDialog.this.m_cancelButton.setCaption(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CLOSE_0", new Object[0]));
                    CmsPropertyDeleteDialog.this.m_cancelButton.addClickListener(new Button.ClickListener(){

                        public void buttonClick(Button.ClickEvent event) {
                            runnable.run();
                        }
                    });
                    return;
                }
                try {
                    CmsPropertyDeleteDialog.this.getCms().deletePropertyDefinition(propName);
                    runnable.run();
                }
                catch (CmsException e) {
                    LOG.error((Object)"Unable to delete property definition", (Throwable)e);
                }
                window.close();
            }
        });
    }

    protected CmsObject getCms() {
        if (this.m_cms == null) {
            try {
                this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                this.m_cms.getRequestContext().setSiteRoot("");
            }
            catch (CmsException e) {
                return null;
            }
        }
        return this.m_cms;
    }
}

