/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.sitemanager.CmsSitesWebserverThread;

public class CmsRemovePropertyFromResourcesThread
extends A_CmsReportThread {
    static Log LOG = CmsLog.getLog(CmsSitesWebserverThread.class.getName());
    private String m_propName;

    public CmsRemovePropertyFromResourcesThread(CmsObject cms, String propName) {
        super(cms, "write-to-webserver");
        this.m_propName = propName;
        this.initHtmlReport(cms.getRequestContext().getLocale());
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        try {
            this.getReport().println(Messages.get().container("RPT_DATABASEAPP_DEL_PROPERTY_START_0"), 0);
            this.getReport().println();
            this.getReport().println(Messages.get().container("RPT_DATABASEAPP_DEL_PROPERTY_REMOVE_FROM_RESOURCE_START_0"), 0);
            for (CmsResource res : this.getCms().readResourcesWithProperty(this.m_propName)) {
                this.getReport().print(Messages.get().container("RPT_DATABASEAPP_DEL_PROPERTY_REMOVE_FROM_RESOURCE_1", res.getRootPath()), 0);
                CmsProperty prop = new CmsProperty(this.m_propName, "", "");
                try {
                    this.getCms().lockResource(res);
                    this.getCms().writePropertyObject(res.getRootPath(), prop);
                    this.getCms().unlockResource(res);
                    this.getReport().println(Messages.get().container("RPT_DATABASEAPP_OK_0"), 4);
                }
                catch (CmsException e) {
                    LOG.error((Object)"unable to remove property from resource", (Throwable)e);
                    this.getReport().println(Messages.get().container("RPT_DATABASEAPP_FAILED_0"), 5);
                }
            }
            try {
                this.getCms().deletePropertyDefinition(this.m_propName);
                this.getReport().println();
                this.getReport().println(Messages.get().container("RPT_DATABASEAPP_DEL_PROPERTY_END_OK_0"), 4);
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to delete property definition", (Throwable)e);
                this.getReport().println(Messages.get().container("RPT_DATABASEAPP_DEL_PROPERTY_END_FAILED_0"), 5);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to read resources for property", (Throwable)e);
            this.getReport().println(e);
        }
    }
}

