/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsResourceTypeStatResult {
    private int m_count;
    private String m_siteRoot;
    private long m_timestamp;
    private I_CmsResourceType m_type;

    public CmsResourceTypeStatResult(I_CmsResourceType type, String siteRoot, int count) {
        this.m_type = type;
        this.m_count = count;
        this.m_siteRoot = siteRoot;
        this.m_timestamp = System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CmsResourceTypeStatResult)) {
            return false;
        }
        CmsResourceTypeStatResult result = (CmsResourceTypeStatResult)o;
        if (this.m_type != null) {
            return this.m_type.equals(result.getType()) & this.m_siteRoot.equals(result.getSiteRoot());
        }
        return result.getType() == null & this.m_siteRoot.equals(result.getSiteRoot());
    }

    public String getResult() {
        CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(this.m_siteRoot);
        String res = site == null ? CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_STATS_RESULTS_ROOT_1", new Integer(this.m_count)) : CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_STATS_RESULTS_2", site.getTitle(), new Integer(this.m_count));
        return res;
    }

    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public I_CmsResourceType getType() {
        return this.m_type;
    }

    public String getTypeTitle() {
        if (this.m_type == null) {
            return CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_STATS_ALL_RESOURCES_0", new Object[0]);
        }
        String res = "";
        CmsExplorerTypeSettings typeSetting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.m_type.getTypeName());
        res = CmsVaadinUtils.getMessageText(typeSetting.getKey(), new Object[0]);
        return res;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

