/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.dbmanager.CmsResourceTypeStatResult;
import org.opencms.ui.apps.search.CmsSearchReplaceSettings;
import org.opencms.ui.apps.search.CmsSourceSearchApp;
import org.opencms.ui.apps.search.CmsSourceSearchForm;
import org.opencms.util.CmsDateUtil;

public class CmsResourceTypeStatResultList {
    private static final long MAX_TIME = 86400000L;
    private List<CmsResourceTypeStatResult> m_results = new ArrayList<CmsResourceTypeStatResult>();
    private boolean m_updated;

    public static CmsResourceTypeStatResultList init(CmsResourceTypeStatResultList resList) {
        if (resList == null) {
            return new CmsResourceTypeStatResultList();
        }
        resList.deleteOld();
        return resList;
    }

    public void addResult(CmsResourceTypeStatResult result) {
        if (!this.m_results.contains(result)) {
            this.m_results.add(result);
            this.m_updated = false;
        } else {
            this.m_results.remove(result);
            this.m_results.add(result);
            this.m_updated = true;
        }
    }

    public void deleteOld() {
        Iterator<CmsResourceTypeStatResult> iterator = this.m_results.iterator();
        while (iterator.hasNext()) {
            CmsResourceTypeStatResult res = iterator.next();
            if (!this.isToOld(res)) continue;
            iterator.remove();
        }
    }

    public boolean isEmpty() {
        return this.m_results.size() == 0;
    }

    public void setVerticalLayout(VerticalLayout layout, boolean addAll) {
        if (this.m_results.size() > 0) {
            if (addAll) {
                for (CmsResourceTypeStatResult result : this.m_results) {
                    layout.addComponent((Component)this.getLayoutFromResult(result), 0);
                }
            } else {
                CmsResourceTypeStatResult statResult = this.m_results.get(this.m_results.size() - 1);
                if (this.m_updated) {
                    this.removeRow(layout, statResult);
                }
                layout.addComponent((Component)this.getLayoutFromResult(statResult), 0);
            }
        }
    }

    private HorizontalLayout getLayoutFromResult(final CmsResourceTypeStatResult statResult) {
        HorizontalLayout hLayout = new HorizontalLayout();
        hLayout.setWidth("100%");
        hLayout.setHeight("60px");
        hLayout.addStyleName("o-report");
        Label result = new Label();
        result.setContentMode(ContentMode.HTML);
        result.addStyleName("v-scrollable");
        result.setValue(statResult.getResult());
        Label type = new Label();
        type.setWidth("200px");
        type.setContentMode(ContentMode.HTML);
        type.addStyleName("v-scrollable");
        type.setValue(statResult.getTypeTitle());
        Label time = new Label();
        time.setWidth("180px");
        time.setContentMode(ContentMode.HTML);
        time.addStyleName("v-scrollable");
        time.setValue(CmsDateUtil.getDateTime(new Date(statResult.getTimestamp()), 3, A_CmsUI.get().getLocale()));
        Button showList = new Button(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_STATS_LIST_0", new Object[0]));
        showList.setWidth("100px");
        showList.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 2665235403970750534L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSearchReplaceSettings settings = new CmsSearchReplaceSettings();
                settings.setPaths(Collections.singletonList("/"));
                settings.setSiteRoot(statResult.getSiteRoot());
                settings.setSearchpattern(".*");
                if (statResult.getType() != null) {
                    settings.setTypes(statResult.getType().getTypeName());
                }
                settings.setType(CmsSourceSearchForm.SearchType.fullText);
                CmsAppWorkplaceUi.get().getNavigator().navigateTo("source-search/" + CmsSourceSearchApp.generateState(settings));
            }
        });
        hLayout.addComponent((Component)type);
        hLayout.addComponent((Component)result);
        hLayout.addComponent((Component)time);
        hLayout.addComponent((Component)showList);
        hLayout.setExpandRatio((Component)result, 1.0f);
        hLayout.setData((Object)statResult);
        hLayout.setSpacing(true);
        hLayout.setComponentAlignment((Component)showList, Alignment.MIDDLE_CENTER);
        hLayout.setComponentAlignment((Component)time, Alignment.MIDDLE_CENTER);
        hLayout.setComponentAlignment((Component)result, Alignment.MIDDLE_CENTER);
        hLayout.setComponentAlignment((Component)type, Alignment.MIDDLE_CENTER);
        return hLayout;
    }

    private boolean isToOld(CmsResourceTypeStatResult res) {
        return System.currentTimeMillis() - res.getTimestamp() > 86400000L;
    }

    private void removeRow(VerticalLayout layout, CmsResourceTypeStatResult result) {
        Component componentToRemove = null;
        for (Component component : layout) {
            if (!(component instanceof HorizontalLayout) || !result.equals(((HorizontalLayout)component).getData())) continue;
            componentToRemove = component;
        }
        if (componentToRemove != null) {
            layout.removeComponent(componentToRemove);
        }
    }
}

