/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager.sqlconsole;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CmsSqlConsoleResults {
    private List<String> m_columns;
    private List<List<Object>> m_data;

    public CmsSqlConsoleResults(List<String> columns, List<List<Object>> data) {
        this.m_columns = columns;
        this.m_data = data;
    }

    public List<String> getColumns() {
        return this.m_columns;
    }

    public Class<?> getColumnType(int c) {
        for (int r = 0; r < this.m_data.size(); ++r) {
            Object val = this.m_data.get(r).get(c);
            if (val == null) continue;
            return val.getClass();
        }
        return Object.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCsv() {
        StringWriter writer = new StringWriter();
        try (CSVWriter csv = new CSVWriter((Writer)writer);){
            ArrayList<String> headers = new ArrayList<String>();
            for (String string2 : this.m_columns) {
                headers.add(string2);
            }
            csv.writeNext(headers.toArray(new String[0]));
            for (List list : this.m_data) {
                ArrayList<String> colCsv = new ArrayList<String>();
                for (Object col : list) {
                    colCsv.add(String.valueOf(col));
                }
                csv.writeNext(colCsv.toArray(new String[0]));
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<List<Object>> getData() {
        return this.m_data;
    }
}

