/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.filehistory;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.OptionGroup;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.filehistory.CmsFileHistoryClearApp;
import org.opencms.ui.apps.filehistory.CmsHistoryClearThread;
import org.opencms.ui.components.CmsDateField;
import org.opencms.ui.report.CmsReportWidget;
import org.opencms.util.CmsStringUtil;

public class CmsFileHistoryClear
extends VerticalLayout {
    private static final long serialVersionUID = 1484327372474823882L;
    private static final int VERSIONS_MAX = 50;
    ComboBox m_numberVersionsToKeep;
    private CmsDateField m_dateField;
    private OptionGroup m_mode;
    private Button m_ok;
    private Panel m_optionPanel;
    private Panel m_reportPanel;
    private Label m_settedVersions;

    public CmsFileHistoryClear(CmsFileHistoryClearApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.setupVersionSettingsLabel();
        this.setupVersionsToKeepComboBox();
        this.setupModeOptions();
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -6314367378702836242L;

            public void buttonClick(Button.ClickEvent event) {
                CmsFileHistoryClear.this.startCleanAndShowReport();
            }
        });
    }

    void startCleanAndShowReport() {
        A_CmsReportThread thread = this.startThread();
        this.m_optionPanel.setVisible(false);
        this.m_reportPanel.setVisible(true);
        CmsReportWidget report = new CmsReportWidget(thread);
        report.setWidth("100%");
        report.setHeight("700px");
        this.m_reportPanel.setContent((Component)report);
        this.m_ok.setEnabled(false);
    }

    private void setupModeOptions() {
        int versionsDeleted = OpenCms.getSystemInfo().getHistoryVersionsAfterDeletion();
        String mode = versionsDeleted == 0 ? "disabled" : (versionsDeleted == 1 ? "withoutversions" : (versionsDeleted > 1 || versionsDeleted == -1 ? "withversions" : "disabled"));
        this.m_mode.setValue((Object)mode);
    }

    private void setupVersionSettingsLabel() {
        int numberHistoryVersions = OpenCms.getSystemInfo().getHistoryVersions();
        String numberString = String.valueOf(numberHistoryVersions);
        if (numberHistoryVersions == -2) {
            numberString = CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_SETTINGS_VERSIONS_DISABLED_0", new Object[0]);
        }
        if (numberHistoryVersions == -1) {
            numberString = CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_SETTINGS_VERSIONS_UNLIMITED_0", new Object[0]);
        }
        this.m_settedVersions.setContentMode(ContentMode.HTML);
        this.m_settedVersions.setValue(CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_DELETE_VERSIONINFO_1", numberString));
    }

    private void setupVersionsToKeepComboBox() {
        int i;
        final ArrayList<Integer> items = new ArrayList<Integer>();
        for (i = 0; i < 10; ++i) {
            this.m_numberVersionsToKeep.addItem((Object)new Integer(i));
            items.add(new Integer(i));
        }
        for (i = 10; i <= 50; i += 5) {
            this.m_numberVersionsToKeep.addItem((Object)new Integer(i));
            items.add(new Integer(i));
        }
        this.m_numberVersionsToKeep.setPageLength(this.m_numberVersionsToKeep.size());
        this.m_numberVersionsToKeep.setNullSelectionAllowed(false);
        this.m_numberVersionsToKeep.setTextInputAllowed(true);
        this.m_numberVersionsToKeep.setNewItemsAllowed(true);
        this.m_numberVersionsToKeep.setNewItemHandler(new AbstractSelect.NewItemHandler(){
            private static final long serialVersionUID = -1962380117946789444L;

            public void addNewItem(String newItemCaption) {
                int num = CmsStringUtil.getIntValue(newItemCaption, -1, "user entered version number is not a number");
                if (num > 1 && !items.contains(new Integer(num))) {
                    CmsFileHistoryClear.this.m_numberVersionsToKeep.addItem((Object)new Integer(num));
                    CmsFileHistoryClear.this.m_numberVersionsToKeep.select((Object)new Integer(num));
                }
            }
        });
        int numberHistoryVersions = OpenCms.getSystemInfo().getHistoryVersions();
        if (numberHistoryVersions == -2) {
            numberHistoryVersions = 0;
        }
        if (numberHistoryVersions == -1) {
            numberHistoryVersions = 50;
        }
        this.m_numberVersionsToKeep.select((Object)new Integer(numberHistoryVersions));
    }

    private A_CmsReportThread startThread() {
        int versions;
        int versionsDeleted = versions = ((Integer)this.m_numberVersionsToKeep.getValue()).intValue();
        if (this.m_mode.getValue().equals("disabled")) {
            versionsDeleted = 0;
        }
        if (this.m_mode.getValue().equals("withoutversions")) {
            versionsDeleted = 1;
        }
        long date = this.m_dateField.getValue() != null ? this.m_dateField.getDate().getTime() : 0L;
        CmsHistoryClearThread thread = new CmsHistoryClearThread(A_CmsUI.getCmsObject(), versions, versionsDeleted, date);
        thread.start();
        return thread;
    }
}

