/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.filehistory;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.OptionGroup;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.filehistory.CmsFileHistoryApp;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsFileHistorySettings
extends VerticalLayout {
    private static final long serialVersionUID = 5595583577732283758L;
    private Button m_edit;
    private OptionGroup m_mode;
    private ComboBox m_numberVersions;
    private Panel m_statusPanel;

    public CmsFileHistorySettings(final CmsFileHistoryApp app, String state) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_edit.setEnabled(false);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            this.m_statusPanel.setVisible(false);
        } else {
            Label status = new Label();
            status.setWidth("100%");
            status.setContentMode(ContentMode.HTML);
            if (state.startsWith("settings_invalid")) {
                status.setValue("<p width='100%' align='center' style='color:#FF0000;'>" + CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_SETTINGS_INVALID_0", new Object[0]) + "</p>");
            } else {
                status.setValue("<p width='100%' align='center'>Settings saved</p>");
            }
            this.m_statusPanel.setContent((Component)status);
        }
        this.setupVersionComboBox();
        this.setupModeOptions();
        Property.ValueChangeListener changeListener = new Property.ValueChangeListener(){
            private static final long serialVersionUID = -6003215873244541851L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsFileHistorySettings.this.setButtonEnabled(true);
            }
        };
        this.m_numberVersions.addValueChangeListener(changeListener);
        this.m_mode.addValueChangeListener(changeListener);
        this.m_edit.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 161296255232053110L;

            public void buttonClick(Button.ClickEvent event) {
                if (CmsFileHistorySettings.this.saveOptions()) {
                    CmsFileHistorySettings.this.setButtonEnabled(false);
                } else {
                    app.openSubView("settings_invalid", true);
                }
            }
        });
    }

    protected void setButtonEnabled(boolean enable) {
        this.m_edit.setEnabled(enable);
    }

    boolean saveOptions() {
        int versions;
        boolean enabled = ((ComboBoxVersionsBean)this.m_numberVersions.getValue()).getValue() != -2;
        int versionsDeleted = versions = ((ComboBoxVersionsBean)this.m_numberVersions.getValue()).getValue();
        if (this.m_mode.getValue().equals("disabled")) {
            versionsDeleted = 0;
        }
        if (this.m_mode.getValue().equals("withoutversions")) {
            versionsDeleted = 1;
        }
        if (this.m_mode.getValue().equals("withversions") && versions == -2) {
            return false;
        }
        OpenCms.getSystemInfo().setVersionHistorySettings(enabled, versions, versionsDeleted);
        OpenCms.writeConfiguration(CmsSystemConfiguration.class);
        return true;
    }

    private void setupModeOptions() {
        int versionsDeleted = OpenCms.getSystemInfo().getHistoryVersionsAfterDeletion();
        String mode = versionsDeleted == 0 ? "disabled" : (versionsDeleted == 1 ? "withoutversions" : (versionsDeleted > 1 || versionsDeleted == -1 ? "withversions" : "disabled"));
        this.m_mode.setValue((Object)mode);
    }

    private void setupVersionComboBox() {
        int i;
        ArrayList<ComboBoxVersionsBean> beans = new ArrayList<ComboBoxVersionsBean>();
        beans.add(new ComboBoxVersionsBean(-2));
        for (i = 1; i <= 10; ++i) {
            beans.add(new ComboBoxVersionsBean(i));
        }
        for (i = 15; i <= 50; i += 5) {
            beans.add(new ComboBoxVersionsBean(i));
        }
        beans.add(new ComboBoxVersionsBean(-1));
        BeanItemContainer objects = new BeanItemContainer(ComboBoxVersionsBean.class, beans);
        this.m_numberVersions.setContainerDataSource((Container)objects);
        this.m_numberVersions.setItemCaptionPropertyId((Object)"displayValue");
        this.m_numberVersions.setNullSelectionAllowed(false);
        this.m_numberVersions.setTextInputAllowed(false);
        this.m_numberVersions.setPageLength(beans.size());
        int numberHistoryVersions = OpenCms.getSystemInfo().getHistoryVersions();
        this.m_numberVersions.setValue(beans.get(beans.indexOf(new ComboBoxVersionsBean(numberHistoryVersions))));
    }

    public class ComboBoxVersionsBean {
        private int m_val;

        public ComboBoxVersionsBean(int value) {
            this.m_val = value;
        }

        public boolean equals(Object o) {
            if (o instanceof ComboBoxVersionsBean) {
                return ((ComboBoxVersionsBean)o).getValue() == this.m_val;
            }
            return false;
        }

        public String getDisplayValue() {
            if (this.m_val == -2) {
                return CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_SETTINGS_VERSIONS_DISABLED_0", new Object[0]);
            }
            if (this.m_val == -1) {
                return CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_SETTINGS_VERSIONS_UNLIMITED_0", new Object[0]);
            }
            return String.valueOf(this.m_val);
        }

        public int getValue() {
            return this.m_val;
        }

        public int hashCode() {
            return CmsUUID.getNullUUID().hashCode();
        }
    }
}

