/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.filehistory;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.Messages;

public class CmsHistoryClearThread
extends A_CmsReportThread {
    static Log LOG = CmsLog.getLog(CmsHistoryClearThread.class.getName());
    private long m_dateClearDeletedOlder;
    private int m_keepDeletedVersions;
    private int m_keepVersions;

    public CmsHistoryClearThread(CmsObject cms, int keepV, int keepD, long date) {
        super(cms, CmsVaadinUtils.getMessageText("GUI_FILEHISTORY_DELETE_THREAD_NAME_1", cms.getRequestContext().getCurrentProject().getName()));
        this.m_keepVersions = keepV;
        this.m_keepDeletedVersions = keepD;
        this.m_dateClearDeletedOlder = date;
        this.initHtmlReport(cms.getRequestContext().getLocale());
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        LOG.info((Object)("Start delete history thread from user " + this.getCms().getRequestContext().getCurrentUser().getName()));
        LOG.info((Object)("Parameter: m_keepVersions=" + this.m_keepVersions + ", m_keepDeletedVersions=" + this.m_keepDeletedVersions + ", m_dateClearDeletedOlder=" + this.m_dateClearDeletedOlder));
        this.getReport().println(Messages.get().container("RPT_DELETE_FILEHISTORY_BEGIN_0"), 2);
        if (this.m_dateClearDeletedOlder == 0L) {
            this.m_dateClearDeletedOlder = -1L;
        }
        try {
            this.getCms().deleteHistoricalVersions(this.m_keepVersions, this.m_keepDeletedVersions, this.m_dateClearDeletedOlder, this.getReport());
            LOG.info((Object)"Delete history thread successfully finished.");
        }
        catch (CmsException e) {
            this.getReport().println(e);
            LOG.error((Object)"Delete history thread stoped because of exceptions", (Throwable)e);
        }
        LOG.info((Object)"Delete history thread closed.");
        this.getReport().println(Messages.get().container("RPT_DELETE_FILEHISTORY_END_0"), 2);
    }
}

