/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.linkvalidation;

import com.google.common.collect.Multimap;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Window;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.linkvalidation.A_CmsLinkValidator;
import org.opencms.ui.apps.linkvalidation.CmsInternalResources;
import org.opencms.ui.apps.linkvalidation.CmsLinkValidationInternalTable;
import org.opencms.ui.apps.linkvalidation.CmsResourceListDialog;
import org.opencms.ui.apps.linkvalidation.I_CmsUpdatableComponent;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.ui.dialogs.CmsDeleteDialog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsLinkInFolderValidationApp
extends A_CmsWorkplaceApp
implements I_CmsUpdatableComponent {
    static final Log LOG = CmsLog.getLog(CmsLinkInFolderValidationApp.class);
    private CmsStateBean m_stateBean;
    Button m_revertButton;
    private CmsLinkValidationInternalTable m_table;
    private CmsInternalResources m_resourceSelector;

    @Override
    public void update(List<String> resources) {
        this.openSubView(new CmsStateBean(resources, CmsVaadinUtils.isButtonPressed(this.m_revertButton)).getState(), true);
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        return null;
    }

    @Override
    protected Component getComponentForState(String state) {
        this.m_stateBean = CmsStateBean.parseState(state);
        if (this.m_revertButton == null) {
            this.addToolbars();
        }
        this.m_rootLayout.setMainHeightFull(true);
        HorizontalSplitPanel panel = new HorizontalSplitPanel();
        VerticalLayout result = new VerticalLayout();
        result.setSizeFull();
        VerticalLayout intro = CmsVaadinUtils.getInfoLayout("GUI_LINKVALIDATION_CHECK_FOLDER_RELATIONS_INTRO_0");
        VerticalLayout nullResult = CmsVaadinUtils.getInfoLayout("GUI_LINKVALIDATION_CHECK_FOLDER_RELATIONS_NO_RESULT_0");
        nullResult.setVisible(false);
        this.m_table = new CmsLinkValidationInternalTable((Component)intro, (Component)nullResult, new InFolderValidator());
        this.m_table.setVisible(false);
        this.m_table.setSizeFull();
        this.m_table.setWidth("100%");
        result.addComponent((Component)this.m_table);
        result.addComponent((Component)intro);
        result.addComponent((Component)nullResult);
        this.m_table.setVisible(false);
        this.m_table.setSizeFull();
        this.m_table.setWidth("100%");
        this.m_resourceSelector = new CmsInternalResources(this);
        panel.setFirstComponent((Component)this.m_resourceSelector);
        panel.setSecondComponent((Component)result);
        panel.setSplitPosition(399.0f, Sizeable.Unit.PIXELS);
        if (!this.m_stateBean.getResources().isEmpty()) {
            this.m_table.update(this.m_stateBean.getResources());
            this.m_resourceSelector.clearResources();
            for (String resource : this.m_stateBean.getResources()) {
                this.m_resourceSelector.addResource(resource);
            }
        }
        return panel;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    protected void toggleTable() {
        CmsVaadinUtils.toggleButton(this.m_revertButton);
        this.openSubView(new CmsStateBean(this.m_stateBean.getResources(), CmsVaadinUtils.isButtonPressed(this.m_revertButton)).getState(), true);
    }

    private void addToolbars() {
        this.m_revertButton = CmsToolBar.createButton((Resource)FontOpenCms.REDO, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GROUPS_TOGGLE_0", new Object[0]));
        this.m_revertButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 8265075332953321274L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLinkInFolderValidationApp.this.toggleTable();
            }
        });
        if (this.m_stateBean.isReverse()) {
            CmsVaadinUtils.toggleButton(this.m_revertButton);
        }
        this.m_uiContext.addToolbarButton((Component)this.m_revertButton);
    }

    static class CmsStateBean {
        protected static String STATE_SEPERATOR = "!!";
        private static String RESOURCE_SEPERATOR = ";";
        private List<String> m_resources;
        private boolean m_reverse;
        private CmsObject m_cms = null;

        public CmsStateBean(List<String> resources, boolean reverse) {
            this.setCmsObject();
            this.m_resources = resources;
            this.m_reverse = reverse;
        }

        public CmsStateBean(String resources, boolean reverse) {
            this.setCmsObject();
            this.m_resources = this.getResourcesFromState(resources);
            this.m_reverse = reverse;
        }

        public static CmsStateBean parseState(String state) {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
                return new CmsStateBean(Collections.emptyList(), false);
            }
            String[] parameter = state.split(STATE_SEPERATOR);
            boolean reverse = false;
            if (parameter.length > 1) {
                reverse = Boolean.parseBoolean(parameter[1]);
            }
            return new CmsStateBean(parameter[0], reverse);
        }

        public List<String> getResources() {
            return this.m_resources;
        }

        public String getState() {
            return this.getResourceString() + STATE_SEPERATOR + new Boolean(this.m_reverse).toString();
        }

        public boolean isReverse() {
            return this.m_reverse;
        }

        private List<String> getResourcesFromState(String resources) {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(resources)) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<String> res = new ArrayList<String>();
            for (String uuidString : resources.split(RESOURCE_SEPERATOR)) {
                try {
                    res.add(this.m_cms.readResource(new CmsUUID(uuidString)).getRootPath());
                }
                catch (CmsException e) {
                    LOG.error((Object)"Can not read resource from state", (Throwable)e);
                }
            }
            return res;
        }

        private String getResourceString() {
            String res = "";
            try {
                for (String resource : this.m_resources) {
                    res = res + this.m_cms.readResource(resource).getStructureId().getStringValue() + RESOURCE_SEPERATOR;
                }
            }
            catch (CmsException e) {
                LOG.error((Object)"Can't read resource", (Throwable)e);
            }
            return res.length() > 1 ? res.substring(0, res.length() - 1) : res;
        }

        private void setCmsObject() {
            if (this.m_cms == null) {
                try {
                    this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                    this.m_cms.getRequestContext().setSiteRoot("");
                }
                catch (CmsException e) {
                    this.m_cms = A_CmsUI.getCmsObject();
                }
            }
        }
    }

    public class InFolderValidator
    extends A_CmsLinkValidator {
        Multimap<CmsResource, CmsResource> brokenResources;

        @Override
        public List<CmsResource> failedResources(List<String> resources) {
            try {
                CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                cms.getRequestContext().setSiteRoot("");
                ArrayList<CmsResource> res = new ArrayList<CmsResource>();
                for (String resource : resources) {
                    if (!cms.existsResource(resource)) continue;
                    res.add(cms.readResource(resource));
                }
                this.brokenResources = CmsDeleteDialog.getBrokenLinks(cms, res, false, CmsVaadinUtils.isButtonPressed(CmsLinkInFolderValidationApp.this.m_revertButton));
                return new ArrayList<CmsResource>(this.brokenResources.keySet());
            }
            catch (CmsException e) {
                return new ArrayList<CmsResource>();
            }
        }

        @Override
        public String failMessage(CmsResource resource) {
            if (this.brokenResources.size() == 0) {
                return "";
            }
            return ((CmsResource)this.brokenResources.get((Object)resource).iterator().next()).getRootPath();
        }

        @Override
        public ItemClickEvent.ItemClickListener getClickListener() {
            return new ItemClickEvent.ItemClickListener(){
                private static final long serialVersionUID = -7729459896374968941L;

                public void itemClick(ItemClickEvent event) {
                    if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT)) {
                        return;
                    }
                    if (!InFolderValidator.this.property.equals(event.getPropertyId())) {
                        return;
                    }
                    try {
                        CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                        cms.getRequestContext().setSiteRoot("");
                        CmsResource resource = cms.readResource(new CmsUUID((String)event.getItemId()));
                        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                        window.setCaption(CmsVaadinUtils.getMessageText(InFolderValidator.this.getCaptionKey(), new Object[0]));
                        window.setContent((Component)new CmsResourceListDialog(new ArrayList<CmsResource>(InFolderValidator.this.brokenResources.get((Object)resource))));
                        A_CmsUI.get().addWindow(window);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)"Unable to show detail resources", (Throwable)e);
                    }
                }
            };
        }

        @Override
        public String getPropertyName() {
            return "Relations";
        }

        @Override
        public Map<CmsResourceTableProperty, Integer> getTableProperties() {
            this.property = new CmsResourceTableProperty(this.getPropertyName(), String.class, "", this.getCaptionKey(), true, 0.0f, 200);
            LinkedHashMap<CmsResourceTableProperty, Integer> res = new LinkedHashMap<CmsResourceTableProperty, Integer>(CmsFileTable.DEFAULT_TABLE_PROPERTIES);
            res.put(this.property, 0);
            return res;
        }

        String getCaptionKey() {
            return "GUI_LINKVALIDATION_CHECK_FOLDER_RELATIONS_COLUMN_HEADER_0";
        }
    }
}

