/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.linkvalidation;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsExternalLinksValidationResult;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.linkvalidation.CmsExternalLinksValidatorThread;
import org.opencms.ui.report.CmsReportWidget;

public class CmsLinkValidationExternal
extends VerticalLayout {
    private static final long serialVersionUID = 4901058101922988640L;
    private Button m_exec;
    private Label m_oldReport;
    private FormLayout m_threadReport;

    protected CmsLinkValidationExternal() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_oldReport.setContentMode(ContentMode.HTML);
        this.m_oldReport.setHeight("500px");
        this.m_oldReport.addStyleName("v-scrollable");
        this.m_oldReport.addStyleName("o-report");
        CmsExternalLinksValidationResult result = OpenCms.getLinkManager().getPointerLinkValidationResult();
        if (result == null) {
            this.m_oldReport.setValue(CmsVaadinUtils.getMessageText("GUI_LINKVALIDATION_NO_VALIDATION_YET_0", new Object[0]));
        } else {
            this.m_oldReport.setValue(result.toHtml(OpenCms.getWorkplaceManager().getWorkplaceLocale(A_CmsUI.getCmsObject())));
        }
        this.m_exec.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -3281073871585942686L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLinkValidationExternal.this.startValidation();
            }
        });
    }

    void enableButton() {
        this.m_exec.setEnabled(true);
    }

    void startValidation() {
        this.m_oldReport.setVisible(false);
        this.m_threadReport.removeAllComponents();
        CmsExternalLinksValidatorThread thread = new CmsExternalLinksValidatorThread(A_CmsUI.getCmsObject(), new Runnable(){

            @Override
            public void run() {
                CmsLinkValidationExternal.this.enableButton();
            }
        });
        thread.start();
        CmsReportWidget reportWidget = new CmsReportWidget(thread);
        reportWidget.setHeight("500px");
        this.m_threadReport.addComponent((Component)reportWidget);
        this.m_exec.setEnabled(false);
    }
}

