/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.lists;

import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.util.converter.StringToDateConverter;
import com.vaadin.v7.ui.AbstractSelect;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.search.CmsSearchResource;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.I_CmsContextProvider;
import org.opencms.ui.apps.lists.CmsListManager;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsResourceTable;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsResultTable
extends CmsFileTable {
    protected static final String ID_SEPARATOR = ":";
    private static final long serialVersionUID = 5680421086123351830L;
    private Locale m_contentLocale;
    private String m_dateFieldKey;

    public CmsResultTable(I_CmsContextProvider contextProvider, Map<CmsResourceTableProperty, Integer> tableColumns) {
        super(contextProvider, tableColumns);
        this.m_fileTable.setConverter((Object)CmsListManager.INSTANCEDATE_PROPERTY, (Converter)new StringToDateConverter(){
            private static final long serialVersionUID = 1L;

            protected DateFormat getFormat(Locale locale) {
                return new SimpleDateFormat(CmsVaadinUtils.getMessageText("GUI_LISTMANAGER_DATE_FORMAT_0", new Object[0]));
            }
        });
    }

    public String getCurrentPageFirstItemId() {
        return (String)this.m_fileTable.getCurrentPageFirstItemId();
    }

    public List<Item> getSelectedItems() {
        Collection ids = (Collection)this.m_fileTable.getValue();
        ArrayList<Item> items = new ArrayList<Item>();
        for (Object id : ids) {
            if (!this.m_container.containsId(id)) continue;
            items.add(this.m_container.getItem(id));
        }
        return items;
    }

    @Override
    public CmsUUID getUUIDFromItemID(String itemId) {
        if (itemId.contains(ID_SEPARATOR)) {
            return super.getUUIDFromItemID(itemId.substring(0, itemId.indexOf(ID_SEPARATOR)));
        }
        return super.getUUIDFromItemID(itemId);
    }

    public void setContentLocale(Locale locale) {
        this.m_contentLocale = locale;
        this.m_dateFieldKey = "instancedate_" + this.m_contentLocale.toString() + "_dt";
    }

    public void setCurrentPageFirstItemId(String itemId) {
        this.m_fileTable.setCurrentPageFirstItemId((Object)itemId);
    }

    public void setsetItemDescriptionGenerator(AbstractSelect.ItemDescriptionGenerator generator) {
        this.m_fileTable.setItemDescriptionGenerator(generator);
    }

    @Override
    public void update(Collection<CmsUUID> ids, boolean remove) {
    }

    @Override
    protected void fillItem(CmsObject cms, CmsResource resource, Locale locale) {
        if (resource instanceof CmsSearchResource) {
            Item resourceItem;
            String instanceDate = ((CmsSearchResource)resource).getField(this.m_dateFieldKey);
            String itemId = resource.getStructureId().toString();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(instanceDate)) {
                itemId = itemId + ID_SEPARATOR + instanceDate;
            }
            if ((resourceItem = this.m_container.getItem(itemId)) == null) {
                resourceItem = this.m_container.addItem(itemId);
            }
            CmsResultTable.fillItemDefault(resourceItem, cms, resource, locale);
            for (CmsResourceTable.I_ResourcePropertyProvider provider : this.m_propertyProviders) {
                provider.addItemProperties(resourceItem, cms, resource, locale);
            }
        } else {
            super.fillItem(cms, resource, locale);
        }
    }

    protected String getDateFieldKey() {
        return this.m_dateFieldKey;
    }
}

