/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.logfile;

import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.logfile.CmsLogFileApp;
import org.opencms.ui.apps.logfile.CmsLogFileOptionProvider;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.util.CmsStringUtil;

public class CmsLogDownloadDialog
extends CmsBasicDialog {
    private static Log LOG = CmsLog.getLog(CmsLogDownloadDialog.class.getName());
    private static final long serialVersionUID = -7447640082260176245L;
    private static final String ZIP_PATH = CmsLogFileApp.LOG_FOLDER + "logs.zip";
    protected FileDownloader m_downloader;
    private Button m_cancel;
    private CheckBox m_donwloadAll;
    private ComboBox m_file;
    private Button m_ok;
    private double m_totalSize;

    public CmsLogDownloadDialog(final Window window, String filePath) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_totalSize = 0.0;
        for (File file : CmsLogFileOptionProvider.getLogFiles()) {
            if (file.getAbsolutePath().endsWith(".zip")) continue;
            this.m_file.addItem((Object)file.getAbsolutePath());
            this.m_totalSize += (double)(file.length() / 0x100000L);
        }
        this.m_donwloadAll.setVisible(this.m_totalSize < 150.0);
        this.m_file.setFilteringMode(FilteringMode.CONTAINS);
        this.m_file.setNullSelectionAllowed(false);
        this.m_file.setNewItemsAllowed(false);
        this.m_file.select((Object)filePath);
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 4336654148546091114L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
        this.m_downloader = new FileDownloader(this.getDownloadResource());
        this.m_downloader.extend((AbstractComponent)this.m_ok);
        Property.ValueChangeListener listener = new Property.ValueChangeListener(){
            private static final long serialVersionUID = -1127012396158402096L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsLogDownloadDialog.this.m_downloader.setFileDownloadResource(CmsLogDownloadDialog.this.getDownloadResource());
                CmsLogDownloadDialog.this.setComboBoxEnable();
            }
        };
        this.m_file.addValueChangeListener(listener);
        this.m_donwloadAll.addValueChangeListener(listener);
    }

    protected Resource getDownloadResource() {
        String pathToDownload = (String)this.m_file.getValue();
        if (((Boolean)this.m_donwloadAll.getValue()).booleanValue()) {
            pathToDownload = ZIP_PATH;
            this.writeZipFile();
        }
        final File downloadFile = new File(pathToDownload);
        return new StreamResource(new StreamResource.StreamSource(){
            private static final long serialVersionUID = -8868657402793427460L;

            public InputStream getStream() {
                try {
                    return new FileInputStream(downloadFile);
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        }, downloadFile.getName());
    }

    protected void setComboBoxEnable() {
        this.m_file.setEnabled((Boolean)this.m_donwloadAll.getValue() == false);
    }

    private void writeZipFile() {
        try {
            FileOutputStream fos = new FileOutputStream(ZIP_PATH);
            ZipGenerator zipGen = new ZipGenerator(fos);
            for (File file : CmsLogFileOptionProvider.getLogFiles()) {
                if (!(!file.isDirectory() & !ZIP_PATH.equals(file.getAbsolutePath()))) continue;
                zipGen.addToZip(new File(CmsLogFileApp.LOG_FOLDER), file);
            }
            zipGen.close();
            fos.close();
        }
        catch (IOException e) {
            LOG.error((Object)"unable to build zip file", (Throwable)e);
        }
    }

    class ZipGenerator {
        private Set<String> m_directories = new HashSet<String>();
        private ZipOutputStream m_zos;

        public ZipGenerator(OutputStream output) {
            this.m_zos = new ZipOutputStream(output);
        }

        public void addToZip(File directory, File file) throws IOException {
            int length;
            String zipFilePath;
            String filePath;
            FileInputStream fis = new FileInputStream(file);
            String dirPath = directory.getCanonicalPath();
            if (CmsStringUtil.isPrefixPath(dirPath, filePath = file.getCanonicalPath())) {
                zipFilePath = filePath.substring(dirPath.length() + 1, filePath.length());
            } else {
                String parentName = this.generateParentName(file);
                if (!this.m_directories.contains(parentName)) {
                    this.m_zos.putNextEntry(new ZipEntry(parentName));
                }
                this.m_directories.add(parentName);
                zipFilePath = CmsStringUtil.joinPaths(parentName, file.getName());
            }
            ZipEntry zipEntry = new ZipEntry(zipFilePath);
            this.m_zos.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                this.m_zos.write(bytes, 0, length);
            }
            this.m_zos.closeEntry();
            fis.close();
        }

        public void close() throws IOException {
            this.m_zos.close();
        }

        String generateParentName(File file) {
            ArrayList<String> pathComponents = new ArrayList<String>();
            for (int i = 0; i < file.toPath().getNameCount() - 1; ++i) {
                pathComponents.add(file.toPath().getName(i).toString());
            }
            return CmsStringUtil.listAsString(pathComponents, "_") + "/";
        }
    }
}

