/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.logfile;

import com.vaadin.data.HasValue;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.File;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.core.Appender;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.logfile.CmsLogChannelTable;
import org.opencms.ui.apps.logfile.CmsLogDownloadDialog;
import org.opencms.ui.apps.logfile.CmsLogFileView;
import org.opencms.ui.apps.logfile.CmsLogFileViewSettings;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.util.CmsStringUtil;

public class CmsLogFileApp
extends A_CmsWorkplaceApp {
    protected static final String LOG_FOLDER = OpenCms.getSystemInfo().getLogFileRfsPath() == null ? "" : OpenCms.getSystemInfo().getLogFileRfsPath().substring(0, OpenCms.getSystemInfo().getLogFileRfsPath().lastIndexOf(File.separatorChar) + 1);
    static String PATH_LOGCHANNEL = "log-channel";
    private static Log LOG = CmsLog.getLog(CmsLogFileApp.class);
    protected CmsLogFileView m_fileView;
    private TextField m_tableFilter;

    protected static String getFileName(Appender app) {
        String result = null;
        try {
            Method getFileName = app.getClass().getDeclaredMethod("getFileName", null);
            result = (String)getFileName.invoke((Object)app, (Object[])null);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    protected static boolean isFileAppender(Appender appender) {
        boolean result = false;
        try {
            Method getFileNameMethod = appender.getClass().getDeclaredMethod("getFileName", null);
            result = getFileNameMethod != null;
        }
        catch (Exception e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public void initUI(I_CmsAppUIContext context) {
        context.addPublishButton(updatedItems -> {});
        super.initUI(context);
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_LOGFILE_VIEW_TOOL_NAME_0", new Object[0]));
            return crumbs;
        }
        if (state.equals(PATH_LOGCHANNEL)) {
            crumbs.put("logfile-app", CmsVaadinUtils.getMessageText("GUI_LOGFILE_VIEW_TOOL_NAME_0", new Object[0]));
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_LOGFILE_LOGSETTINGS_TOOL_NAME_0", new Object[0]));
            return crumbs;
        }
        return new LinkedHashMap<String, String>();
    }

    @Override
    protected Component getComponentForState(String state) {
        if (this.m_tableFilter != null) {
            this.m_infoLayout.removeComponent((Component)this.m_tableFilter);
            this.m_tableFilter = null;
        }
        if (state.isEmpty()) {
            this.m_rootLayout.setMainHeightFull(true);
            this.m_fileView = new CmsLogFileView(this);
            this.addDownloadButton(this.m_fileView);
            this.addSettingsButton();
            this.addChannelButton();
            this.addRefreshButton();
            return this.m_fileView;
        }
        this.m_uiContext.clearToolbarButtons();
        if (state.equals(PATH_LOGCHANNEL)) {
            this.m_rootLayout.setMainHeightFull(true);
            final CmsLogChannelTable channelTable = new CmsLogChannelTable();
            this.m_tableFilter = new TextField();
            this.m_tableFilter.setIcon((Resource)FontOpenCms.FILTER);
            this.m_tableFilter.setPlaceholder(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
            this.m_tableFilter.addStyleName("inline-icon");
            this.m_tableFilter.setWidth("200px");
            this.m_tableFilter.setValueChangeMode(ValueChangeMode.TIMEOUT);
            this.m_tableFilter.setValueChangeTimeout(400);
            this.m_tableFilter.addValueChangeListener((HasValue.ValueChangeListener)new HasValue.ValueChangeListener<String>(){
                private static final long serialVersionUID = 1L;

                public void valueChange(HasValue.ValueChangeEvent<String> event) {
                    channelTable.filterTable((String)event.getValue());
                }
            });
            this.m_infoLayout.addComponent((Component)this.m_tableFilter);
            return channelTable;
        }
        return null;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    private void addChannelButton() {
        Button button = CmsToolBar.createButton((Resource)FontOpenCms.LOG, CmsVaadinUtils.getMessageText("GUI_LOGFILE_LOGSETTINGS_TOOL_NAME_0", new Object[0]));
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLogFileApp.this.openSubView(PATH_LOGCHANNEL, true);
            }
        });
        this.m_uiContext.addToolbarButton((Component)button);
    }

    private void addDownloadButton(final CmsLogFileView view) {
        Button button = CmsToolBar.createButton((Resource)FontOpenCms.DOWNLOAD, CmsVaadinUtils.getMessageText("GUI_LOGFILE_DOWNLOAD_0", new Object[0]));
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                window.setCaption(CmsVaadinUtils.getMessageText("GUI_LOGFILE_DOWNLOAD_0", new Object[0]));
                window.setContent((Component)new CmsLogDownloadDialog(window, view.getCurrentFile()));
                A_CmsUI.get().addWindow(window);
            }
        });
        this.m_uiContext.addToolbarButton((Component)button);
    }

    private void addRefreshButton() {
        Button button = CmsToolBar.createButton((Resource)FontOpenCms.RESET, CmsVaadinUtils.getMessageText("GUI_LOGFILE_REFRESH_FILEVIEW_0", new Object[0]));
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLogFileApp.this.m_fileView.updateView();
            }
        });
        this.m_uiContext.addToolbarButton((Component)button);
    }

    private void addSettingsButton() {
        Button button = CmsToolBar.createButton((Resource)FontOpenCms.SETTINGS, CmsVaadinUtils.getMessageText("GUI_LOGFILE_LOGSETTINGS_TOOL_NAME_SHORT_0", new Object[0]));
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                window.setCaption(CmsVaadinUtils.getMessageText("GUI_LOGFILE_LOGVIEW_SETTINGS_SHORT_0", new Object[0]));
                window.setContent((Component)new CmsLogFileViewSettings(window));
                window.addCloseListener(new Window.CloseListener(){
                    private static final long serialVersionUID = -7058276628732771106L;

                    public void windowClose(Window.CloseEvent e) {
                        CmsLogFileApp.this.m_fileView.updateView();
                    }
                });
                A_CmsUI.get().addWindow(window);
            }
        });
        this.m_uiContext.addToolbarButton((Component)button);
    }
}

