/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.logfile;

import com.vaadin.server.FileDownloader;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.logfile.CmsLogFileApp;
import org.opencms.ui.apps.logfile.CmsLogFileOptionProvider;
import org.opencms.util.CmsLog4jUtil;
import org.opencms.util.CmsRfsException;
import org.opencms.util.CmsRfsFileViewer;

public class CmsLogFileView
extends VerticalLayout {
    protected static String ATTR_FILE_VIEW_CHARSET = "log-file-char";
    protected static String ATTR_FILE_VIEW_PATH = "log-file";
    protected static String ATTR_FILE_VIEW_SIZE = "log-file-size";
    protected static int WINDOW_SIZE = 1000;
    private static final Log LOG = CmsLog.getLog(CmsLogFileView.class);
    private static final long serialVersionUID = -6323034856756469160L;
    protected FileDownloader m_fileDownloader;
    private Label m_fileContent;
    private ComboBox m_logfile;
    private CmsRfsFileViewer m_logView;
    private Panel m_panelComp;

    protected CmsLogFileView(CmsLogFileApp app) {
        if (CmsLogFileApp.LOG_FOLDER.isEmpty()) {
            this.addComponent((Component)CmsVaadinUtils.getInfoLayout("GUI_LOGFILE_WRONG_CONFIG_0"));
        } else {
            CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
            List<Logger> allLogger = CmsLog4jUtil.getAllLoggers();
            ArrayList<Appender> allAppender = new ArrayList<Appender>();
            allLogger.add(0, (Logger)LogManager.getRootLogger());
            for (Logger logger : allLogger) {
                for (Appender appender : logger.getAppenders().values()) {
                    if (!CmsLogFileApp.isFileAppender(appender) || allAppender.contains(appender)) continue;
                    allAppender.add(appender);
                }
            }
            for (File file : CmsLogFileOptionProvider.getLogFiles()) {
                if (file.getAbsolutePath().endsWith(".zip")) continue;
                this.m_logfile.addItem((Object)file.getAbsolutePath());
            }
            this.m_logfile.setFilteringMode(FilteringMode.CONTAINS);
            this.m_logView = (CmsRfsFileViewer)OpenCms.getWorkplaceManager().getFileViewSettings().clone();
            this.m_logView.setAdditionalRoots(CmsLogFileOptionProvider.getAdditionalLogDirectories());
            this.m_logView.setWindowSize(WINDOW_SIZE);
            if (CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_SIZE) == null) {
                CmsVaadinUtils.getRequest().getSession().setAttribute(ATTR_FILE_VIEW_SIZE, (Object)String.valueOf(this.m_logView.getWindowSize()));
            }
            if (CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_CHARSET) == null) {
                Charset defaultCs = Charset.forName(new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding());
                CmsVaadinUtils.getRequest().getSession().setAttribute(ATTR_FILE_VIEW_CHARSET, (Object)defaultCs);
            }
            if (CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_PATH) != null) {
                this.m_logfile.select(CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_PATH));
            } else {
                this.selectLogFile(allAppender, this.m_logView.getFilePath());
            }
            this.m_logfile.setNullSelectionAllowed(false);
            this.m_logfile.setNewItemsAllowed(false);
            this.m_logfile.addValueChangeListener(new Property.ValueChangeListener(){
                private static final long serialVersionUID = 1899253995224124911L;

                public void valueChange(Property.ValueChangeEvent event) {
                    CmsVaadinUtils.getRequest().getSession().setAttribute(ATTR_FILE_VIEW_PATH, (Object)CmsLogFileView.this.getCurrentFile());
                    CmsLogFileView.this.updateView();
                }
            });
            this.updateView();
            this.m_fileContent.addStyleName("v-scrollable");
            this.m_fileContent.addStyleName("o-report");
        }
    }

    protected String getCurrentFile() {
        return (String)this.m_logfile.getValue();
    }

    protected void updateView() {
        if (CmsLogFileApp.LOG_FOLDER.isEmpty()) {
            return;
        }
        try {
            this.m_logView.setFilePath((String)this.m_logfile.getValue());
            this.m_logView.setWindowSize(this.getSize());
            this.m_logView.setFileEncoding(this.getChar());
            String content = "<pre style='line-height:1.1;'>";
            content = content + this.m_logView.readFilePortion();
            content = content + "</pre>";
            this.m_fileContent.setValue(content);
            this.m_panelComp.setScrollTop(100000000);
        }
        catch (CmsRfsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private String getChar() {
        return ((Charset)CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_CHARSET)).name();
    }

    private int getSize() {
        return Integer.valueOf((String)CmsVaadinUtils.getRequest().getSession().getAttribute(ATTR_FILE_VIEW_SIZE));
    }

    private void selectLogFile(List<Appender> appender, String filePath) {
        Appender app;
        String fileName;
        for (Appender app2 : appender) {
            String fileName2 = CmsLogFileApp.getFileName(app2);
            if (fileName2 == null || !fileName2.equals(filePath)) continue;
            this.m_logfile.select((Object)fileName2);
            return;
        }
        if (!appender.isEmpty() && (fileName = CmsLogFileApp.getFileName(app = appender.get(0))) != null) {
            this.m_logfile.select((Object)fileName);
        }
    }
}

