/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.ComboBox;
import org.opencms.file.CmsObject;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsBasicDialog;

public class CmsSiteSelectDialog
extends CmsBasicDialog {
    private static final String CAPTION_PROP = "caption";
    private static final long serialVersionUID = 1L;
    private I_Callback m_callback;
    private Button m_cancelButton;
    private Button m_okButton;
    private ComboBox m_siteSelector;

    public CmsSiteSelectDialog() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        CmsObject cms = A_CmsUI.getCmsObject();
        IndexedContainer container = CmsVaadinUtils.getAvailableSitesContainer(cms, CAPTION_PROP);
        this.m_siteSelector.setContainerDataSource((Container)container);
        this.m_siteSelector.setItemCaptionPropertyId((Object)CAPTION_PROP);
        this.m_siteSelector.setNullSelectionAllowed(false);
        this.m_siteSelector.setValue((Object)cms.getRequestContext().getSiteRoot());
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSiteSelectDialog.this.m_callback.onSiteSelect(CmsSiteSelectDialog.this.getSite());
            }
        });
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSiteSelectDialog.this.m_callback.onCancel();
            }
        });
    }

    public static void openDialogInWindow(final I_Callback callback, String windowCaption) {
        final Window window = CmsBasicDialog.prepareWindow();
        window.setCaption(windowCaption);
        CmsSiteSelectDialog dialog = new CmsSiteSelectDialog();
        window.setContent((Component)dialog);
        dialog.setCallback(new I_Callback(){

            @Override
            public void onCancel() {
                window.close();
                callback.onCancel();
            }

            @Override
            public void onSiteSelect(String site) {
                window.close();
                callback.onSiteSelect(site);
            }
        });
        A_CmsUI.get().addWindow(window);
    }

    public String getSite() {
        return (String)this.m_siteSelector.getValue();
    }

    public void setCallback(I_Callback callback) {
        this.m_callback = callback;
    }

    static interface I_Callback {
        public void onCancel();

        public void onSiteSelect(String var1);
    }
}

