/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.resourcetypes;

import com.google.common.collect.Lists;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.ui.TextArea;
import com.vaadin.v7.ui.TextField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.report.CmsLogReport;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.modules.CmsModuleApp;
import org.opencms.ui.apps.resourcetypes.CmsMoveResourceTypeDialog;
import org.opencms.ui.apps.resourcetypes.CmsResourceTypeApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsNewResourceTypeDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 8775619886579477116L;
    protected static final String PATH_I18N = "i18n";
    private static final String FORMATTER = "formatters/";
    private static final String MESSAGE_KEY_FORMATTER = "type.%s.%s";
    private static final String MESSAGE_KEY_FORMATTER_NAME = "name";
    private static final String MESSAGE_KEY_FORMATTER_DESCRIPTION = "description";
    private static final String MESSAGE_KEY_FORMATTER_TITLE = "title";
    private static final String MESSAGE_KEY_FORMATTER_FORMATTER = "formatter";
    protected static final Log LOG = CmsLog.getLog(CmsNewResourceTypeDialog.class);
    private static final String PATH_SAMPLE = "/system/modules/org.opencms.base/copyresources/";
    private static final String PROPERTIES_ENCODING = "ISO-8859-1";
    private static final String SAMPLE_FORMATTER = "/system/modules/org.opencms.base/copyresources/sample-formatter.jsp";
    private static final String SUFFIX_BUNDLE_FILE = ".messages";
    private static final String SAMPLE_SCHEMA = "/system/modules/org.opencms.base/copyresources/sample-schema.xsd";
    private static final String SAMPLE_TYPE_SCHEMA_ELEMENT = "SampleType";
    private static final String SCHEMA = "schemas/";
    static final String ICON_SMALL_DEFAULT = "oc-icon-16-default";
    static final String ICON_BIG_DEFAULT = "oc-icon-24-default";
    CmsObject m_cms;
    private Button m_cancel;
    private Button m_ok;
    private CmsPathSelectField m_parentFormatter;
    private CmsPathSelectField m_parentSchema;
    private TextArea m_typeDescription;
    private TextField m_typeID;
    private TextField m_typeName;
    private TextField m_typeShortName;
    private TextField m_typeXPathName;
    private CmsModule m_module;
    private CmsPathSelectField m_bundle;
    private CmsPathSelectField m_config;

    public CmsNewResourceTypeDialog(Window window, CmsResourceTypeApp app) {
        this.init(window, app);
    }

    protected static String getMessageParentFolder(String moduleName) {
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        for (String resource : module.getResources()) {
            if (!resource.contains("i18n/" + module.getName())) continue;
            return resource.substring(0, resource.indexOf(PATH_I18N));
        }
        return "/system/modules/" + module.getName();
    }

    private static String getModuleFolder(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        if (module != null) {
            for (String resource : module.getResources()) {
                if (!CmsStringUtil.comparePaths("/system/modules/" + moduleName, resource)) continue;
                return resource;
            }
        }
        return null;
    }

    protected void createParentXmlElements(CmsXmlContent xmlContent, String xmlPath, Locale l) {
        String parentPath;
        if (CmsXmlUtils.isDeepXpath(xmlPath) && null == xmlContent.getValue(parentPath = CmsXmlUtils.removeLastXpathElement(xmlPath), l)) {
            this.createParentXmlElements(xmlContent, parentPath, l);
            xmlContent.addValue(this.m_cms, parentPath, l, CmsXmlUtils.getXpathIndexInt(parentPath) - 1);
        }
    }

    protected void openModuleSelect(Window window) {
        window.setContent((Component)new CmsMoveResourceTypeDialog(this));
        window.center();
    }

    protected void setModule(String moduleName, CmsBasicDialog dialog) {
        Window window = CmsVaadinUtils.getWindow((Component)dialog);
        window.setContent((Component)this);
        this.m_module = OpenCms.getModuleManager().getModule(moduleName).clone();
        CmsResourceInfo resInfo = new CmsResourceInfo(this.m_module.getName(), this.m_module.getNiceName(), CmsModuleApp.Icons.RESINFO_ICON);
        this.displayResourceInfoDirectly(Arrays.asList(resInfo));
        this.fillFields();
    }

    protected void submit(Window window, CmsResourceTypeApp app) {
        if (this.isValid()) {
            this.createResourceType();
            try {
                OpenCms.getModuleManager().updateModule(this.m_cms, this.m_module);
                OpenCms.getResourceManager().initialize(this.m_cms);
                OpenCms.getWorkplaceManager().addExplorerTypeSettings(this.m_module);
                OpenCms.getWorkplaceManager().initialize(this.m_cms);
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to save resource type", (Throwable)e);
            }
            window.close();
            app.reload();
        }
    }

    private void addMessagesToPropertiesFile(Map<String, String> messages, CmsFile propertiesFile, boolean forcePropertyFileEncoding) throws CmsException, UnsupportedEncodingException {
        this.lockTemporary(propertiesFile);
        String encoding = forcePropertyFileEncoding ? PROPERTIES_ENCODING : CmsFileUtil.getEncoding(this.m_cms, propertiesFile);
        StringBuffer contentBuffer = new StringBuffer();
        contentBuffer.append(new String(propertiesFile.getContents(), encoding).trim());
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            contentBuffer.append("\n");
            contentBuffer.append(entry.getKey());
            contentBuffer.append("=");
            contentBuffer.append(entry.getValue());
        }
        contentBuffer.append("\n");
        propertiesFile.setContents(contentBuffer.toString().getBytes(encoding));
        this.m_cms.writeFile(propertiesFile);
    }

    private void addMessagesToVfsBundle(Map<String, String> messages, CmsFile vfsBundleFile) throws CmsException {
        this.lockTemporary(vfsBundleFile);
        CmsObject cms = this.m_cms;
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, vfsBundleFile);
        Locale locale = CmsLocaleManager.getDefaultLocale();
        if (!content.hasLocale(locale)) {
            content.addLocale(cms, locale);
        }
        Element root = content.getLocaleNode(locale);
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            Element message = root.addElement("Message");
            Element key = message.addElement("Key");
            key.setText(entry.getKey());
            Element value = message.addElement("Value");
            value.setText(entry.getValue());
        }
        content.initDocument();
        vfsBundleFile.setContents(content.marshal());
        cms.writeFile(vfsBundleFile);
    }

    private void addResourceToModule(String resourcePath, CmsModule module) {
        ArrayList currentRessources = Lists.newArrayList(module.getResources());
        for (String resource : currentRessources) {
            if (!resourcePath.startsWith(resource)) continue;
            return;
        }
        currentRessources.add(resourcePath);
        module.setResources(currentRessources);
    }

    private void addTypeMessages(CmsExplorerTypeSettings setting, String moduleFolder) throws CmsException, UnsupportedEncodingException {
        String key;
        TreeMap<String, String> messages = new TreeMap<String, String>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_typeName.getValue())) {
            key = String.format(MESSAGE_KEY_FORMATTER, this.m_typeShortName.getValue(), MESSAGE_KEY_FORMATTER_NAME);
            messages.put(key, (String)this.m_typeName.getValue());
            setting.setKey(key);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_typeDescription.getValue())) {
            key = String.format(MESSAGE_KEY_FORMATTER, this.m_typeShortName.getValue(), MESSAGE_KEY_FORMATTER_DESCRIPTION);
            messages.put(key, (String)this.m_typeDescription.getValue());
            setting.setInfo(key);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_typeName.getValue())) {
            key = String.format(MESSAGE_KEY_FORMATTER, this.m_typeShortName.getValue(), MESSAGE_KEY_FORMATTER_TITLE);
            messages.put(key, (String)this.m_typeName.getValue());
            String key2 = String.format(MESSAGE_KEY_FORMATTER, this.m_typeShortName.getValue(), MESSAGE_KEY_FORMATTER_FORMATTER);
            messages.put(key2, (String)this.m_typeName.getValue());
            setting.setTitleKey(key);
        }
        if (!messages.isEmpty()) {
            this.addMessagesToPropertiesFile(messages, this.m_cms.readFile(this.m_bundle.getValue()), false);
        }
    }

    private void adjustFormatterConfig(String formatterPath, String formatterConfigPath) throws CmsException {
        Locale l;
        CmsResource config = this.m_cms.readResource(formatterConfigPath);
        CmsFile file = this.m_cms.readFile(config);
        CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.m_cms, file);
        if (!xmlContent.hasLocale(l = new Locale("en"))) {
            xmlContent.addLocale(this.m_cms, l);
        }
        CmsResource formatter = this.m_cms.readResource(formatterPath);
        I_CmsXmlContentValue v = xmlContent.getValue("Jsp", l);
        v.setStringValue(this.m_cms, formatter.getRootPath());
        String xmlPath = "NiceName";
        v = xmlContent.getValue(xmlPath, l);
        v.setStringValue(this.m_cms, (String)this.m_typeName.getValue());
        xmlPath = "Type";
        v = xmlContent.getValue(xmlPath, l);
        v.setStringValue(this.m_cms, (String)this.m_typeShortName.getValue());
        xmlPath = "AutoEnabled";
        v = xmlContent.getValue(xmlPath, l);
        v.setStringValue(this.m_cms, "true");
        xmlPath = "Match/Width/Width";
        this.createParentXmlElements(xmlContent, xmlPath, l);
        v = xmlContent.getValue(xmlPath, l);
        v.setStringValue(this.m_cms, "-1");
        file.setContents(xmlContent.marshal());
        CmsLockUtil.ensureLock(this.m_cms, file);
        this.m_cms.writeFile(file);
        CmsLockUtil.tryUnlock(this.m_cms, file);
    }

    private void adjustModuleConfig() {
        Locale l = CmsLocaleManager.getLocale("en");
        try {
            CmsResource config = this.m_cms.readResource(this.m_config.getValue());
            CmsFile configFile = this.m_cms.readFile(config);
            CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.m_cms, configFile);
            int number = xmlContent.getIndexCount("ResourceType", l) + 1;
            this.createParentXmlElements(xmlContent, "ResourceType" + XMLPath.num(number) + "/TypeName", l);
            I_CmsXmlContentValue v = xmlContent.getValue("ResourceType" + XMLPath.num(number) + "/TypeName", l);
            v.setStringValue(this.m_cms, (String)this.m_typeShortName.getValue());
            v = xmlContent.addValue(this.m_cms, "ResourceType" + XMLPath.num(number) + "/NamePattern", l, CmsXmlUtils.getXpathIndexInt("ResourceType" + XMLPath.num(number) + "/NamePattern") - 1);
            v.setStringValue(this.m_cms, this.getNamePattern());
            configFile.setContents(xmlContent.marshal());
            CmsLockUtil.ensureLock(this.m_cms, configFile);
            this.m_cms.writeFile(configFile);
            CmsLockUtil.tryUnlock(this.m_cms, configFile);
        }
        catch (CmsException e) {
            LOG.error((Object)"Can't read module config resource", (Throwable)e);
        }
    }

    private void adjustSchema(String schemaPath, String newElementString) {
        newElementString = newElementString.substring(0, 1).toUpperCase() + newElementString.substring(1);
        try {
            CmsFile file = this.m_cms.readFile(schemaPath);
            CmsMacroResolver macroResolver = new CmsMacroResolver();
            macroResolver.setKeepEmptyMacros(true);
            macroResolver.addMacro(SAMPLE_TYPE_SCHEMA_ELEMENT, newElementString);
            String bundleName = this.m_bundle.getValue();
            bundleName = bundleName.split("/")[bundleName.split("/").length - 1];
            if (bundleName.contains("_")) {
                bundleName = bundleName.split("_")[0];
            }
            macroResolver.addMacro("ResourceBundle", bundleName);
            macroResolver.addMacro("typeName", (String)this.m_typeShortName.getValue());
            String encoding = this.m_cms.readPropertyObject(file, "content-encoding", true).getValue(OpenCms.getSystemInfo().getDefaultEncoding());
            String newContent = macroResolver.resolveMacros(new String(file.getContents(), encoding));
            try {
                file.setContents(newContent.getBytes(encoding));
            }
            catch (UnsupportedEncodingException e) {
                try {
                    file.setContents(newContent.getBytes(Charset.defaultCharset().toString()));
                }
                catch (UnsupportedEncodingException e1) {
                    file.setContents(newContent.getBytes());
                }
            }
            CmsLockUtil.ensureLock(this.m_cms, file);
            this.m_cms.writeFile(file);
            CmsLockUtil.tryUnlock(this.m_cms, file);
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read schema definition", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"Unable to fetch encoding", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createResourceType() {
        CmsProject currentProject = this.m_cms.getRequestContext().getCurrentProject();
        try {
            CmsResource res;
            I_CmsResourceType type;
            CmsProject workProject = this.m_cms.createProject("Add_resource_type_project", "Add resource type project", OpenCms.getDefaultUsers().getGroupAdministrators(), OpenCms.getDefaultUsers().getGroupAdministrators(), CmsProject.PROJECT_TYPE_TEMPORARY);
            this.m_cms.getRequestContext().setCurrentProject(workProject);
            if (!this.m_cms.existsResource(this.m_parentSchema.getValue())) {
                type = OpenCms.getResourceManager().getResourceType("folder");
                res = this.m_cms.createResource(this.m_parentSchema.getValue(), type);
                this.m_cms.unlockResource(res);
            }
            if (!this.m_cms.existsResource(this.m_parentFormatter.getValue())) {
                type = OpenCms.getResourceManager().getResourceType("folder");
                res = this.m_cms.createResource(this.m_parentFormatter.getValue(), type);
                this.m_cms.unlockResource(res);
            }
            String formatterPath = this.m_parentFormatter.getValue() + (String)this.m_typeShortName.getValue() + ".jsp";
            String formatterConfigPath = this.m_parentFormatter.getValue() + (String)this.m_typeShortName.getValue() + ".xml";
            String schemaPath = this.m_parentSchema.getValue() + (String)this.m_typeShortName.getValue() + ".xsd";
            if (!this.m_cms.existsResource(formatterPath)) {
                this.m_cms.copyResource(SAMPLE_FORMATTER, formatterPath);
            }
            if (!this.m_cms.existsResource(schemaPath)) {
                this.m_cms.copyResource(SAMPLE_SCHEMA, schemaPath);
            }
            if (!this.m_cms.existsResource(formatterConfigPath)) {
                I_CmsResourceType configType = OpenCms.getResourceManager().getResourceType("formatter_config");
                ArrayList<CmsProperty> props = new ArrayList<CmsProperty>();
                props.add(new CmsProperty("locale", "en", null));
                props.add(new CmsProperty("locale-available", "en", null));
                this.m_cms.createResource(formatterConfigPath, configType, null, props);
            }
            CmsLockUtil.tryUnlock(this.m_cms, this.m_cms.readResource(formatterPath));
            CmsLockUtil.tryUnlock(this.m_cms, this.m_cms.readResource(formatterConfigPath));
            CmsLockUtil.tryUnlock(this.m_cms, this.m_cms.readResource(schemaPath));
            this.addResourceToModule(formatterPath, this.m_module);
            this.addResourceToModule(formatterConfigPath, this.m_module);
            this.addResourceToModule(schemaPath, this.m_module);
            this.adjustFormatterConfig(formatterPath, formatterConfigPath);
            this.adjustSchema(schemaPath, (String)this.m_typeXPathName.getValue());
            this.adjustModuleConfig();
            ArrayList<I_CmsResourceType> types = new ArrayList<I_CmsResourceType>(this.m_module.getResourceTypes());
            CmsResourceTypeXmlContent type2 = new CmsResourceTypeXmlContent();
            type2.addConfigurationParameter("schema", schemaPath);
            type2.setAdditionalModuleResourceType(true);
            type2.setModuleName(this.m_module.getName());
            type2.initConfiguration((String)this.m_typeShortName.getValue(), (String)this.m_typeID.getValue(), CmsResourceTypeXmlContent.class.getName());
            types.add(type2);
            this.m_module.setResourceTypes(types);
            ArrayList<CmsExplorerTypeSettings> settings = new ArrayList<CmsExplorerTypeSettings>(this.m_module.getExplorerTypes());
            CmsExplorerTypeSettings setting = new CmsExplorerTypeSettings();
            setting.setTypeAttributes((String)this.m_typeShortName.getValue(), (String)this.m_typeName.getValue(), null, null, ICON_SMALL_DEFAULT, ICON_BIG_DEFAULT, "xmlcontent", null, "false", null, null);
            setting.setAutoSetNavigation("false");
            setting.setAutoSetTitle("false");
            setting.setNewResourceOrder("10");
            setting.setAddititionalModuleExplorerType(true);
            this.addTypeMessages(setting, CmsNewResourceTypeDialog.getMessageParentFolder(this.m_module.getName()));
            settings.add(setting);
            this.m_module.setExplorerTypes(settings);
            this.m_cms.unlockProject(workProject.getUuid());
            OpenCms.getPublishManager().publishProject(this.m_cms, new CmsLogReport(this.m_cms.getRequestContext().getLocale(), ((Object)((Object)this)).getClass()));
            OpenCms.getPublishManager().waitWhileRunning();
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to create resource type", (Throwable)e);
        }
        finally {
            this.m_cms.getRequestContext().setCurrentProject(currentProject);
        }
    }

    private void fillFields() {
        String folderName = CmsNewResourceTypeDialog.getModuleFolder(this.m_module.getName());
        if (folderName != null) {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_parentFormatter.getValue())) {
                this.m_parentFormatter.setValue(folderName + FORMATTER);
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_parentSchema.getValue())) {
                this.m_parentSchema.setValue(folderName + SCHEMA);
            }
        }
        if (this.m_cms.existsResource(folderName + ".config")) {
            this.m_config.setValue(folderName + ".config");
        }
        this.m_parentFormatter.removeAllValidators();
        this.m_parentSchema.removeAllValidators();
        this.m_config.removeAllValidators();
        this.m_config.addValidator(new ResourceValidator());
        this.m_bundle.addValidator(new BundleValidator());
        this.m_parentFormatter.addValidator(new ResourceValidator());
        this.m_parentSchema.addValidator(new ResourceValidator());
        CmsResource bundle = this.getMessageBundle();
        if (bundle != null) {
            this.m_bundle.setValue(bundle.getRootPath());
        }
    }

    private String getAvailableLocalString() {
        String res = "";
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            res = res + locale.toString() + ",";
        }
        if (res.endsWith(",")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    private int getFreeId() {
        int tryID = (int)(10000.0 + Math.random() * 90000.0);
        while (!CmsResourceTypeApp.isResourceTypeIdFree(tryID)) {
            tryID = (int)(10000.0 + Math.random() * 90000.0);
        }
        return tryID;
    }

    private CmsResource getMessageBundle() {
        OpenCms.getLocaleManager();
        String localString = CmsLocaleManager.getDefaultLocale().toString();
        List<String> moduleResource = this.m_module.getResources();
        for (String resourcePath : moduleResource) {
            if (!resourcePath.contains(PATH_I18N) || !resourcePath.endsWith(localString)) continue;
            try {
                return this.m_cms.readResource(resourcePath);
            }
            catch (CmsException e) {
                LOG.error((Object)"Can not read message bundle", (Throwable)e);
            }
        }
        String moduleFolder = CmsNewResourceTypeDialog.getModuleFolder(this.m_module.getName());
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(moduleFolder)) {
            return null;
        }
        String bundlePath = CmsStringUtil.joinPaths(moduleFolder, PATH_I18N, this.m_module.getName() + SUFFIX_BUNDLE_FILE + "_" + localString);
        if (this.m_cms.existsResource(bundlePath)) {
            try {
                return this.m_cms.readResource(bundlePath);
            }
            catch (CmsException e) {
                LOG.error((Object)"No bundle found for module", (Throwable)e);
            }
        }
        return null;
    }

    private String getNamePattern() {
        String niceName = (String)this.m_typeShortName.getValue();
        if (((String)this.m_typeShortName.getValue()).contains("-")) {
            int maxLength = 0;
            String[] nameParts = niceName.split("-");
            for (int i = 0; i < nameParts.length; ++i) {
                if (nameParts[i].length() <= maxLength) continue;
                maxLength = nameParts[i].length();
                niceName = nameParts[i];
            }
        }
        return niceName + "_%(number).xml";
    }

    private void init(Window window, CmsResourceTypeApp app) {
        CmsObject rootCms = null;
        try {
            this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            rootCms = OpenCms.initCmsObject(this.m_cms);
            rootCms.getRequestContext().setSiteRoot("");
        }
        catch (CmsException e1) {
            rootCms = this.m_cms = A_CmsUI.getCmsObject();
        }
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_typeID.addValidator((Validator)new IDValidator());
        this.m_typeShortName.addValidator((Validator)new NameValidator());
        this.m_parentSchema.setCmsObject(rootCms);
        this.m_parentFormatter.setCmsObject(rootCms);
        this.m_bundle.setCmsObject(rootCms);
        this.m_config.setCmsObject(rootCms);
        this.m_parentSchema.setRequired(true);
        this.m_parentFormatter.setRequired(true);
        this.m_typeID.setRequired(true);
        this.m_typeDescription.setRequired(true);
        this.m_typeShortName.setRequired(true);
        this.m_typeXPathName.setRequired(true);
        this.m_bundle.setRequired(true);
        this.m_typeName.setRequired(true);
        this.m_parentSchema.setRequiredError(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_NOT_EMPTY_0", new Object[0]));
        this.m_parentFormatter.setRequiredError(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_NOT_EMPTY_0", new Object[0]));
        this.m_typeID.setRequiredError(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_NOT_EMPTY_0", new Object[0]));
        this.m_typeDescription.setRequiredError(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_NOT_EMPTY_0", new Object[0]));
        this.m_typeShortName.setRequiredError(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_NOT_EMPTY_0", new Object[0]));
        this.m_typeXPathName.setRequiredError(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_NOT_EMPTY_0", new Object[0]));
        this.m_bundle.setRequiredError(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_NOT_EMPTY_0", new Object[0]));
        this.m_typeName.setRequiredError(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_NOT_EMPTY_0", new Object[0]));
        this.m_typeID.setValue(String.valueOf(this.getFreeId()));
        this.m_ok.addClickListener((Button.ClickListener & Serializable)e -> this.submit(window, app));
        this.m_cancel.addClickListener((Button.ClickListener & Serializable)e -> window.close());
    }

    private boolean isValid() {
        return this.m_typeID.isValid() && this.m_typeShortName.isValid() && this.m_parentFormatter.isValid() && this.m_parentSchema.isValid() && this.m_bundle.isValid() && this.m_config.isValid() && this.m_typeDescription.isValid() && this.m_typeName.isValid() && this.m_typeXPathName.isValid();
    }

    private void lockTemporary(CmsResource resource) throws CmsException {
        CmsUser user = this.m_cms.getRequestContext().getCurrentUser();
        CmsLock lock = this.m_cms.getLock(resource);
        if (!lock.isOwnedBy(user)) {
            this.m_cms.lockResourceTemporary(resource);
        } else if (!lock.isOwnedInProjectBy(user, this.m_cms.getRequestContext().getCurrentProject())) {
            this.m_cms.changeLock(resource);
        }
    }

    class ResourceValidator
    implements Validator {
        private static final long serialVersionUID = 7878441125879949490L;

        ResourceValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (value == null || ((String)value).isEmpty()) {
                return;
            }
            String resource = (String)value;
            if (!resource.startsWith("/system/")) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_RESORUCE_0", new Object[0]));
            }
            if (CmsResource.getName(resource).equals(CmsNewResourceTypeDialog.SCHEMA) || CmsResource.getName(resource).equals(CmsNewResourceTypeDialog.FORMATTER)) {
                if (!CmsNewResourceTypeDialog.this.m_cms.existsResource(CmsResource.getParentFolder(resource))) {
                    throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_RESORUCE_0", new Object[0]));
                }
                return;
            }
            if (!CmsNewResourceTypeDialog.this.m_cms.existsResource((String)value)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_RESORUCE_0", new Object[0]));
            }
        }
    }

    class NameValidator
    implements Validator {
        private static final long serialVersionUID = 7878441125879949490L;

        NameValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (((String)value).isEmpty()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_NAME_0", new Object[0]));
            }
            if (!CmsResourceTypeApp.isResourceTypeNameFree((String)value)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_NAME_0", new Object[0]));
            }
        }
    }

    class IDValidator
    implements Validator {
        private static final long serialVersionUID = 7878441125879949490L;

        IDValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (((String)value).isEmpty()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_ID_0", new Object[0]));
            }
            int id = Integer.parseInt((String)value);
            if (!CmsResourceTypeApp.isResourceTypeIdFree(id)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_ID_0", new Object[0]));
            }
        }
    }

    class BundleValidator
    implements Validator {
        private static final long serialVersionUID = 7872665683495080792L;

        BundleValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (!CmsNewResourceTypeDialog.this.m_cms.existsResource((String)value)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_RESORUCE_0", new Object[0]));
            }
            try {
                CmsResource res = CmsNewResourceTypeDialog.this.m_cms.readResource((String)value);
                if (!OpenCms.getResourceManager().getResourceType(res).equals(OpenCms.getResourceManager().getResourceType("propertyvfsbundle"))) {
                    throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_RESOURCETYPE_EDIT_INVALID_RESORUCE_NO_VFSBUNDLE_0", new Object[0]));
                }
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read resource", (Throwable)e);
            }
        }
    }

    public static class XMLPath {
        private static final String CONFIG_RESOURCETYPE = "ResourceType";
        private static final String CONFIG_RESOURCETYPE_TYPENAME = "/TypeName";
        private static final String CONFIG_RESOURCETYPE_NAMEPATTERN = "/NamePattern";

        public static String num(int i) {
            return "[" + i + "]";
        }
    }
}

