/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.scheduler;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.fieldgroup.BeanFieldGroup;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.TextField;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.notification.CmsContentNotificationJob;
import org.opencms.relations.CmsExternalLinksValidator;
import org.opencms.relations.CmsInternalRelationsValidationJob;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.scheduler.jobs.CmsCreateImageSizeJob;
import org.opencms.scheduler.jobs.CmsDeleteExpiredResourcesJob;
import org.opencms.scheduler.jobs.CmsHistoryClearJob;
import org.opencms.scheduler.jobs.CmsImageCacheCleanupJob;
import org.opencms.scheduler.jobs.CmsPublishJob;
import org.opencms.scheduler.jobs.CmsStaticExportJob;
import org.opencms.scheduler.jobs.CmsUnsubscribeDeletedResourcesJob;
import org.opencms.search.CmsSearchManager;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.scheduler.CmsJobManagerApp;
import org.opencms.ui.apps.scheduler.CmsJobTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.ui.util.CmsComboNullToEmptyConverter;
import org.opencms.ui.util.CmsNullToEmptyConverter;
import org.opencms.util.CmsStringUtil;

public class CmsJobEditView
extends CmsBasicDialog {
    static final Log LOG = CmsLog.getLog(CmsJobEditView.class);
    private static final long serialVersionUID = 1L;
    TextField m_fieldJobName;
    CmsScheduledJobInfo m_job = new CmsScheduledJobInfo();
    CmsJobManagerApp m_manager;
    FormLayout m_paramContainer;
    private Button m_buttonAddParam;
    private Button m_cancel;
    private CheckBox m_fieldActive;
    private ComboBox m_fieldCron;
    private TextField m_fieldEncoding;
    private ComboBox m_fieldJobClass;
    private TextField m_fieldLocale;
    private TextField m_fieldProject;
    private TextField m_fieldRemoteAddress;
    private CheckBox m_fieldReuseInstance;
    private CmsPathSelectField m_fieldSiteRoot;
    private CmsPathSelectField m_fieldUri;
    private TextField m_fieldUser;
    private BeanFieldGroup<CmsScheduledJobInfo> m_group;
    private Button m_ok;

    public CmsJobEditView(CmsJobManagerApp manager, CmsScheduledJobInfo job) {
        this.m_manager = manager;
        this.m_job = job;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(job.getClassName())) {
            this.displayResourceInfoDirectly(Collections.singletonList(CmsJobTable.getJobInfo(job.getJobName(), job.getClassName())));
        }
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (CmsJobEditView.this.trySaveToBean()) {
                    CmsJobEditView.this.m_manager.writeElement(CmsJobEditView.this.m_job);
                    CmsJobEditView.this.m_manager.closeDialogWindow(true);
                }
            }
        });
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsJobEditView.this.m_manager.closeDialogWindow(false);
            }
        });
        BeanFieldGroup group = new BeanFieldGroup(CmsScheduledJobInfo.class);
        group.setItemDataSource((Object)this.m_job);
        this.m_group = group;
        this.bindField((AbstractField<?>)this.m_fieldJobName, "jobName");
        this.bindField((AbstractField<?>)this.m_fieldJobClass, "className");
        this.bindField((AbstractField<?>)this.m_fieldCron, "cronExpression");
        this.bindField((AbstractField<?>)this.m_fieldReuseInstance, "reuseInstance");
        this.bindField((AbstractField<?>)this.m_fieldActive, "active");
        this.bindField((AbstractField<?>)this.m_fieldUser, "contextInfo.userName");
        this.bindField((AbstractField<?>)this.m_fieldProject, "contextInfo.projectName");
        this.bindField((AbstractField<?>)this.m_fieldSiteRoot, "contextInfo.siteRoot");
        this.bindField((AbstractField<?>)this.m_fieldUri, "contextInfo.requestedUri");
        this.bindField((AbstractField<?>)this.m_fieldLocale, "contextInfo.localeName");
        this.bindField((AbstractField<?>)this.m_fieldEncoding, "contextInfo.encoding");
        this.bindField((AbstractField<?>)this.m_fieldRemoteAddress, "contextInfo.remoteAddr");
        this.m_fieldJobName.setConverter((Converter)new CmsNullToEmptyConverter());
        this.m_fieldJobClass.setConverter((Converter)new CmsComboNullToEmptyConverter());
        this.m_fieldCron.setConverter((Converter)new CmsComboNullToEmptyConverter());
        this.m_buttonAddParam.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsJobEditView.this.addParamLine("");
            }
        });
        this.m_fieldJobName.addValidator((Validator)new JobNameValidator());
        this.m_fieldJobClass.setFilteringMode(FilteringMode.OFF);
        this.m_fieldCron.setFilteringMode(FilteringMode.OFF);
        this.m_fieldCron.setNewItemsAllowed(true);
        this.m_fieldJobClass.setNewItemsAllowed(true);
        this.m_fieldJobClass.setPageLength(20);
        this.m_fieldJobClass.addValidator((Validator)new JobClassValidator());
        this.m_fieldCron.addValidator((Validator)new CronExpressionValidator());
        this.m_fieldJobClass.addItem((Object)CmsInternalRelationsValidationJob.class.getName());
        this.m_fieldJobClass.addItem((Object)CmsPublishJob.class.getName());
        this.m_fieldJobClass.addItem((Object)CmsStaticExportJob.class.getName());
        this.m_fieldJobClass.addItem((Object)CmsExternalLinksValidator.class.getName());
        this.m_fieldJobClass.addItem((Object)CmsMemoryMonitor.class.getName());
        this.m_fieldJobClass.addItem((Object)CmsSearchManager.class.getName());
        this.m_fieldJobClass.addItem((Object)CmsContentNotificationJob.class.getName());
        this.m_fieldJobClass.addItem((Object)CmsCreateImageSizeJob.class.getName());
        this.m_fieldJobClass.addItem((Object)CmsImageCacheCleanupJob.class.getName());
        this.m_fieldJobClass.addItem((Object)CmsHistoryClearJob.class.getName());
        this.m_fieldJobClass.addItem((Object)CmsDeleteExpiredResourcesJob.class.getName());
        this.m_fieldJobClass.addItem((Object)CmsUnsubscribeDeletedResourcesJob.class.getName());
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_job.getClassName())) {
            this.m_fieldJobClass.addItem((Object)this.m_job.getClassName());
        }
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_job.getCronExpression())) {
            this.m_fieldCron.addItem((Object)this.m_job.getCronExpression());
        }
        for (String item : new String[]{"0 0 3 * * ?", "0 0/30 * * * ?", "0 30 8 ? * 4", "0 15 18 20 * ?", "0 45 15 ? * 1 2007-2009"}) {
            this.m_fieldCron.addItem((Object)item);
        }
        this.m_fieldSiteRoot.setResourceFilter(CmsResourceFilter.DEFAULT_FOLDERS);
    }

    public void loadFromBean(CmsScheduledJobInfo info) {
        for (Map.Entry<String, String> entry : info.getParameters().entrySet()) {
            this.addParamLine(entry.getKey(), entry.getValue());
        }
    }

    public boolean trySaveToBean() {
        try {
            this.m_group.commit();
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
        this.m_job.setParameters(this.readParams());
        return true;
    }

    void addParamLine(String content) {
        this.m_paramContainer.addComponent((Component)new ParamLine(content));
    }

    void bindField(AbstractField<?> field, String property) {
        this.m_group.bind(field, (Object)property);
        field.setCaption(CmsVaadinUtils.getMessageText("label." + property, new Object[0]));
        field.setDescription(CmsVaadinUtils.getMessageText("label." + property + ".help", new Object[0]));
    }

    SortedMap<String, String> readParams() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Component component : this.m_paramContainer) {
            ParamLine paramLine;
            String keyAndValue;
            int eqPos;
            if (!(component instanceof ParamLine) || (eqPos = (keyAndValue = (paramLine = (ParamLine)component).getValue()).indexOf("=")) < 0) continue;
            String key = keyAndValue.substring(0, eqPos);
            String value = keyAndValue.substring(eqPos + 1);
            result.put(key, value);
        }
        return result;
    }

    private void addParamLine(String key, String value) {
        this.addParamLine(key + "=" + value);
    }

    class ParamLine
    extends HorizontalLayout {
        private static final long serialVersionUID = 1L;
        private TextField m_input;

        public ParamLine(String content) {
            TextField input;
            this.setWidth("100%");
            this.m_input = input = new TextField();
            this.setCaption(CmsVaadinUtils.getMessageText("GUI_SCHEDULER_PARAMETER_0", new Object[0]));
            this.setSpacing(true);
            input.setValue(content);
            input.setWidth("100%");
            this.addComponent((Component)input);
            this.setExpandRatio((Component)input, 1.0f);
            Button deleteButton = new Button("");
            deleteButton.addStyleName("link");
            deleteButton.setIcon((Resource)FontAwesome.TIMES_CIRCLE);
            deleteButton.addStyleName("o-button-unpadded");
            deleteButton.setDescription(CmsVaadinUtils.getMessageText("GUI_SCHEDULER_REMOVE_PARAMETER_0", new Object[0]));
            deleteButton.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    CmsJobEditView.this.m_paramContainer.removeComponent((Component)ParamLine.this);
                }
            });
            this.addComponent((Component)deleteButton);
        }

        public String getValue() {
            return (String)this.m_input.getValue();
        }
    }

    public class JobNameValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        public void validate(Object value) throws Validator.InvalidValueException {
            CmsScheduledJobInfo info = new CmsScheduledJobInfo();
            String name = (String)value;
            try {
                info.setJobName(name);
            }
            catch (CmsIllegalArgumentException e) {
                throw new Validator.InvalidValueException(e.getLocalizedMessage(A_CmsUI.get().getLocale()));
            }
        }
    }

    public class JobClassValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        public void validate(Object value) throws Validator.InvalidValueException {
            CmsScheduledJobInfo info = new CmsScheduledJobInfo();
            String stringValue = (String)value;
            try {
                info.setJobName((String)CmsJobEditView.this.m_fieldJobName.getValue());
            }
            catch (CmsRuntimeException e) {
                throw new Validator.InvalidValueException(e.getLocalizedMessage(A_CmsUI.get().getLocale()));
            }
            try {
                info.setClassName(stringValue);
            }
            catch (CmsIllegalArgumentException e) {
                throw new Validator.InvalidValueException(e.getLocalizedMessage(A_CmsUI.get().getLocale()));
            }
        }
    }

    public class CronExpressionValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        public void validate(Object value) throws Validator.InvalidValueException {
            CmsScheduledJobInfo info = new CmsScheduledJobInfo();
            try {
                info.setJobName((String)CmsJobEditView.this.m_fieldJobName.getValue());
            }
            catch (CmsRuntimeException e) {
                throw new Validator.InvalidValueException(e.getLocalizedMessage(A_CmsUI.get().getLocale()));
            }
            String stringValue = (String)value;
            try {
                info.setCronExpression(stringValue);
            }
            catch (CmsIllegalArgumentException e) {
                throw new Validator.InvalidValueException(e.getLocalizedMessage(A_CmsUI.get().getLocale()));
            }
        }
    }
}

