/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsSearchException;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.search.CmsSearchReplaceSettings;
import org.opencms.ui.apps.search.CmsSourceSearchForm;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsSearchReplaceThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsSearchReplaceThread.class);
    private static final int MAX_PROCESSED_SOLR_RESULTS = 10000;
    private int m_errorSearch;
    private int m_errorUpdate;
    private int m_lockedFiles;
    private Set<CmsResource> m_matchedResources = new LinkedHashSet<CmsResource>();
    private boolean m_replace;
    private CmsSearchReplaceSettings m_settings;

    public CmsSearchReplaceThread(HttpSession session, CmsObject cms, CmsSearchReplaceSettings settings) {
        super(cms, "searchAndReplace");
        this.initHtmlReport(cms.getRequestContext().getLocale());
        this.m_settings = settings;
    }

    public CmsSearchReplaceThread(HttpSession session, CmsObject cms, CmsSearchReplaceSettings settings, I_CmsReport report) {
        super(cms, "searchAndReplace");
        this.m_report = report;
        this.m_settings = settings;
    }

    public List<CmsResource> getMatchedResources() {
        if (this.m_replace) {
            ArrayList<CmsResource> result = new ArrayList<CmsResource>();
            for (CmsResource resource : this.m_matchedResources) {
                try {
                    result.add(this.getCms().readResource(resource.getStructureId()));
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return result;
        }
        return new ArrayList<CmsResource>(this.m_matchedResources);
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        I_CmsReport report = this.getReport();
        boolean isError = false;
        report.println(Messages.get().container("RPT_SOURCESEARCH_BEGIN_SEARCH_THREAD_0"), 2);
        report.println(Messages.get().container("RPT_SOURCESEARCH_PARAMETERS_0"), 2);
        if (!this.m_settings.getPaths().isEmpty()) {
            for (String path : this.m_settings.getPaths()) {
                report.println(Messages.get().container("RPT_SOURCESEARCH_PARAMETERS_RESOURCE_PATH_1", path), 3);
            }
        } else {
            isError = true;
            report.println(Messages.get().container("RPT_SOURCESEARCH_PARAMETERS_EMPTY_RESOURCE_PATHS_0"), 5);
        }
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_settings.getSearchpattern())) {
            report.println(Messages.get().container("RPT_SOURCESEARCH_PARAMETERS_SEARCHPATTERN_1", CmsStringUtil.escapeHtml(this.m_settings.getSearchpattern())), 3);
        } else {
            isError = true;
            report.println(Messages.get().container("RPT_SOURCESEARCH_PARAMETERS_EMPTY_SEARCHPATTERN_0"), 5);
        }
        report.println(Messages.get().container("RPT_SOURCESEARCH_PARAMETERS_REPLACEPATTERN_1", CmsStringUtil.escapeHtml(this.m_settings.getReplacepattern())), 3);
        report.println(Messages.get().container("RPT_SOURCESEARCH_PARAMETERS_PROJECT_1", this.m_settings.getProject()), 3);
        if (CmsStringUtil.isEmpty(this.m_settings.getReplacepattern()) && !this.m_settings.isForceReplace()) {
            report.println(Messages.get().container("RPT_SOURCESEARCH_PARAMETERS_EMPTY_REPLACEPATTERN_0"), 3);
        } else {
            this.m_replace = true;
            report.println(Messages.get().container("RPT_SOURCESEARCH_PARAMETERS_NOTEMPTY_REPLACEPATTERN_0"), 3);
        }
        CmsObject cmsObject = this.getCms();
        if (this.m_replace && !this.m_settings.getProject().equals(cmsObject.getRequestContext().getCurrentProject().getName())) {
            try {
                cmsObject = OpenCms.initCmsObject(this.getCms());
                CmsProject cmsProject = this.getCms().readProject(this.m_settings.getProject());
                cmsObject.getRequestContext().setCurrentProject(cmsProject);
            }
            catch (CmsException e) {
                report.println(Messages.get().container("RPT_SOURCESEARCH_INIT_CMS_OBJECT_FAILED_0"), 3);
                this.m_replace = false;
            }
        }
        if (!isError) {
            List<CmsResource> resources = this.searchResources();
            if (resources.isEmpty()) {
                report.println(Messages.get().container("RPT_SOURCESEARCH_NO_FILES_TO_SEARCH_IN_0"), 3);
            } else {
                report.println(Messages.get().container("RPT_SOURCESEARCH_NR_OF_FILES_TO_SEARCH_IN_1", new Integer(resources.size())), 3);
                if (this.m_replace) {
                    report.println(Messages.get().container("RPT_SOURCESEARCH_START_SEARCHING_REPLACING_0"), 2);
                } else {
                    report.println(Messages.get().container("RPT_SOURCESEARCH_START_SEARCHING_0"), 2);
                }
                if (this.m_settings.getType().isPropertySearch()) {
                    this.searchProperties(resources);
                } else {
                    this.searchAndReplace(resources);
                }
            }
        }
        report.println(Messages.get().container("RPT_SOURCESEARCH_END_SEARCH_THREAD_0"), 2);
    }

    protected void searchAndReplace(List<CmsResource> resources) {
        int counter = 0;
        int resCount = resources.size();
        I_CmsReport report = this.getReport();
        for (CmsResource resource : resources) {
            try {
                CmsFile file = this.getCms().readFile(resource);
                byte[] contents = file.getContents();
                this.report(report, ++counter, resCount, resource);
                byte[] result = null;
                boolean xpath = false;
                if ((CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_settings.getXpath()) || this.m_settings.isOnlyContentValues()) && CmsResourceTypeXmlContent.isXmlContent(resource)) {
                    xpath = true;
                }
                if ((result = !xpath ? this.replaceInContent(file, contents) : this.replaceInXml(file)) != null && contents != null && !contents.equals(result)) {
                    this.writeContent(file, result);
                    continue;
                }
                this.getReport().println();
            }
            catch (Exception e) {
                report.print(org.opencms.report.Messages.get().container("RPT_SOURCESEARCH_COULD_NOT_READ_FILE_0"), 5);
                report.addError(e);
                report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                ++this.m_errorSearch;
                LOG.error((Object)org.opencms.report.Messages.get().container("RPT_SOURCESEARCH_COULD_NOT_READ_FILE_0"), (Throwable)e);
            }
        }
        this.reportResults(resources.size());
    }

    private boolean lockResource(CmsObject cms, CmsResource cmsResource, I_CmsReport report) throws CmsException {
        CmsLock lock = cms.getLock(cms.getSitePath(cmsResource));
        if (lock != null && lock.isOwnedBy(cms.getRequestContext().getCurrentUser()) && lock.isOwnedInProjectBy(cms.getRequestContext().getCurrentUser(), cms.getRequestContext().getCurrentProject())) {
            return true;
        }
        if (lock != null && !lock.isUnlocked() && !lock.isOwnedBy(cms.getRequestContext().getCurrentUser())) {
            ++this.m_lockedFiles;
            return false;
        }
        if (lock != null && !lock.isUnlocked() && lock.isOwnedBy(cms.getRequestContext().getCurrentUser()) && !lock.isOwnedInProjectBy(cms.getRequestContext().getCurrentUser(), cms.getRequestContext().getCurrentProject())) {
            cms.changeLock(cms.getSitePath(cmsResource));
        } else if (lock != null && lock.isUnlocked()) {
            cms.lockResource(cms.getSitePath(cmsResource));
        }
        lock = cms.getLock(cms.getSitePath(cmsResource));
        if (lock != null && lock.isOwnedBy(cms.getRequestContext().getCurrentUser()) && !lock.isOwnedInProjectBy(cms.getRequestContext().getCurrentUser(), cms.getRequestContext().getCurrentProject())) {
            ++this.m_lockedFiles;
            return false;
        }
        return true;
    }

    private byte[] renameNestedContainers(CmsFile targetContainerPage, CmsResource layoutResource, String oldName, String newName) throws Exception {
        byte[] contents = targetContainerPage.getContents();
        HashSet<String> replaceElementIds = new HashSet<String>();
        try {
            CmsXmlContainerPage page = CmsXmlContainerPageFactory.unmarshal(this.getCms(), targetContainerPage);
            for (CmsContainerElementBean element : page.getContainerPage(this.getCms()).getElements()) {
                if (!element.getId().equals(layoutResource.getStructureId()) || element.getInstanceId() == null) continue;
                replaceElementIds.add(element.getInstanceId());
            }
            if (replaceElementIds.size() > 0) {
                String encoding = CmsLocaleManager.getResourceEncoding(this.getCms(), targetContainerPage);
                String content = new String(contents, encoding);
                for (String instanceId : replaceElementIds) {
                    Pattern patt = Pattern.compile(CmsJspTagContainer.getNestedContainerName(oldName, instanceId, null));
                    Matcher m = patt.matcher(content);
                    StringBuffer sb = new StringBuffer(content.length());
                    while (m.find()) {
                        m.appendReplacement(sb, Matcher.quoteReplacement(CmsJspTagContainer.getNestedContainerName(newName, instanceId, null)));
                    }
                    m.appendTail(sb);
                    content = sb.toString();
                }
                contents = content.getBytes(encoding);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        return contents;
    }

    private byte[] replaceInContent(CmsFile file, byte[] contents) throws Exception {
        Locale contentLocale;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_settings.getLocale()) && !(contentLocale = CmsLocaleManager.getMainLocale(this.getCms(), file)).toString().equalsIgnoreCase(this.m_settings.getLocale())) {
            this.getReport().println(Messages.get().container("RPT_SOURCESEARCH_NOT_MATCHED_0"), 3);
            return null;
        }
        String encoding = CmsLocaleManager.getResourceEncoding(this.getCms(), file);
        String content = new String(contents, encoding);
        if (".*".equals(this.m_settings.getSearchpattern()) & !this.m_replace) {
            this.m_matchedResources.add(file);
            this.getReport().print(Messages.get().container("RPT_SOURCESEARCH_MATCHED_0"), 4);
            return null;
        }
        Matcher matcher = Pattern.compile(this.m_settings.getSearchpattern()).matcher(content);
        if (matcher.find()) {
            this.m_matchedResources.add(file);
            this.getReport().print(Messages.get().container("RPT_SOURCESEARCH_MATCHED_0"), 4);
            if (this.m_replace) {
                if (this.m_settings.getType().equals((Object)CmsSourceSearchForm.SearchType.renameContainer)) {
                    return this.renameNestedContainers(file, this.m_settings.getElementResource(), this.m_settings.getReplacepattern().split(";")[0], this.m_settings.getReplacepattern().split(";")[1]);
                }
                return matcher.replaceAll(this.m_settings.getReplacepattern()).getBytes(encoding);
            }
        } else {
            this.getReport().print(Messages.get().container("RPT_SOURCESEARCH_NOT_MATCHED_0"), 3);
        }
        return null;
    }

    private byte[] replaceInXml(CmsFile cmsFile) throws Exception {
        Exception e = null;
        CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.getCms(), cmsFile);
        Pattern pattern = Pattern.compile(this.m_settings.getSearchpattern());
        boolean modified = false;
        boolean matched = false;
        String requestedLocale = this.m_settings.getLocale();
        for (Locale locale : xmlContent.getLocales()) {
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(requestedLocale) && !locale.toString().equalsIgnoreCase(requestedLocale)) continue;
            List<String> paths = xmlContent.getNames(locale);
            for (String xpath : paths) {
                I_CmsXmlContentValue value = xmlContent.getValue(xpath, locale);
                if (!value.isSimpleType()) continue;
                try {
                    String newVal;
                    String currPath = value.getPath();
                    if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_settings.getXpath()) && !currPath.equals(this.m_settings.getXpath()) && !CmsXmlUtils.removeXpath(currPath).equals(this.m_settings.getXpath())) continue;
                    String oldVal = value.getStringValue(this.getCms());
                    Matcher matcher = pattern.matcher(oldVal);
                    matcher = Pattern.compile(this.m_settings.getSearchpattern()).matcher(oldVal);
                    if (!matcher.find()) continue;
                    matched = true;
                    this.m_matchedResources.add(cmsFile);
                    if (!this.m_replace || oldVal.equals(newVal = matcher.replaceAll(this.m_settings.getReplacepattern()))) continue;
                    value.setStringValue(this.getCms(), newVal);
                    modified = true;
                }
                catch (Exception ex) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                    e = ex;
                }
            }
        }
        if (e != null) {
            throw e;
        }
        if (matched) {
            this.getReport().println(Messages.get().container("RPT_SOURCESEARCH_MATCHED_0"), 4);
        } else {
            this.getReport().println(Messages.get().container("RPT_SOURCESEARCH_NOT_MATCHED_0"), 3);
        }
        if (modified) {
            return xmlContent.marshal();
        }
        return null;
    }

    private void replaceProperties(Set<CmsResource> matchedResources) {
        for (CmsResource resource : matchedResources) {
            try {
                CmsProperty prop = this.getCms().readPropertyObject(resource, this.m_settings.getProperty().getName(), false);
                Matcher matcher = Pattern.compile(this.m_settings.getSearchpattern()).matcher(prop.getValue());
                if (this.m_settings.getReplacepattern().isEmpty()) {
                    prop.setValue("", "");
                } else {
                    prop.setValue(matcher.replaceAll(this.m_settings.getReplacepattern()), "individual");
                }
                this.getCms().lockResource(resource);
                this.getCms().writePropertyObjects(resource, Collections.singletonList(prop));
                this.getCms().unlockResource(resource);
            }
            catch (CmsException e) {
                LOG.error((Object)"Ubable to change property", (Throwable)e);
            }
        }
    }

    private void report(I_CmsReport report, int counter, int resCount, CmsResource resource) {
        report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(counter), String.valueOf(resCount)), 3);
        report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", report.removeSiteRoot(resource.getRootPath())));
        report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 0);
    }

    private void reportResults(int nrOfFiles) {
        I_CmsReport report = this.getReport();
        if (this.m_replace) {
            report.println(Messages.get().container("RPT_SOURCESEARCH_END_SEARCHING_REPLACING_0"), 2);
        } else {
            report.println(Messages.get().container("RPT_SOURCESEARCH_END_SEARCHING_0"), 2);
        }
        report.println(Messages.get().container("RPT_SOURCESEARCH_RESULT_0"), 2);
        report.println(Messages.get().container("RPT_SOURCESEARCH_NR_OF_FILES_TO_SEARCH_IN_1", new Integer(nrOfFiles).toString()), 3);
        report.println(Messages.get().container("RPT_SOURCESEARCH_NR_OF_FILES_MATCHED_1", new Integer(this.m_matchedResources.size()).toString()), 3);
        report.println(Messages.get().container("RPT_SOURCESEARCH_SEARCH_ERROR_COUNT_1", new Integer(this.m_errorSearch).toString()), 3);
        if (this.m_replace) {
            report.println(Messages.get().container("RPT_SOURCESEARCH_REPLACE_ERROR_COUNT_1", new Integer(this.m_errorUpdate).toString()), 3);
            report.println(Messages.get().container("RPT_SOURCESEARCH_LOCKED_FILES_1", new Integer(this.m_lockedFiles).toString()), 3);
            if (this.m_matchedResources.size() == 0) {
                report.println(Messages.get().container("RPT_SOURCESEARCH_NO_FILES_FOUND_0"), 4);
            } else {
                report.println(Messages.get().container("RPT_SOURCESEARCH_CLICK_OK_TO_GET_LIST_0"), 4);
            }
            if (this.m_lockedFiles > 0) {
                report.println(Messages.get().container("RPT_SOURCESEARCH_REPLACE_FAILED_0"), 5);
            } else {
                report.println(Messages.get().container("RPT_SOURCESEARCH_REPLACE_SUCCESS_0"), 4);
            }
        } else {
            if (this.m_matchedResources.size() == 0) {
                report.println(Messages.get().container("RPT_SOURCESEARCH_NO_FILES_FOUND_0"), 4);
            } else {
                report.println(Messages.get().container("RPT_SOURCESEARCH_CLICK_OK_TO_GET_LIST_0"), 4);
            }
            if (this.m_errorSearch > 0) {
                report.println(Messages.get().container("RPT_SOURCESEARCH_SEARCH_FAILED_0"), 5);
            } else {
                report.println(Messages.get().container("RPT_SOURCESEARCH_SEARCH_SUCCESS_0"), 4);
            }
        }
    }

    private void searchProperties(List<CmsResource> resources) {
        if (".*".equals(this.m_settings.getSearchpattern())) {
            for (CmsResource resource : resources) {
                this.m_matchedResources.add(resource);
                this.getReport().println(Messages.get().container("RPT_SOURCESEARCH_MATCHED_0"), 4);
            }
        } else {
            for (CmsResource resource : resources) {
                try {
                    CmsProperty prop = this.getCms().readPropertyObject(resource, this.m_settings.getProperty().getName(), false);
                    Matcher matcher = Pattern.compile(this.m_settings.getSearchpattern()).matcher(prop.getValue());
                    if (matcher.find()) {
                        this.m_matchedResources.add(resource);
                        this.getReport().println(Messages.get().container("RPT_SOURCESEARCH_MATCHED_0"), 4);
                        continue;
                    }
                    this.getReport().println(Messages.get().container("RPT_SOURCESEARCH_NOT_MATCHED_0"), 3);
                }
                catch (CmsException e) {
                    LOG.error((Object)"Ubable to read property", (Throwable)e);
                }
            }
        }
        if (this.m_replace) {
            this.replaceProperties(this.m_matchedResources);
        }
        this.reportResults(resources.size());
    }

    private List<CmsResource> searchResources() {
        this.getReport().println(Messages.get().container("RPT_SOURCESEARCH_START_COLLECTING_FILES_TO_SEARCH_IN_0"), 2);
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        if (this.m_settings.isSolrSearch()) {
            CmsSolrIndex index = OpenCms.getSearchManager().getIndexSolr(this.m_settings.getSource());
            if (index != null) {
                CmsSolrQuery query = new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(this.m_settings.getQuery() + "&fl=path,type"));
                ArrayList<String> rootPaths = new ArrayList<String>(this.m_settings.getPaths().size());
                String siteRoot = this.getCms().getRequestContext().getSiteRoot();
                for (String path : this.m_settings.getPaths()) {
                    rootPaths.add(path.startsWith(siteRoot) ? path : this.getCms().addSiteRoot(path));
                }
                query.setSearchRoots(rootPaths);
                if (this.m_settings.getTypesArray() != null && this.m_settings.getTypesArray().length > 0) {
                    query.setResourceTypes(this.m_settings.getTypesArray());
                }
                query.setRows(new Integer(10000));
                query.ensureParameters();
                try {
                    resources.addAll(index.search(this.getCms(), query, true, null, false, null, 10000));
                }
                catch (CmsSearchException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else {
            CmsResourceFilter filter = CmsResourceFilter.ALL.addExcludeState(CmsResource.STATE_DELETED).addRequireVisible();
            ArrayList<CmsResourceFilter> filterList = new ArrayList<CmsResourceFilter>();
            if (this.m_settings.getTypesArray() != null && this.m_settings.getTypesArray().length > 0) {
                for (String resTypeName : this.m_settings.getTypesArray()) {
                    try {
                        int typeId = OpenCms.getResourceManager().getResourceType(resTypeName).getTypeId();
                        filterList.add(((CmsResourceFilter)filter.clone()).addRequireType(typeId));
                    }
                    catch (CmsLoaderException typeId) {
                    }
                    catch (NullPointerException typeId) {
                        // empty catch block
                    }
                }
            }
            if (filterList.size() == 1) {
                filter = (CmsResourceFilter)filterList.get(0);
            }
            Iterator<String> iterPaths = this.m_settings.getPaths().iterator();
            if (!this.m_settings.getType().isPropertySearch()) {
                filter = filter.addRequireFile();
            }
            while (iterPaths.hasNext()) {
                String path = iterPaths.next();
                try {
                    if (this.m_settings.getType().isPropertySearch()) {
                        resources.addAll(this.getCms().readResourcesWithProperty(path, this.m_settings.getProperty().getName(), null, filter));
                        continue;
                    }
                    List<CmsResource> tmpResources = this.getCms().readResources(path, filter);
                    List<String> subsites = null;
                    if (this.m_settings.ignoreSubSites()) {
                        subsites = OpenCms.getADEManager().getSubSitePaths(this.getCms(), path);
                        subsites.remove(OpenCms.getADEManager().getSubSiteRoot(this.getCms(), this.getCms().readResource(path).getRootPath()));
                    }
                    Iterator<CmsResource> iterator = tmpResources.iterator();
                    while (iterator.hasNext()) {
                        CmsResource r = iterator.next();
                        boolean remove = true;
                        if (filterList.size() > 1) {
                            for (CmsResourceFilter f : filterList) {
                                if (!f.isValid(this.getCms().getRequestContext(), r)) continue;
                                remove = false;
                            }
                        } else {
                            remove = false;
                        }
                        if (subsites != null & !remove && subsites.contains(OpenCms.getADEManager().getSubSiteRoot(this.getCms(), r.getRootPath()))) {
                            remove = true;
                        }
                        if (!remove) continue;
                        iterator.remove();
                    }
                    if (tmpResources == null || tmpResources.isEmpty()) continue;
                    resources.addAll(tmpResources);
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().container("RPT_SOURCESEARCH_ERROR_READING_RESOURCES_1", path), (Throwable)e);
                    this.getReport().println(Messages.get().container("RPT_SOURCESEARCH_ERROR_READING_RESOURCES_1", path), 5);
                }
            }
        }
        return resources;
    }

    private boolean writeContent(CmsFile file, byte[] content) {
        boolean success = true;
        I_CmsReport report = this.getReport();
        CmsObject cmsObject = this.getCms();
        try {
            if (!this.lockResource(cmsObject, file, report)) {
                report.println(Messages.get().container("RPT_SOURCESEARCH_LOCKED_FILE_0", cmsObject.getSitePath(file)), 5);
                success = false;
            }
        }
        catch (CmsException e) {
            report.println(Messages.get().container("RPT_SOURCESEARCH_LOCKED_FILE_0", cmsObject.getSitePath(file)), 5);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessageContainer(), (Throwable)e);
            }
            success = false;
        }
        try {
            file.setContents(content);
            cmsObject.writeFile(file);
        }
        catch (Exception e) {
            ++this.m_errorUpdate;
            report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.toString());
            }
            success = false;
        }
        try {
            cmsObject.unlockResource(cmsObject.getSitePath(file));
        }
        catch (CmsException e) {
            ++this.m_errorUpdate;
            report.println(Messages.get().container("RPT_SOURCESEARCH_UNLOCK_FILE_0"), 1);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessageContainer(), (Throwable)e);
            }
            success = false;
        }
        if (success) {
            report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
        return success;
    }
}

