/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sessions;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.sessions.CmsSessionsApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.util.CmsUUID;

public class CmsKillSessionDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = -7281930091176835024L;
    static Log LOG = CmsLog.getLog(CmsKillSessionDialog.class.getName());
    private Button m_cancelButton;
    private Label m_icon;
    private Label m_label;
    private Button m_okButton;

    public CmsKillSessionDialog(final Set<String> sessionIds, final Runnable canelRunnable) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.displayResourceInfoDirectly(CmsSessionsApp.getUserInfos(sessionIds));
        this.m_icon.setContentMode(ContentMode.HTML);
        this.m_icon.setValue(FontOpenCms.WARNING.getHtml());
        if (sessionIds.size() == 1) {
            this.m_label.setValue(CmsVaadinUtils.getMessageText("GUI_MESSAGES_CONFIRM_DESTROY_SESSION_SINGLE_0", new Object[0]));
        }
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5044360626122683306L;

            public void buttonClick(Button.ClickEvent event) {
                for (String sessionId : sessionIds) {
                    try {
                        OpenCms.getSessionManager().killSession(A_CmsUI.getCmsObject(), new CmsUUID(sessionId));
                        LOG.info((Object)("Kill session of user with id '" + sessionId + "'"));
                    }
                    catch (NumberFormatException | CmsException exception) {}
                }
                canelRunnable.run();
            }
        });
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 6872628835561250226L;

            public void buttonClick(Button.ClickEvent event) {
                canelRunnable.run();
            }
        });
    }
}

