/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sessions;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.ui.CheckBox;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsBroadcast;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.sessions.CmsSessionsApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsRichTextAreaV7;

public class CmsSendBroadcastDialog
extends CmsBasicDialog {
    private static final Map<CmsUser, CmsBroadcast> USER_BROADCAST = new HashMap<CmsUser, CmsBroadcast>();
    private static final long serialVersionUID = -7642289972554010162L;
    private Button m_cancel;
    private CmsRichTextAreaV7 m_message;
    private Button m_ok;
    private Button m_resetBroadcasts;
    private CheckBox m_repeat;

    public CmsSendBroadcastDialog(final Set<String> sessionIds, final Runnable closeRunnable) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        if (sessionIds != null) {
            this.displayResourceInfoDirectly(CmsSessionsApp.getUserInfos(sessionIds));
        } else if (USER_BROADCAST.containsKey(A_CmsUI.getCmsObject().getRequestContext().getCurrentUser())) {
            this.m_message.setValue(USER_BROADCAST.get(A_CmsUI.getCmsObject().getRequestContext().getCurrentUser()).getMessage());
        }
        this.m_resetBroadcasts.addClickListener((Button.ClickListener & Serializable)event -> this.removeAllBroadcasts(sessionIds));
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 3105449865170606831L;

            public void buttonClick(Button.ClickEvent event) {
                closeRunnable.run();
            }
        });
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -1148041995591262401L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSendBroadcastDialog.this.addValidator();
                if (CmsSendBroadcastDialog.this.isMessageValid()) {
                    CmsSendBroadcastDialog.this.sendBroadcast(sessionIds);
                    closeRunnable.run();
                }
            }
        });
    }

    protected void addValidator() {
        this.m_message.removeAllValidators();
        this.m_message.addValidator(new CmsSessionsApp.MessageValidator());
    }

    protected boolean isMessageValid() {
        return this.m_message.isValid();
    }

    protected void sendBroadcast(Set<String> sessionIds) {
        if (sessionIds == null) {
            OpenCms.getSessionManager().sendBroadcast(A_CmsUI.getCmsObject(), (String)this.m_message.getValue(), (Boolean)this.m_repeat.getValue());
            USER_BROADCAST.put(A_CmsUI.getCmsObject().getRequestContext().getCurrentUser(), new CmsBroadcast(A_CmsUI.getCmsObject().getRequestContext().getCurrentUser(), (String)this.m_message.getValue(), (Boolean)this.m_repeat.getValue()));
        } else {
            for (String id : sessionIds) {
                OpenCms.getSessionManager().sendBroadcast(A_CmsUI.getCmsObject(), (String)this.m_message.getValue(), id, (Boolean)this.m_repeat.getValue());
            }
        }
    }

    private void removeAllBroadcasts(Set<String> sessionIds) {
        if (sessionIds == null) {
            for (CmsSessionInfo info : OpenCms.getSessionManager().getSessionInfos()) {
                OpenCms.getSessionManager().getBroadcastQueue(info.getSessionId().getStringValue()).clear();
            }
            return;
        }
        for (String sessionId : sessionIds) {
            OpenCms.getSessionManager().getBroadcastQueue(sessionId).clear();
        }
    }
}

