/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.shell;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.TextArea;
import com.vaadin.v7.ui.VerticalLayout;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.shell.CmsShellScriptReportDialog;
import org.opencms.ui.apps.shell.CmsShellScriptThread;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.util.CmsUUID;

public class CmsShellScriptLayout
extends VerticalLayout {
    static final Log LOG = CmsLog.getLog(CmsShellScriptLayout.class);
    private static final long serialVersionUID = -7284574557422737112L;
    private ComboBox m_site;
    private ComboBox m_project;
    private TextArea m_script;
    private Button m_ok;

    public CmsShellScriptLayout() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_site.setContainerDataSource((Container)CmsVaadinUtils.getAvailableSitesContainer(A_CmsUI.getCmsObject(), "caption"));
        this.m_site.setItemCaptionPropertyId((Object)"caption");
        this.m_site.select((Object)A_CmsUI.getCmsObject().getRequestContext().getSiteRoot());
        this.m_project.setContainerDataSource((Container)CmsVaadinUtils.getProjectsContainer(A_CmsUI.getCmsObject(), "caption"));
        this.m_project.setItemCaptionPropertyId((Object)"caption");
        this.m_project.select((Object)A_CmsUI.getCmsObject().getRequestContext().getCurrentProject().getUuid());
        this.m_site.setNewItemsAllowed(false);
        this.m_site.setNullSelectionAllowed(false);
        this.m_project.setNewItemsAllowed(false);
        this.m_project.setNullSelectionAllowed(false);
        this.m_script.setValue(CmsVaadinUtils.getMessageText("GUI_SHELL_SCRIPT_APP_INI_COMMENT_0", new Object[0]));
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 6836938102455627631L;

            public void buttonClick(Button.ClickEvent event) {
                try {
                    Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
                    CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                    CmsShellScriptLayout.this.setupCms(cms);
                    CmsShellScriptThread thread = new CmsShellScriptThread(cms, CmsShellScriptLayout.this.getScript());
                    CmsShellScriptReportDialog dialog = new CmsShellScriptReportDialog(thread, window);
                    window.setContent((Component)dialog);
                    A_CmsUI.get().addWindow(window);
                    thread.start();
                }
                catch (CmsException e) {
                    LOG.error((Object)"Unable to initialize CmsObject", (Throwable)e);
                }
            }
        });
    }

    protected String getScript() {
        return (String)this.m_script.getValue();
    }

    protected void setupCms(CmsObject cms) {
        cms.getRequestContext().setUri("/");
        cms.getRequestContext().setSiteRoot((String)this.m_site.getValue());
        try {
            cms.getRequestContext().setCurrentProject(cms.readProject((CmsUUID)this.m_project.getValue()));
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read Project", (Throwable)e);
        }
    }
}

