/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sitemanager;

import java.io.ByteArrayOutputStream;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLockException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.site.CmsSite;
import org.opencms.ui.apps.I_CmsCRUDApp;
import org.opencms.ui.apps.Messages;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsCreateSiteThread
extends A_CmsReportThread {
    static Log LOG = CmsLog.getLog(CmsCreateSiteThread.class.getName());
    private static final String BLANK_HTML = "blank.html";
    private static final String INDEX_HTML = "index.html";
    private static final String MODEL_PAGE = "ModelPage";
    private static final String MODEL_PAGE_PAGE = "ModelPage/Page";
    private static final String NEW = ".templates/";
    private Map<String, String> m_bundle;
    private CmsObject m_cms;
    private CmsObject m_cmsOnline;
    private boolean m_createOU;
    private Runnable m_finished;
    private I_CmsCRUDApp<CmsSite> m_manager;
    private CmsSite m_oldSite;
    private ByteArrayOutputStream m_os;
    private String m_parentOU;
    private String m_selectedOU;
    private CmsSite m_site;
    private String m_source;
    private String m_template;

    protected CmsCreateSiteThread(CmsObject cms, I_CmsCRUDApp<CmsSite> manager, CmsSite site, CmsSite oldSite, String source, String template, boolean createOU, String parentOU, String selectedOU, ByteArrayOutputStream os, Map<String, String> bundle, Runnable finished) {
        super(cms, "createSite");
        this.m_cms = cms;
        this.m_cmsOnline = this.getOnlineCmsObject(cms);
        this.m_source = source;
        this.m_template = template;
        this.m_bundle = bundle;
        this.m_site = site;
        this.m_createOU = createOU;
        this.m_oldSite = oldSite;
        this.m_parentOU = parentOU;
        this.m_selectedOU = selectedOU;
        this.m_os = os;
        this.m_finished = finished;
        this.m_manager = manager;
        this.initHtmlReport(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms.getRequestContext()));
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        try {
            if (this.m_oldSite == null) {
                this.getReport().println(Messages.get().container("RPT_SITE_START_NEW_1", this.m_site.getTitle()), 2);
            } else {
                this.getReport().println(Messages.get().container("RPT_SITE_START_EDIT_1", this.m_site.getTitle()), 2);
            }
            CmsResource siteRootResource = null;
            if (this.m_source.isEmpty()) {
                siteRootResource = this.createSiteRootIfNeeded(this.m_site.getSiteRoot());
                String sitePath = this.m_cms.getSitePath(siteRootResource);
                String contentFolder = CmsStringUtil.joinPaths(sitePath, ".content/");
                String sitemapConfig = CmsStringUtil.joinPaths(contentFolder, ".config");
                if (!this.m_cms.existsResource(sitemapConfig)) {
                    this.createSitemapContentFolder(this.m_cms, siteRootResource, contentFolder);
                }
                this.createIndexHTML(this.ensureFoldername(siteRootResource.getRootPath()));
            } else {
                CmsMacroResolver.copyAndResolveMacro(this.m_cms, this.m_source, this.m_site.getSiteRoot(), this.m_bundle, true, CmsResource.COPY_AS_NEW, this.getReport());
                siteRootResource = this.m_cms.readResource(this.m_site.getSiteRoot());
                this.adjustFolderType(siteRootResource);
                this.setFolderTitle(siteRootResource);
            }
            this.setTemplate(siteRootResource);
            this.saveFavIcon(this.ensureFoldername(this.m_site.getSiteRoot()));
            this.handleOU(siteRootResource);
            try {
                this.m_cms.unlockResource(siteRootResource);
            }
            catch (CmsLockException e) {
                LOG.info((Object)"Unlock resource failed", (Throwable)e);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Error creating site", (Throwable)e);
            this.getReport().println(Messages.get().container("RPT_SITE_ERROR_0"), 5);
            this.getReport().println(e);
            this.getReport().println();
            this.getReport().println(Messages.get().container("RPT_SITE_FINISH_WARNING_0"), 1);
            this.m_finished.run();
            return;
        }
        this.getReport().println(Messages.get().container("RPT_SITE_FINISH_0"), 4);
        this.m_finished.run();
        this.m_manager.writeElement(this.m_site);
    }

    String ensureFoldername(String resourcename) {
        if (CmsStringUtil.isEmpty(resourcename)) {
            return "";
        }
        if (!CmsResource.isFolder(resourcename)) {
            resourcename = resourcename.concat("/");
        }
        if (resourcename.charAt(0) == '/') {
            resourcename = resourcename.substring(1);
        }
        return resourcename;
    }

    private void adjustFolderType(CmsResource siteRootResource) throws CmsLoaderException, CmsException {
        if (OpenCms.getResourceManager().getResourceType("folder") == OpenCms.getResourceManager().getResourceType(siteRootResource)) {
            siteRootResource.setType(OpenCms.getResourceManager().getResourceType("subsitemap").getTypeId());
            this.m_cms.writeResource(siteRootResource);
        }
    }

    private void createIndexHTML(String siteRoot) throws CmsIllegalArgumentException, CmsException {
        if (!this.m_cms.existsResource(siteRoot + INDEX_HTML)) {
            I_CmsResourceType containerType = OpenCms.getResourceManager().getResourceType("containerpage");
            this.m_cms.createResource(siteRoot + INDEX_HTML, containerType);
        }
    }

    private void createSitemapContentFolder(CmsObject cms, CmsResource subSitemapFolder, String contentFolder) throws CmsException, CmsLoaderException {
        CmsResource configFile = null;
        String sitePath = cms.getSitePath(subSitemapFolder);
        String folderName = CmsStringUtil.joinPaths(sitePath, ".content/");
        String sitemapConfigName = CmsStringUtil.joinPaths(folderName, ".config");
        if (!cms.existsResource(folderName)) {
            cms.createResource(folderName, OpenCms.getResourceManager().getResourceType("content_folder"));
        }
        I_CmsResourceType configType = OpenCms.getResourceManager().getResourceType("sitemap_config");
        if (cms.existsResource(sitemapConfigName)) {
            configFile = cms.readResource(sitemapConfigName);
            if (!OpenCms.getResourceManager().getResourceType(configFile).getTypeName().equals(configType.getTypeName())) {
                throw new CmsException(Messages.get().container("ERR_CREATING_SUB_SITEMAP_WRONG_CONFIG_FILE_TYPE_2", sitemapConfigName, "sitemap_config"));
            }
        } else {
            configFile = cms.createResource(sitemapConfigName, OpenCms.getResourceManager().getResourceType("sitemap_config"));
        }
        if (configFile != null) {
            try {
                CmsResource newFolder = this.m_cms.createResource(contentFolder + NEW, OpenCms.getResourceManager().getResourceType("folder"));
                I_CmsResourceType containerType = OpenCms.getResourceManager().getResourceType("containerpage");
                CmsResource modelPage = this.m_cms.createResource(newFolder.getRootPath() + BLANK_HTML, containerType);
                String defTitle = Messages.get().getBundle(this.m_cms.getRequestContext().getLocale()).key("GUI_DEFAULT_MODEL_TITLE_1", this.m_site.getTitle());
                String defDes = Messages.get().getBundle(this.m_cms.getRequestContext().getLocale()).key("GUI_DEFAULT_MODEL_DESCRIPTION_1", this.m_site.getTitle());
                CmsProperty prop = new CmsProperty("Title", defTitle, defTitle);
                this.m_cms.writePropertyObject(modelPage.getRootPath(), prop);
                prop = new CmsProperty("Description", defDes, defDes);
                this.m_cms.writePropertyObject(modelPage.getRootPath(), prop);
                CmsFile file = this.m_cms.readFile(configFile);
                CmsXmlContent con = CmsXmlContentFactory.unmarshal(this.m_cms, file);
                con.addValue(this.m_cms, MODEL_PAGE, Locale.ENGLISH, 0);
                I_CmsXmlContentValue val = con.getValue(MODEL_PAGE_PAGE, Locale.ENGLISH);
                val.setStringValue(this.m_cms, modelPage.getRootPath());
                file.setContents(con.marshal());
                this.m_cms.writeFile(file);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private CmsResource createSiteRootIfNeeded(String siteRoot) throws CmsException {
        CmsResource siteRootResource = null;
        try {
            if (this.m_cms.existsResource(siteRoot)) {
                siteRootResource = this.m_cms.readResource(siteRoot);
            } else {
                CmsResource onlineVersion = this.m_cmsOnline.readResource(siteRoot);
                siteRootResource = this.m_cms.readResource(onlineVersion.getStructureId());
            }
        }
        catch (CmsVfsResourceNotFoundException e) {
            this.getReport().println(Messages.get().container("RPT_SITE_CREATE_RESOURCES_0"), 0);
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType("subsitemap");
            siteRootResource = this.m_cms.createResource(siteRoot, type);
            CmsProperty folderTitle = new CmsProperty("Title", this.m_site.getTitle(), this.m_site.getTitle());
            this.m_cms.writePropertyObject(siteRoot, folderTitle);
        }
        return siteRootResource;
    }

    private CmsObject getOnlineCmsObject(CmsObject cms) {
        CmsObject res = null;
        try {
            res = OpenCms.initCmsObject(cms);
            res.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
        }
        catch (CmsException e) {
            LOG.error((Object)"Cannot create CmsObject", (Throwable)e);
        }
        return res;
    }

    private void handleOU(CmsResource siteRootResource) {
        String ouName = null;
        String ouDescription = "OU for: %(site)";
        if (this.m_createOU) {
            this.getReport().println(Messages.get().container("RPT_SITE_CREATE_OU_1", this.m_parentOU + siteRootResource.getName()), 0);
            try {
                OpenCms.getOrgUnitManager().createOrganizationalUnit(this.m_cms, this.m_parentOU + siteRootResource.getName(), ouDescription.replace("%(site)", this.m_site.getTitle() + " [" + siteRootResource.getRootPath() + "]"), 0, siteRootResource.getRootPath());
                ouName = this.m_parentOU + siteRootResource.getName();
            }
            catch (CmsDataAccessException e) {
                LOG.info((Object)"Can't create OU, an OU with same name exists. The existing OU is chosen for the new site");
                try {
                    OpenCms.getOrgUnitManager().addResourceToOrgUnit(this.m_cms, this.m_parentOU + siteRootResource.getName(), siteRootResource.getRootPath());
                    ouName = this.m_parentOU + siteRootResource.getName();
                }
                catch (CmsException e2) {
                    LOG.info((Object)"Resource is already added to OU");
                    ouName = this.m_parentOU + siteRootResource.getName();
                }
            }
            catch (CmsException e) {
                LOG.error((Object)"Error on creating new OU", (Throwable)e);
            }
        }
        if (this.m_oldSite == null & this.m_selectedOU != null & !this.m_selectedOU.equals("/")) {
            this.getReport().println(Messages.get().container("RPT_SITE_ADD_OU_1", this.m_selectedOU), 0);
            try {
                OpenCms.getOrgUnitManager().addResourceToOrgUnit(this.m_cms, this.m_selectedOU, siteRootResource.getRootPath());
                ouName = this.m_selectedOU.substring(0, this.m_selectedOU.length() - 1);
            }
            catch (CmsException e) {
                LOG.error((Object)"Error on adding resource to OU", (Throwable)e);
            }
        }
        try {
            this.m_cms.lockResource(siteRootResource);
        }
        catch (CmsException e) {
            LOG.error((Object)"unable to lock resource", (Throwable)e);
        }
        if (ouName != null) {
            try {
                this.m_cms.chacc(siteRootResource.getRootPath(), "GROUP", ouName + "/Users", "+r+w+v+c+i+o+d");
            }
            catch (CmsException e) {
                LOG.error((Object)"Error on setting permission for OU.", (Throwable)e);
            }
        }
        try {
            this.m_cms.unlockResource(siteRootResource);
        }
        catch (CmsException e) {
            LOG.error((Object)"unable to unlock resource");
        }
    }

    private void saveFavIcon(String siteRoot) {
        if (this.m_os == null) {
            return;
        }
        if (this.m_os.size() == 0) {
            return;
        }
        this.getReport().println(Messages.get().container("RPT_SITE_SET_FAVICON_0"), 0);
        CmsResource favicon = null;
        try {
            favicon = this.m_cms.createResource(siteRoot + "favicon.ico", OpenCms.getResourceManager().getResourceType(CmsResourceTypeImage.getStaticTypeName()));
        }
        catch (CmsVfsResourceAlreadyExistsException e) {
            try {
                favicon = this.m_cms.readResource(siteRoot + "favicon.ico");
            }
            catch (CmsException e2) {
                this.getReport().println(Messages.get().container("RPT_SITE_ERROR_FAVICON_0"), 5);
                this.getReport().println(e);
                this.getReport().println(e2);
                return;
            }
        }
        catch (CmsException | CmsIllegalArgumentException e) {
            this.getReport().println(Messages.get().container("RPT_SITE_ERROR_FAVICON_0"), 5);
            this.getReport().println(e);
            return;
        }
        try {
            this.m_cms.lockResource(siteRoot + "favicon.ico");
            CmsFile faviconFile = new CmsFile(favicon);
            faviconFile.setContents(this.m_os.toByteArray());
            this.m_cms.writeFile(faviconFile);
            this.m_cms.unlockResource(siteRoot + "favicon.ico");
        }
        catch (CmsException e) {
            this.getReport().println(Messages.get().container("RPT_SITE_ERROR_FAVICON_0"), 5);
            this.getReport().println(e);
            return;
        }
    }

    private void setFolderTitle(CmsResource res) {
        try {
            CmsProperty titleProperty = this.m_cms.readPropertyObject(res, "Title", false);
            if (!titleProperty.isNullProperty()) {
                titleProperty.setValue(this.m_site.getTitle(), "individual");
                this.m_cms.writePropertyObject(res.getRootPath(), titleProperty);
            } else {
                LOG.error((Object)"Editing title property of site root resource was not possible");
                this.getReport().println(Messages.get().container("RPT_SITE_ERROR_TITLE_0"), 5);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Editing title property of site root resource was not possible", (Throwable)e);
            this.getReport().println(Messages.get().container("RPT_SITE_ERROR_TITLE_0"), 5);
            this.getReport().println(e);
        }
    }

    private void setTemplate(CmsResource siteRootResource) {
        try {
            this.m_cms.lockResource(siteRootResource);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_template)) {
                CmsProperty prop = new CmsProperty("template", this.m_template, this.m_template);
                this.m_cms.writePropertyObject(siteRootResource.getRootPath(), prop);
            }
            this.m_cms.unlockResource(siteRootResource);
        }
        catch (CmsException e) {
            LOG.error((Object)"Error on adding template", (Throwable)e);
        }
    }
}

