/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sitemanager;

import com.google.common.base.Supplier;
import com.vaadin.event.FieldEvents;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.server.UserError;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.Upload;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.site.CmsSSLMode;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.sitemanager.CmsCreateSiteThread;
import org.opencms.ui.apps.sitemanager.CmsSiteManager;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsRemovableFormRow;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.components.editablegroup.CmsEditableGroup;
import org.opencms.ui.components.editablegroup.I_CmsEditableGroupRow;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.ui.report.CmsReportWidget;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsEditSiteForm
extends CmsBasicDialog {
    public static final String MODULE_NAME = "org.opencms.ui.apps.sitemanager";
    public static final String PARAM_OU_DESCRIPTION = "oudescription";
    static final List<String> FORBIDDEN_FOLDER_NAMES = new ArrayList<String>(){
        private static final long serialVersionUID = 8074588073232610426L;
        {
            this.add("system");
            this.add(OpenCms.getSiteManager().getSharedFolder().replaceAll("/", ""));
        }
    };
    static Log LOG = CmsLog.getLog(CmsEditSiteForm.class.getName());
    private static final long serialVersionUID = -1011525709082939562L;
    protected boolean m_blockChange;
    List<String> m_alreadyUsedFolderPath = new ArrayList<String>();
    Set<CmsSiteMatcher> m_alreadyUsedURL = new HashSet<CmsSiteMatcher>();
    CmsObject m_clonedCms;
    ComboBox m_fieldSelectOU;
    ComboBox m_fieldSelectParentOU;
    Upload m_fieldUploadFavIcon;
    int m_imageCounter;
    CmsSiteManager m_manager;
    ByteArrayOutputStream m_os = new ByteArrayOutputStream(5500);
    CmsSite m_site;
    TabSheet m_tab;
    private Button m_addParameter;
    private VerticalLayout m_aliases;
    private CmsEditableGroup m_aliasGroup;
    private String m_autoSetFolderName;
    private Map<TextField, String> m_bundleComponentKeyMap;
    private FormLayout m_bundleValues;
    private Button m_cancel;
    private CheckBox m_fieldCreateOU;
    private CmsPathSelectField m_fieldErrorPage;
    private CheckBox m_fieldExclusiveError;
    private CheckBox m_fieldExclusiveURL;
    private Image m_fieldFavIcon;
    private CheckBox m_fieldKeepTemplate;
    private CmsPathSelectField m_fieldLoadSiteTemplate;
    private ComboBox m_fieldPosition;
    private TextField m_fieldSecureServer;
    private CheckBox m_fieldWebServer;
    private Panel m_infoSiteRoot;
    private boolean m_isFolderNameTouched;
    private Button m_ok;
    private Button.ClickListener m_okClickListener;
    private FormLayout m_parameter;
    private Panel m_report;
    private ComboBox m_simpleFieldEncryption;
    private TextField m_simpleFieldFolderName;
    private CmsPathSelectField m_simpleFieldParentFolderName;
    private TextField m_simpleFieldServer;
    private CmsPathSelectField m_simpleFieldSiteRoot;
    private ComboBox m_simpleFieldTemplate;
    private TextField m_simpleFieldTitle;
    private List<CmsResource> m_templates;
    private FormLayout m_threadReport;

    public CmsEditSiteForm(CmsObject cms, CmsSite site, CmsSiteManager manager, boolean editable) {
        this.m_clonedCms = cms;
        this.m_site = site;
        this.m_manager = manager;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.setUpComboBoxPosition();
        this.setUpComboBoxTemplate();
        this.setUpComboBoxSSL();
        this.setUpOUComboBox(this.m_fieldSelectOU);
        this.setUpOUComboBox(this.m_fieldSelectParentOU);
        this.m_tab.setHeight("400px");
        this.m_report.setVisible(false);
        this.m_ok.setVisible(editable);
        this.m_infoSiteRoot.setVisible(false);
        if (editable) {
            this.m_aliasGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_aliases, new Supplier<Component>(){

                public Component get() {
                    FormLayout c = CmsEditSiteForm.this.createAliasComponent("", true);
                    c.setEnabled(false);
                    return c;
                }
            }, CmsVaadinUtils.getMessageText("GUI_SITE_ADD_ALIAS_0", new Object[0]));
            this.m_aliasGroup.init();
        }
        this.setFieldsForSite(editable);
        this.m_cancel.addClickListener((Button.ClickListener & Serializable)e -> CmsVaadinUtils.getWindow((Component)this).close());
    }

    public CmsEditSiteForm(CmsObject cms, CmsSiteManager manager) {
        this.m_isFolderNameTouched = false;
        this.m_blockChange = true;
        this.m_autoSetFolderName = "";
        this.m_clonedCms = cms;
        List<CmsSite> allSites = manager.getAllElements();
        allSites.addAll(manager.getCorruptedSites());
        for (CmsSite site : allSites) {
            if (site.getSiteMatcher() == null) continue;
            this.m_alreadyUsedFolderPath.add(site.getSiteRoot());
        }
        this.m_alreadyUsedURL.addAll(OpenCms.getSiteManager().getSites().keySet());
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_tab.setHeight("400px");
        this.m_infoSiteRoot.setVisible(false);
        this.m_simpleFieldSiteRoot.setVisible(false);
        if (!OpenCms.getSiteManager().isConfigurableWebServer()) {
            this.m_fieldWebServer.setVisible(false);
            this.m_fieldWebServer.setValue((Object)new Boolean(true));
        }
        this.m_fieldKeepTemplate.setVisible(false);
        this.m_fieldKeepTemplate.setValue((Object)Boolean.FALSE);
        this.m_simpleFieldParentFolderName.setValue("/sites/");
        this.m_simpleFieldParentFolderName.setUseRootPaths(true);
        this.m_simpleFieldParentFolderName.setCmsObject(this.m_clonedCms);
        this.m_simpleFieldParentFolderName.requireFolder();
        this.m_simpleFieldParentFolderName.setResourceFilter(CmsResourceFilter.DEFAULT_FOLDERS);
        this.m_simpleFieldParentFolderName.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 4043563040462776139L;

            public void valueChange(Property.ValueChangeEvent event) {
                try {
                    String folderPath = CmsEditSiteForm.this.m_simpleFieldParentFolderName.getValue();
                    if ("subsitemap".equals(OpenCms.getResourceManager().getResourceType(CmsEditSiteForm.this.m_clonedCms.readResource(folderPath)).getTypeName())) {
                        String newFolderName = folderPath.split("/")[folderPath.split("/").length - 1];
                        CmsEditSiteForm.this.m_simpleFieldFolderName.setValue(newFolderName);
                        CmsEditSiteForm.this.m_simpleFieldParentFolderName.setValue(CmsEditSiteForm.this.m_simpleFieldParentFolderName.getValue().substring(0, folderPath.length() - 1 - newFolderName.length()));
                        CmsEditSiteForm.this.m_isFolderNameTouched = true;
                        if (CmsEditSiteForm.this.m_simpleFieldTitle.isEmpty()) {
                            CmsProperty title = CmsEditSiteForm.this.m_clonedCms.readPropertyObject(CmsEditSiteForm.this.m_clonedCms.readResource(folderPath), "Title", false);
                            if (!CmsProperty.getNullProperty().equals(title)) {
                                CmsEditSiteForm.this.m_simpleFieldTitle.setValue(title.getValue());
                            }
                        }
                    }
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
                CmsEditSiteForm.this.setUpOUComboBox(CmsEditSiteForm.this.m_fieldSelectParentOU);
                CmsEditSiteForm.this.setUpOUComboBox(CmsEditSiteForm.this.m_fieldSelectOU);
            }
        });
        this.m_manager = manager;
        this.m_addParameter.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 6814134727761004218L;

            public void buttonClick(Button.ClickEvent event) {
                CmsEditSiteForm.this.addParameter(null);
            }
        });
        this.m_okClickListener = new Button.ClickListener(){
            private static final long serialVersionUID = 6814134727761004218L;

            public void buttonClick(Button.ClickEvent event) {
                CmsEditSiteForm.this.setupValidators();
                CmsEditSiteForm.this.setupValidatorAliase();
                if (CmsEditSiteForm.this.isValidInputSimple() & CmsEditSiteForm.this.isValidInputSiteTemplate() & CmsEditSiteForm.this.isValidAliase()) {
                    CmsEditSiteForm.this.submit();
                    return;
                }
                if (CmsEditSiteForm.this.isValidInputSimple()) {
                    if (CmsEditSiteForm.this.isValidAliase()) {
                        CmsEditSiteForm.this.m_tab.setSelectedTab(4);
                        return;
                    }
                    CmsEditSiteForm.this.m_tab.setSelectedTab(3);
                    return;
                }
                CmsEditSiteForm.this.m_tab.setSelectedTab(0);
            }
        };
        this.m_ok.addClickListener(this.m_okClickListener);
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -276802394623141951L;

            public void buttonClick(Button.ClickEvent event) {
                CmsEditSiteForm.this.closeDailog(false);
            }
        });
        this.m_fieldCreateOU.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -2837270577662919541L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsEditSiteForm.this.toggleSelectOU();
            }
        });
        this.setUpComboBoxPosition();
        this.setUpComboBoxTemplate();
        this.setUpComboBoxSSL();
        this.setUpOUComboBox(this.m_fieldSelectOU);
        this.setUpOUComboBox(this.m_fieldSelectParentOU);
        this.m_fieldSecureServer.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -2837270577662919541L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsEditSiteForm.this.toggleSecureServer();
            }
        });
        this.m_fieldExclusiveURL.setEnabled(false);
        this.m_fieldExclusiveError.setEnabled(false);
        FavIconReceiver uploadReceiver = new FavIconReceiver();
        this.m_fieldWebServer.setValue((Object)new Boolean(true));
        this.m_fieldUploadFavIcon.setReceiver((Upload.Receiver)uploadReceiver);
        this.m_fieldUploadFavIcon.setButtonCaption(CmsVaadinUtils.getMessageText("GUI_SITE_SELECT_FILE_0", new Object[0]));
        this.m_fieldUploadFavIcon.setImmediate(true);
        this.m_fieldUploadFavIcon.addSucceededListener((Upload.SucceededListener)uploadReceiver);
        this.m_fieldUploadFavIcon.setCaption(CmsVaadinUtils.getMessageText("GUI_SITE_FAVICON_NEW_0", new Object[0]));
        this.m_fieldFavIcon.setVisible(false);
        this.m_simpleFieldTitle.addBlurListener(new FieldEvents.BlurListener(){
            private static final long serialVersionUID = -4147179568264310325L;

            public void blur(FieldEvents.BlurEvent event) {
                if (!CmsEditSiteForm.this.getFieldTitle().isEmpty() & !CmsEditSiteForm.this.isFolderNameTouched()) {
                    String niceName = OpenCms.getResourceManager().getNameGenerator().getUniqueFileName(CmsEditSiteForm.this.m_clonedCms, "/sites", CmsEditSiteForm.this.getFieldTitle().toLowerCase());
                    CmsEditSiteForm.this.setFolderNameState(niceName);
                    CmsEditSiteForm.this.setFieldFolder(niceName);
                }
            }
        });
        this.m_simpleFieldFolderName.addBlurListener(new FieldEvents.BlurListener(){
            private static final long serialVersionUID = 2080245499551324408L;

            public void blur(FieldEvents.BlurEvent event) {
                CmsEditSiteForm.this.checkTemplate();
                CmsEditSiteForm.this.setFolderNameState(null);
            }
        });
        this.m_fieldLoadSiteTemplate.addValidator(new SiteTemplateValidator());
        this.m_fieldLoadSiteTemplate.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -5859547073423161234L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsEditSiteForm.this.resetFields();
                CmsEditSiteForm.this.loadMessageBundle();
                CmsEditSiteForm.this.m_manager.centerWindow();
            }
        });
        this.m_fieldLoadSiteTemplate.setUseRootPaths(true);
        this.m_fieldLoadSiteTemplate.setCmsObject(this.m_clonedCms);
        this.m_fieldLoadSiteTemplate.requireFolder();
        this.m_fieldLoadSiteTemplate.setResourceFilter(CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireFolder());
        this.m_fieldSelectParentOU.setEnabled(false);
        this.m_report.setVisible(false);
        this.m_blockChange = false;
        this.m_aliasGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_aliases, new Supplier<Component>(){

            public Component get() {
                return CmsEditSiteForm.this.createAliasComponent("", true);
            }
        }, CmsVaadinUtils.getMessageText("GUI_SITE_ADD_ALIAS_0", new Object[0]));
        this.m_aliasGroup.init();
    }

    public CmsEditSiteForm(CmsObject cms, CmsSiteManager manager, String siteRoot) {
        this(cms, manager);
        this.m_site = manager.getElement(siteRoot);
        this.setFieldsForSite(true);
    }

    protected static IndexedContainer getSSLModeContainer(String captionProp, boolean includeOldStyle, CmsSSLMode currentValue) {
        IndexedContainer res = new IndexedContainer();
        res.addContainerProperty((Object)captionProp, String.class, (Object)"");
        boolean isLetsEncrypt = currentValue == CmsSSLMode.LETS_ENCRYPT;
        boolean letsEncryptConfigured = OpenCms.getLetsEncryptConfig() != null && OpenCms.getLetsEncryptConfig().isValidAndEnabled();
        boolean skipLetsEncrypt = !letsEncryptConfigured && !isLetsEncrypt;
        for (CmsSSLMode mode : CmsSSLMode.availableModes(includeOldStyle, !skipLetsEncrypt)) {
            Item item = res.addItem((Object)mode);
            item.getItemProperty((Object)captionProp).setValue((Object)mode.getLocalizedMessage());
        }
        return res;
    }

    static String getFolderNameFromSiteRoot(String siteRoot) {
        return siteRoot.split("/")[siteRoot.split("/").length - 1];
    }

    protected void checkOnOfflineSiteRoot() {
        try {
            CmsObject cmsOnline = OpenCms.initCmsObject(this.m_clonedCms);
            cmsOnline.getRequestContext().setCurrentProject(this.m_clonedCms.readProject(CmsProject.ONLINE_PROJECT_ID));
            String rootPath = this.m_simpleFieldSiteRoot.getValue();
            if (cmsOnline.existsResource(rootPath) & !this.m_clonedCms.existsResource(rootPath)) {
                this.m_ok.setEnabled(false);
                this.m_infoSiteRoot.setVisible(true);
                return;
            }
            if (!this.m_site.getSiteRootUUID().isNullUUID() && this.m_clonedCms.existsResource(this.m_site.getSiteRootUUID()) & !this.m_clonedCms.existsResource(rootPath)) {
                this.m_ok.setEnabled(false);
                this.m_infoSiteRoot.setVisible(true);
                return;
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Can not initialize CmsObject", (Throwable)e);
        }
        this.m_ok.setEnabled(true);
        this.m_infoSiteRoot.setVisible(false);
    }

    protected void checkTemplate() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_simpleFieldFolderName.getValue())) {
            return;
        }
        if (!this.m_clonedCms.existsResource(this.getSiteRoot())) {
            return;
        }
        try {
            String templateValue = this.m_clonedCms.readPropertyObject(this.getSiteRoot(), "template", false).getValue();
            this.m_simpleFieldTemplate.addItem((Object)templateValue);
            this.m_simpleFieldTemplate.setValue((Object)templateValue);
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    protected FormLayout createAliasComponent(String alias, boolean red) {
        FormLayout layout = new FormLayout();
        TextField field = new TextField(CmsVaadinUtils.getMessageText("GUI_SITE_ALIAS_0", new Object[0]));
        field.setWidth("100%");
        field.setValue(alias);
        field.setDescription(CmsVaadinUtils.getMessageText("GUI_SITE_ALIAS_HELP_0", new Object[0]));
        CheckBox redirect = new CheckBox(CmsVaadinUtils.getMessageText("GUI_SITE_ALIAS_REDIRECT_0", new Object[0]), red);
        redirect.setDescription(CmsVaadinUtils.getMessageText("GUI_SITE_ALIAS_REDIRECT_HELP_0", new Object[0]));
        layout.addComponent((Component)field);
        layout.addComponent((Component)redirect);
        return layout;
    }

    protected String getFieldServer() {
        return (String)this.m_simpleFieldServer.getValue();
    }

    protected void handleSSLChange() {
        String toBeReplaced = "http:";
        String newString = "https:";
        CmsSSLMode mode = (CmsSSLMode)((Object)this.m_simpleFieldEncryption.getValue());
        if (mode == null) {
            return;
        }
        if (mode.equals((Object)CmsSSLMode.NO) | mode.equals((Object)CmsSSLMode.SECURE_SERVER)) {
            toBeReplaced = "https:";
            newString = "http:";
        }
        this.m_simpleFieldServer.setValue(((String)this.m_simpleFieldServer.getValue()).replaceAll(toBeReplaced, newString));
        this.m_fieldSecureServer.setVisible(mode.equals((Object)CmsSSLMode.SECURE_SERVER));
        this.m_fieldExclusiveError.setVisible(mode.equals((Object)CmsSSLMode.SECURE_SERVER));
        this.m_fieldExclusiveURL.setVisible(mode.equals((Object)CmsSSLMode.SECURE_SERVER));
    }

    protected void setTemplateField() {
        try {
            CmsProperty template = this.m_clonedCms.readPropertyObject(this.getSiteRoot(), "template", false);
            if (template.isNullProperty()) {
                this.m_simpleFieldTemplate.setValue(null);
            } else {
                this.m_simpleFieldTemplate.setValue((Object)template.getStructureValue());
            }
        }
        catch (CmsException e) {
            this.m_simpleFieldTemplate.setValue(null);
        }
    }

    void addParameter(String parameter) {
        TextField textField = new TextField();
        if (parameter != null) {
            textField.setValue(parameter);
        }
        CmsRemovableFormRow<TextField> row = new CmsRemovableFormRow<TextField>(textField, CmsVaadinUtils.getMessageText("GUI_SITE_REMOVE_PARAMETER_0", new Object[0]));
        row.setCaption(CmsVaadinUtils.getMessageText("GUI_SITE_PARAMETER_0", new Object[0]));
        row.setDescription(CmsVaadinUtils.getMessageText("GUI_SITE_PARAMETER_HELP_0", new Object[0]));
        this.m_parameter.addComponent(row);
    }

    void closeDailog(boolean updateTable) {
        this.m_manager.closeDialogWindow(updateTable);
    }

    String ensureFoldername(String resourcename) {
        if (CmsStringUtil.isEmpty(resourcename)) {
            return "";
        }
        if (!CmsResource.isFolder(resourcename)) {
            resourcename = resourcename.concat("/");
        }
        if (resourcename.charAt(0) == '/') {
            resourcename = resourcename.substring(1);
        }
        return resourcename;
    }

    String getFieldFolder() {
        return (String)this.m_simpleFieldFolderName.getValue();
    }

    String getFieldTitle() {
        return (String)this.m_simpleFieldTitle.getValue();
    }

    String getParentFolder() {
        return this.m_simpleFieldParentFolderName.getValue();
    }

    String getSiteTemplatePath() {
        return this.m_fieldLoadSiteTemplate.getValue();
    }

    boolean isDoubleAlias(String aliasName) {
        CmsSiteMatcher testAlias = new CmsSiteMatcher(aliasName);
        int count = 0;
        for (Component c : this.m_aliases) {
            String alName;
            if (!(c instanceof CmsRemovableFormRow) || !testAlias.equals(new CmsSiteMatcher(alName = (String)((AbstractField)((CmsRemovableFormRow)c).getInput()).getValue()))) continue;
            ++count;
        }
        return count > 1;
    }

    boolean isFolderNameTouched() {
        if (this.m_site != null) {
            return true;
        }
        if (this.m_autoSetFolderName.equals(this.getFieldFolder())) {
            return false;
        }
        return this.m_isFolderNameTouched;
    }

    boolean isValidAliase() {
        boolean ret = true;
        for (I_CmsEditableGroupRow row : this.m_aliasGroup.getRows()) {
            FormLayout layout = (FormLayout)row.getComponent();
            TextField field = (TextField)layout.getComponent(0);
            ret &= field.isValid();
        }
        return ret;
    }

    boolean isValidInputSimple() {
        return this.m_simpleFieldFolderName.isValid() & this.m_simpleFieldServer.isValid() & this.m_simpleFieldTitle.isValid() & this.m_simpleFieldParentFolderName.isValid() & this.m_fieldSelectOU.isValid() & this.m_simpleFieldSiteRoot.isValid();
    }

    boolean isValidInputSiteTemplate() {
        return this.m_fieldLoadSiteTemplate.isValid() & this.m_fieldSelectParentOU.isValid();
    }

    void loadMessageBundle() {
        if (!this.m_fieldLoadSiteTemplate.isValid() | this.m_fieldLoadSiteTemplate.isEmpty() | !CmsSiteManager.isFolderWithMacros(this.m_clonedCms, this.m_fieldLoadSiteTemplate.getValue())) {
            return;
        }
        try {
            this.m_bundleComponentKeyMap = new HashMap<TextField, String>();
            CmsResource descriptor = this.m_clonedCms.readResource(this.m_fieldLoadSiteTemplate.getValue() + ".macros" + "/" + "siteMacroBundle" + "_desc");
            Properties resourceBundle = this.getLocalizedBundle();
            Map<String, String[]> bundleKeyDescriptorMap = CmsMacroResolver.getBundleMapFromResources(resourceBundle, descriptor, this.m_clonedCms);
            for (String key : bundleKeyDescriptorMap.keySet()) {
                TextField field = new TextField();
                field.setCaption(bundleKeyDescriptorMap.get(key)[0]);
                field.setValue(bundleKeyDescriptorMap.get(key)[1]);
                field.setWidth("100%");
                this.m_bundleValues.addComponent((Component)field);
                this.m_bundleComponentKeyMap.put(field, key);
            }
        }
        catch (IOException | CmsException e) {
            LOG.error((Object)"Error reading bundle", (Throwable)e);
        }
    }

    void resetFields() {
        if (this.m_bundleComponentKeyMap != null) {
            Set<TextField> setBundles = this.m_bundleComponentKeyMap.keySet();
            for (TextField field : setBundles) {
                this.m_bundleValues.removeComponent((Component)field);
            }
            this.m_bundleComponentKeyMap.clear();
        }
        this.m_fieldKeepTemplate.setVisible(!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_fieldLoadSiteTemplate.getValue()));
        this.m_fieldKeepTemplate.setValue((Object)(!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_fieldLoadSiteTemplate.getValue()) ? 1 : 0));
    }

    void setCurrentFavIcon(final byte[] imageData) {
        this.m_fieldFavIcon.setVisible(true);
        this.m_fieldUploadFavIcon.setCaption(CmsVaadinUtils.getMessageText("GUI_SITE_FAVICON_CHANGE_0", new Object[0]));
        this.m_fieldFavIcon.setSource((Resource)new StreamResource(new StreamResource.StreamSource(){
            private static final long serialVersionUID = -8868657402793427460L;

            public InputStream getStream() {
                return new ByteArrayInputStream(imageData);
            }
        }, ""));
    }

    void setFaviconIfExist() {
        try {
            CmsResource favicon = this.m_clonedCms.readResource(this.m_site.getSiteRoot() + "/" + "favicon.ico");
            this.setCurrentFavIcon(this.m_clonedCms.readFile(favicon).getContents());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    void setFieldFolder(String newValue) {
        this.m_simpleFieldFolderName.setValue(newValue);
    }

    void setFolderNameState(String setFolderName) {
        if (setFolderName == null) {
            if (((String)this.m_simpleFieldFolderName.getValue()).isEmpty()) {
                this.m_isFolderNameTouched = false;
                return;
            }
            this.m_isFolderNameTouched = true;
        } else {
            this.m_autoSetFolderName = setFolderName;
        }
    }

    void setOkButtonEnabled() {
        this.m_ok.setEnabled(true);
        this.m_ok.setCaption(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CLOSE_0", new Object[0]));
        this.m_ok.removeClickListener(this.m_okClickListener);
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5637556711524961424L;

            public void buttonClick(Button.ClickEvent event) {
                CmsEditSiteForm.this.closeDailog(true);
            }
        });
    }

    void setUpOUComboBox(ComboBox combo) {
        combo.removeAllItems();
        try {
            if (this.m_site != null) {
                String siteOu = this.getSiteOU();
                combo.addItem((Object)siteOu);
                combo.select((Object)siteOu);
                combo.setEnabled(false);
            } else {
                combo.addItem((Object)"/");
                this.m_clonedCms.getRequestContext().setSiteRoot("");
                List<CmsOrganizationalUnit> ous = OpenCms.getOrgUnitManager().getOrganizationalUnits(this.m_clonedCms, "/", true);
                for (CmsOrganizationalUnit ou : ous) {
                    if (!this.ouIsOK(ou)) continue;
                    combo.addItem((Object)ou.getName());
                }
                combo.select((Object)"/");
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Error on reading OUs", (Throwable)e);
        }
        combo.setNullSelectionAllowed(false);
        combo.setTextInputAllowed(true);
        combo.setFilteringMode(FilteringMode.CONTAINS);
        combo.setNewItemsAllowed(false);
    }

    void setupValidatorAliase() {
        for (I_CmsEditableGroupRow row : this.m_aliasGroup.getRows()) {
            FormLayout layout = (FormLayout)row.getComponent();
            TextField field = (TextField)layout.getComponent(0);
            field.removeAllValidators();
            field.addValidator((Validator)new AliasValidator());
        }
    }

    void setupValidators() {
        if (this.m_simpleFieldServer.getValidators().size() == 0) {
            if (this.m_site == null) {
                this.m_simpleFieldFolderName.addValidator((Validator)new FolderPathValidator());
                this.m_simpleFieldParentFolderName.addValidator(new ParentFolderValidator());
            }
            this.m_simpleFieldServer.addValidator((Validator)new ServerValidator());
            this.m_simpleFieldTitle.addValidator((Validator)new TitleValidator());
            if (this.m_site == null) {
                this.m_fieldSelectOU.addValidator((Validator)new SelectOUValidator());
            }
            if (((Boolean)this.m_fieldCreateOU.getValue()).booleanValue()) {
                this.m_fieldSelectParentOU.addValidator((Validator)new SelectParentOUValidator());
            }
        }
    }

    void submit() {
        this.m_clonedCms.getRequestContext().setSiteRoot("");
        CmsSite site = this.getSiteFromForm();
        if (this.m_site == null) {
            this.m_report.setVisible(true);
            this.m_tab.setVisible(false);
            this.m_ok.setEnabled(false);
            this.m_ok.setVisible(true);
            this.m_cancel.setVisible(false);
            this.setOkButtonEnabled();
            this.m_cancel.setCaption(CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CLOSE_0", new Object[0]));
            Map<String, String> bundle = this.getBundleMap();
            boolean createOU = this.m_fieldCreateOU.isEnabled() & (Boolean)this.m_fieldCreateOU.getValue();
            CmsCreateSiteThread createThread = new CmsCreateSiteThread(this.m_clonedCms, this.m_manager, site, this.m_site, this.m_fieldLoadSiteTemplate.getValue(), this.getFieldTemplate(), createOU, (String)this.m_fieldSelectParentOU.getValue(), (String)this.m_fieldSelectOU.getValue(), this.m_os, bundle, new Runnable(){

                @Override
                public void run() {
                }
            });
            CmsReportWidget report = new CmsReportWidget(createThread);
            report.setWidth("100%");
            report.setHeight("350px");
            this.m_threadReport.addComponent((Component)report);
            createThread.start();
        } else {
            if (!site.getSiteRoot().equals(this.m_site.getSiteRoot())) {
                this.m_manager.deleteElements(Collections.singletonList(this.m_site.getSiteRoot()));
            }
            this.m_manager.writeElement(site);
            this.m_manager.closeDialogWindow(true);
        }
    }

    void toggleSecureServer() {
        if (this.m_fieldSecureServer.isEmpty()) {
            this.m_fieldExclusiveURL.setEnabled(false);
            this.m_fieldExclusiveError.setEnabled(false);
            return;
        }
        this.m_fieldExclusiveURL.setEnabled(true);
        this.m_fieldExclusiveError.setEnabled(true);
    }

    void toggleSelectOU() {
        boolean create = (Boolean)this.m_fieldCreateOU.getValue();
        this.m_fieldSelectOU.setEnabled(!create);
        this.m_fieldSelectParentOU.setEnabled(create);
        this.m_fieldSelectOU.select((Object)"/");
    }

    private List<CmsSiteMatcher> getAliases() {
        ArrayList<CmsSiteMatcher> ret = new ArrayList<CmsSiteMatcher>();
        for (I_CmsEditableGroupRow row : this.m_aliasGroup.getRows()) {
            FormLayout layout = (FormLayout)row.getComponent();
            CheckBox box = (CheckBox)layout.getComponent(1);
            TextField field = (TextField)layout.getComponent(0);
            CmsSiteMatcher matcher = new CmsSiteMatcher((String)field.getValue());
            matcher.setRedirect((Boolean)box.getValue());
            ret.add(matcher);
        }
        return ret;
    }

    private String getAvailableLocalVariant(String path, String baseName) {
        try {
            CmsProperty propLoc = this.m_clonedCms.readPropertyObject(path, "locale", true);
            if (!propLoc.isNullProperty() && this.m_clonedCms.existsResource(path + baseName + "_" + propLoc.getValue())) {
                return baseName + "_" + propLoc.getValue();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Can not read locale property", (Throwable)e);
        }
        A_CmsUI.get();
        List<String> localVariations = CmsLocaleManager.getLocaleVariants(baseName, UI.getCurrent().getLocale(), false, true);
        for (String name : localVariations) {
            if (!this.m_clonedCms.existsResource(path + name)) continue;
            return name;
        }
        return null;
    }

    private Map<String, String> getBundleMap() {
        HashMap<String, String> bundles = new HashMap<String, String>();
        if (this.m_bundleComponentKeyMap != null) {
            Set<TextField> fields = this.m_bundleComponentKeyMap.keySet();
            for (TextField field : fields) {
                bundles.put(this.m_bundleComponentKeyMap.get(field), (String)field.getValue());
            }
        }
        return bundles;
    }

    private String getFieldTemplate() {
        if (((Boolean)this.m_fieldKeepTemplate.getValue()).booleanValue()) {
            return "";
        }
        Object value = this.m_simpleFieldTemplate.getValue();
        if (value != null) {
            return (String)value;
        }
        return "";
    }

    private Properties getLocalizedBundle() throws CmsException, IOException {
        CmsResource bundleResource = this.m_clonedCms.readResource(this.m_fieldLoadSiteTemplate.getValue() + ".macros" + "/" + this.getAvailableLocalVariant(this.m_fieldLoadSiteTemplate.getValue() + ".macros" + "/", "siteMacroBundle"));
        Properties ret = new Properties();
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(this.m_clonedCms.readFile(bundleResource).getContents()), StandardCharsets.UTF_8);
        ret.load(reader);
        return ret;
    }

    private Map<String, String> getParameter() {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        for (Component c : this.m_parameter) {
            if (!(c instanceof CmsRemovableFormRow)) continue;
            String[] parameterStringArray = ((String)((AbstractField)((CmsRemovableFormRow)c).getInput()).getValue()).split("=");
            ret.put(parameterStringArray[0], parameterStringArray[1]);
        }
        return ret;
    }

    private String getParameterString(Map.Entry<String, String> parameter) {
        return parameter.getKey() + "=" + parameter.getValue();
    }

    private CmsSite getSiteFromForm() {
        String siteRoot = this.getSiteRoot();
        CmsSiteMatcher matcher = CmsStringUtil.isNotEmpty((String)this.m_fieldSecureServer.getValue()) & this.m_simpleFieldEncryption.getValue().equals((Object)CmsSSLMode.SECURE_SERVER) ? new CmsSiteMatcher((String)this.m_fieldSecureServer.getValue()) : null;
        CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
        CmsUUID uuid = new CmsUUID();
        if (site != null && site.getSiteMatcher() != null) {
            uuid = (CmsUUID)site.getSiteRootUUID().clone();
        }
        String errorPage = CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_fieldErrorPage.getValue()) ? this.m_fieldErrorPage.getValue() : null;
        List<CmsSiteMatcher> aliases = this.getAliases();
        CmsSite ret = new CmsSite(siteRoot, uuid, this.getFieldTitle(), new CmsSiteMatcher(this.getFieldServer()), ((PositionComboBoxElementBean)this.m_fieldPosition.getValue()).getPosition() == -1.0f ? String.valueOf(this.m_site.getPosition()) : String.valueOf(((PositionComboBoxElementBean)this.m_fieldPosition.getValue()).getPosition()), errorPage, matcher, (Boolean)this.m_fieldExclusiveURL.getValue(), (Boolean)this.m_fieldExclusiveError.getValue(), (Boolean)this.m_fieldWebServer.getValue(), aliases);
        ret.setParameters((SortedMap)this.getParameter());
        ret.setSSLMode((CmsSSLMode)((Object)this.m_simpleFieldEncryption.getValue()));
        return ret;
    }

    private String getSiteOU() {
        try {
            this.m_clonedCms.getRequestContext().setSiteRoot("");
            CmsResource resource = this.m_clonedCms.readResource(this.m_site.getSiteRoot());
            List<CmsRelation> relations = this.m_clonedCms.getRelationsForResource(resource, CmsRelationFilter.SOURCES);
            for (CmsRelation relation : relations) {
                if (!relation.getSourcePath().startsWith("/system/orgunits/")) continue;
                return relation.getSourcePath().substring("/system/orgunits/".length());
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Error on reading OUs", (Throwable)e);
        }
        return "/";
    }

    private String getSiteRoot() {
        String res;
        res = this.m_simpleFieldSiteRoot.isVisible() ? this.m_simpleFieldSiteRoot.getValue() : ((res = "/" + this.ensureFoldername(this.getParentFolder()) + this.ensureFoldername(this.getFieldFolder())).endsWith("/") ? res.substring(0, res.length() - 1) : res);
        return res;
    }

    private boolean ouIsOK(CmsOrganizationalUnit ou) {
        try {
            for (CmsResource res : OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.m_clonedCms, ou.getName())) {
                if (!this.m_simpleFieldParentFolderName.getValue().startsWith(res.getRootPath())) continue;
                return true;
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read Resources for Org Unit", (Throwable)e);
        }
        return false;
    }

    private void setFieldServer(String newValue) {
        this.m_simpleFieldServer.setValue(newValue);
    }

    private void setFieldsForSite(boolean enableAll) {
        try {
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_site.getSiteRoot())) {
                CmsProperty prop = this.m_clonedCms.readPropertyObject(this.m_site.getSiteRoot(), "template", false);
                if (!prop.isNullProperty()) {
                    if (!this.m_templates.contains(prop.getValue())) {
                        this.m_simpleFieldTemplate.addItem((Object)prop.getValue());
                    }
                    this.m_simpleFieldTemplate.select((Object)prop.getValue());
                } else if (!this.m_templates.isEmpty()) {
                    this.m_simpleFieldTemplate.setValue((Object)this.m_templates.get(0).getRootPath());
                }
                this.m_simpleFieldTemplate.setEnabled(enableAll);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read template property.", (Throwable)e);
        }
        this.m_simpleFieldSiteRoot.setVisible(true);
        this.m_simpleFieldSiteRoot.setValue(this.m_site.getSiteRoot());
        this.m_simpleFieldSiteRoot.setCmsObject(this.m_clonedCms);
        this.m_simpleFieldSiteRoot.addValidator(new SiteRootValidator());
        this.m_simpleFieldSiteRoot.setEnabled(enableAll);
        this.m_simpleFieldSiteRoot.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 4680456758446195524L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsEditSiteForm.this.setTemplateField();
                CmsEditSiteForm.this.checkOnOfflineSiteRoot();
            }
        });
        this.m_simpleFieldParentFolderName.setVisible(false);
        this.m_simpleFieldFolderName.setVisible(false);
        this.displayResourceInfoDirectly(Collections.singletonList(new CmsResourceInfo(this.m_site.getTitle(), this.m_site.getSiteRoot(), this.m_manager.getFavIcon(this.m_site.getSiteRoot()))));
        this.m_tab.removeTab(this.m_tab.getTab(4));
        this.m_simpleFieldTitle.removeTextChangeListener(null);
        this.m_simpleFieldTitle.setEnabled(enableAll);
        this.m_simpleFieldParentFolderName.setEnabled(false);
        this.m_simpleFieldParentFolderName.setValue(this.m_site.getSiteRoot().substring(0, this.m_site.getSiteRoot().length() - this.m_site.getSiteRoot().split("/")[this.m_site.getSiteRoot().split("/").length - 1].length()));
        this.m_simpleFieldFolderName.removeAllValidators();
        this.m_fieldCreateOU.setVisible(false);
        this.m_alreadyUsedURL.remove(this.m_site.getSiteMatcher().forDifferentScheme("https"));
        this.m_alreadyUsedURL.remove(this.m_site.getSiteMatcher().forDifferentScheme("http"));
        this.setFieldTitle(this.m_site.getTitle());
        this.setFieldFolder(CmsEditSiteForm.getFolderNameFromSiteRoot(this.m_site.getSiteRoot()));
        this.m_simpleFieldFolderName.setEnabled(false);
        this.m_simpleFieldTitle.setEnabled(enableAll);
        this.setFieldServer(this.m_site.getUrl());
        this.m_simpleFieldServer.setEnabled(enableAll);
        if (this.m_site.hasSecureServer()) {
            this.m_fieldSecureServer.setValue(this.m_site.getSecureUrl());
        }
        if (this.m_site.getErrorPage() != null) {
            this.m_fieldErrorPage.setValue(this.m_site.getErrorPage());
        }
        this.m_fieldWebServer.setValue((Object)new Boolean(this.m_site.isWebserver()));
        this.m_fieldWebServer.setEnabled(enableAll);
        this.m_fieldExclusiveURL.setValue((Object)new Boolean(this.m_site.isExclusiveUrl()));
        this.m_fieldExclusiveURL.setEnabled(enableAll);
        this.m_fieldExclusiveError.setValue((Object)new Boolean(this.m_site.isExclusiveError()));
        this.m_fieldExclusiveError.setEnabled(enableAll);
        SortedMap<String, String> siteParameters = this.m_site.getParameters();
        for (Map.Entry<String, String> entry : siteParameters.entrySet()) {
            this.addParameter(this.getParameterString(entry));
        }
        List<CmsSiteMatcher> siteAliases = this.m_site.getAliases();
        for (CmsSiteMatcher siteMatcher : siteAliases) {
            if (enableAll) {
                this.m_aliasGroup.addRow((Component)this.createAliasComponent(siteMatcher.getUrl(), siteMatcher.isRedirect()));
                continue;
            }
            FormLayout c = this.createAliasComponent(siteMatcher.getUrl(), siteMatcher.isRedirect());
            c.setEnabled(false);
            this.m_aliases.addComponent((Component)c);
        }
        this.setTemplateField();
        this.setUpComboBoxPosition();
        if (!this.m_fieldSecureServer.isEmpty()) {
            this.m_fieldExclusiveURL.setEnabled(enableAll);
            this.m_fieldExclusiveError.setEnabled(enableAll);
        }
        this.setFaviconIfExist();
        this.checkOnOfflineSiteRoot();
        this.m_fieldUploadFavIcon.setVisible(false);
        this.m_simpleFieldEncryption.setContainerDataSource((Container)CmsEditSiteForm.getSSLModeContainer("caption", true, this.m_site.getSSLMode()));
        this.m_simpleFieldEncryption.select((Object)this.m_site.getSSLMode());
        this.m_simpleFieldEncryption.setEnabled(enableAll);
        this.m_fieldErrorPage.setEnabled(enableAll);
        this.m_addParameter.setVisible(enableAll);
        this.m_fieldPosition.setEnabled(enableAll);
    }

    private void setFieldTitle(String newValue) {
        this.m_simpleFieldTitle.setValue(newValue);
    }

    private void setUpComboBoxPosition() {
        this.m_fieldPosition.removeAllItems();
        ArrayList<CmsSite> sites = new ArrayList<CmsSite>();
        ArrayList<PositionComboBoxElementBean> beanList = new ArrayList<PositionComboBoxElementBean>();
        for (CmsSite site : OpenCms.getSiteManager().getAvailableSites(this.m_clonedCms, true)) {
            if (site.getSiteMatcher() == null) continue;
            sites.add(site);
        }
        float maxValue = 0.0f;
        float nextPos = 0.0f;
        float firstValue = 1.0f;
        if (sites.size() > 0) {
            try {
                maxValue = ((CmsSite)sites.get(0)).getPosition();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (maxValue != 0.0f) {
            firstValue = maxValue / 2.0f;
        }
        beanList.add(new PositionComboBoxElementBean(CmsVaadinUtils.getMessageText("GUI_SITE_CHNAV_POS_FIRST_0", new Object[0]), firstValue));
        for (int i = 0; i < sites.size(); ++i) {
            float navPos = ((CmsSite)sites.get(i)).getPosition();
            String siteRoot = ((CmsSite)sites.get(i)).getSiteRoot();
            nextPos = navPos + 2.0f;
            if (i + 1 < sites.size()) {
                nextPos = ((CmsSite)sites.get(i + 1)).getPosition();
            }
            float newPos = nextPos - navPos > 1.0f ? navPos + 1.0f : (navPos + nextPos) / 2.0f;
            if (navPos > maxValue) {
                maxValue = navPos;
            }
            if (this.m_site != null && this.m_site.getSiteRoot() != null && this.m_site.getSiteRoot().equals(siteRoot)) {
                beanList.add(new PositionComboBoxElementBean(CmsVaadinUtils.getMessageText("GUI_SITE_CHNAV_POS_CURRENT_1", this.m_site.getTitle()), -1.0f));
                continue;
            }
            beanList.add(new PositionComboBoxElementBean(((CmsSite)sites.get(i)).getTitle(), newPos));
        }
        PositionComboBoxElementBean lastEntry = new PositionComboBoxElementBean(CmsVaadinUtils.getMessageText("GUI_SITE_CHNAV_POS_LAST_0", new Object[0]), maxValue + 1.0f);
        beanList.add(lastEntry);
        beanList.add(new PositionComboBoxElementBean(CmsVaadinUtils.getMessageText("GUI_SITE_CHNAV_POS_NOCHANGE_0", new Object[0]), -1.0f));
        BeanItemContainer objects = new BeanItemContainer(PositionComboBoxElementBean.class, beanList);
        this.m_fieldPosition.setContainerDataSource((Container)objects);
        this.m_fieldPosition.setItemCaptionPropertyId((Object)"title");
        this.m_fieldPosition.setValue(beanList.get(beanList.size() - 1));
        if (this.m_site == null) {
            this.m_fieldPosition.setValue((Object)lastEntry);
        }
    }

    private void setUpComboBoxSSL() {
        IndexedContainer container = CmsEditSiteForm.getSSLModeContainer("caption", true, null);
        this.m_simpleFieldEncryption.setContainerDataSource((Container)container);
        this.m_simpleFieldEncryption.setItemCaptionPropertyId((Object)"caption");
        this.m_simpleFieldEncryption.setNullSelectionAllowed(false);
        this.m_simpleFieldEncryption.setNewItemsAllowed(false);
        this.m_simpleFieldEncryption.select((Object)CmsSSLMode.getDefault());
        this.m_simpleFieldEncryption.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 3267990233897064320L;

            public void valueChange(Property.ValueChangeEvent event) {
                if (CmsEditSiteForm.this.m_blockChange) {
                    return;
                }
                CmsEditSiteForm.this.handleSSLChange();
            }
        });
        this.m_fieldSecureServer.setVisible(CmsSSLMode.getDefault().equals((Object)CmsSSLMode.SECURE_SERVER));
        this.m_fieldExclusiveError.setVisible(CmsSSLMode.getDefault().equals((Object)CmsSSLMode.SECURE_SERVER));
        this.m_fieldExclusiveURL.setVisible(CmsSSLMode.getDefault().equals((Object)CmsSSLMode.SECURE_SERVER));
    }

    private void setUpComboBoxTemplate() {
        try {
            I_CmsResourceType templateType = OpenCms.getResourceManager().getResourceType(CmsResourceTypeJsp.getContainerPageTemplateTypeName());
            this.m_templates = this.m_clonedCms.readResources("/system/", CmsResourceFilter.DEFAULT.addRequireType(templateType));
            for (CmsResource res : this.m_templates) {
                this.m_simpleFieldTemplate.addItem((Object)res.getRootPath());
            }
            if (!this.m_templates.isEmpty()) {
                this.m_simpleFieldTemplate.setValue((Object)this.m_templates.get(0).getRootPath());
            }
            this.m_simpleFieldTemplate.setNewItemsAllowed(true);
            this.m_simpleFieldTemplate.setNullSelectionAllowed(true);
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    class TitleValidator
    implements Validator {
        private static final long serialVersionUID = 7878441125879949490L;

        TitleValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)value)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_TITLE_EMPTY_0", new Object[0]));
            }
        }
    }

    class SiteTemplateValidator
    implements Validator {
        private static final long serialVersionUID = -8730991818750657154L;

        SiteTemplateValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            String rootPath;
            String pathToCheck = (String)value;
            if (pathToCheck == null) {
                return;
            }
            if (pathToCheck.isEmpty()) {
                return;
            }
            if (!CmsEditSiteForm.this.getParentFolder().isEmpty() & !CmsEditSiteForm.this.getFieldFolder().isEmpty() && CmsEditSiteForm.this.m_clonedCms.existsResource(rootPath = "/" + CmsEditSiteForm.this.ensureFoldername(CmsEditSiteForm.this.getParentFolder()) + CmsEditSiteForm.this.ensureFoldername(CmsEditSiteForm.this.getFieldFolder()))) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_SITETEMPLATE_OVERWRITE_0", new Object[0]));
            }
            try {
                CmsEditSiteForm.this.m_clonedCms.readResource(pathToCheck + ".content");
            }
            catch (CmsException e) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_SITETEMPLATE_INVALID_0", new Object[0]));
            }
        }
    }

    class SiteRootValidator
    implements Validator {
        private static final long serialVersionUID = 7499390905843603642L;

        SiteRootValidator() {
        }

        @Deprecated
        public void validate(Object value) throws Validator.InvalidValueException {
            CmsProject currentProject;
            block3: {
                CmsSite parentSite = CmsEditSiteForm.this.m_manager.getElement(CmsFileUtil.removeTrailingSeparator((String)value));
                if (parentSite != null && !parentSite.equals(CmsEditSiteForm.this.m_site)) {
                    throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_FOLDERNAME_ALREADYUSED_1", CmsFileUtil.removeTrailingSeparator((String)value)));
                }
                currentProject = CmsEditSiteForm.this.m_clonedCms.getRequestContext().getCurrentProject();
                try {
                    CmsEditSiteForm.this.m_clonedCms.getRequestContext().setCurrentProject(CmsEditSiteForm.this.m_clonedCms.readProject(CmsProject.ONLINE_PROJECT_ID));
                    CmsEditSiteForm.this.m_clonedCms.readResource((String)value);
                }
                catch (CmsException e) {
                    CmsEditSiteForm.this.m_clonedCms.getRequestContext().setCurrentProject(currentProject);
                    if (CmsEditSiteForm.this.m_clonedCms.existsResource((String)value)) break block3;
                    throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_SITEROOT_WRONG_0", new Object[0]));
                }
            }
            CmsEditSiteForm.this.m_clonedCms.getRequestContext().setCurrentProject(currentProject);
        }
    }

    class ServerValidator
    implements Validator {
        private static final long serialVersionUID = 9014118214418269697L;

        ServerValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            String enteredServer = (String)value;
            if (enteredServer.isEmpty()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_SERVER_EMPTY_0", new Object[0]));
            }
            if (CmsEditSiteForm.this.m_alreadyUsedURL.contains(new CmsSiteMatcher(enteredServer))) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_SERVER_ALREADYUSED_1", enteredServer));
            }
        }
    }

    class SelectParentOUValidator
    implements Validator {
        private static final long serialVersionUID = -911831798529729185L;

        SelectParentOUValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            String parentOU = (String)value;
            if (parentOU.equals("/")) {
                return;
            }
            if (CmsEditSiteForm.this.getParentFolder().isEmpty() | CmsEditSiteForm.this.getFieldFolder().isEmpty()) {
                return;
            }
            String rootPath = "/" + CmsEditSiteForm.this.ensureFoldername(CmsEditSiteForm.this.getParentFolder()) + CmsEditSiteForm.this.ensureFoldername(CmsEditSiteForm.this.getFieldFolder());
            boolean ok = false;
            try {
                List<CmsResource> res = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(CmsEditSiteForm.this.m_clonedCms, parentOU);
                for (CmsResource resource : res) {
                    if (!rootPath.startsWith(resource.getRootPath())) continue;
                    ok = true;
                }
            }
            catch (CmsException e) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_PARENTOU_INVALID_0", new Object[0]));
            }
            if (!ok) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_PARENTOU_INVALID_0", new Object[0]));
            }
        }
    }

    class SelectOUValidator
    implements Validator {
        private static final long serialVersionUID = -911831798529729185L;

        SelectOUValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            String OU = (String)value;
            if (OU.equals("/")) {
                return;
            }
            if (OU.split("/").length < 2) {
                return;
            }
            OU = OU.split("/")[0] + "/";
            if (CmsEditSiteForm.this.getParentFolder().isEmpty() | CmsEditSiteForm.this.getFieldFolder().isEmpty()) {
                return;
            }
            String rootPath = "/" + CmsEditSiteForm.this.ensureFoldername(CmsEditSiteForm.this.getParentFolder()) + CmsEditSiteForm.this.ensureFoldername(CmsEditSiteForm.this.getFieldFolder());
            boolean ok = false;
            try {
                List<CmsResource> res = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(CmsEditSiteForm.this.m_clonedCms, OU);
                for (CmsResource resource : res) {
                    if (!rootPath.startsWith(resource.getRootPath())) continue;
                    ok = true;
                }
            }
            catch (CmsException e) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_OU_INVALID_0", new Object[0]));
            }
            if (!ok) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_OU_INVALID_0", new Object[0]));
            }
        }
    }

    class ParentFolderValidator
    implements Validator {
        private static final long serialVersionUID = 5217828150841769662L;

        ParentFolderValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            try {
                CmsEditSiteForm.this.m_clonedCms.getRequestContext().setSiteRoot("");
                CmsEditSiteForm.this.m_clonedCms.readResource(CmsEditSiteForm.this.getParentFolder());
            }
            catch (CmsException e) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_PARENTFOLDER_NOT_EXIST_0", new Object[0]));
            }
            if (OpenCms.getSiteManager().getSiteForRootPath(CmsFileUtil.removeTrailingSeparator(CmsEditSiteForm.this.getParentFolder())) != null) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_FOLDERNAME_ALREADYUSED_1", CmsFileUtil.removeTrailingSeparator(CmsEditSiteForm.this.getParentFolder())));
            }
            if (!CmsEditSiteForm.this.getParentFolder().startsWith("/sites/")) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_FOLDERNAME_WRONGPARENT_0", new Object[0]));
            }
            if (!CmsEditSiteForm.this.getSiteTemplatePath().isEmpty() && CmsEditSiteForm.this.ensureFoldername(CmsEditSiteForm.this.getParentFolder()).equals(CmsEditSiteForm.this.ensureFoldername(CmsEditSiteForm.this.getSiteTemplatePath()))) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_FOLDERNAME_EQUAL_SITETEMPLATE_0", new Object[0]));
            }
        }
    }

    class FolderPathValidator
    implements Validator {
        private static final long serialVersionUID = 2269520781911597613L;

        FolderPathValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            String enteredName = (String)value;
            if (FORBIDDEN_FOLDER_NAMES.contains(enteredName)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_FOLDERNAME_FORBIDDEN_1", enteredName));
            }
            if (OpenCms.getSiteManager().getSiteForRootPath(CmsEditSiteForm.this.getParentFolder() + enteredName) != null) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_FOLDERNAME_ALREADYUSED_1", enteredName));
            }
            try {
                CmsResource.checkResourceName(enteredName);
            }
            catch (CmsIllegalArgumentException e) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_FOLDERNAME_EMPTY_0", new Object[0]));
            }
        }
    }

    class FavIconReceiver
    implements Upload.Receiver,
    Upload.SucceededListener {
        private static final long serialVersionUID = 688021741970679734L;

        FavIconReceiver() {
        }

        public OutputStream receiveUpload(String filename, String mimeType) {
            CmsEditSiteForm.this.m_os.reset();
            if (!mimeType.startsWith("image")) {
                return new ByteArrayOutputStream(0);
            }
            return CmsEditSiteForm.this.m_os;
        }

        public void uploadSucceeded(Upload.SucceededEvent event) {
            if (CmsEditSiteForm.this.m_os.size() <= 1) {
                CmsEditSiteForm.this.m_imageCounter = 0;
                CmsEditSiteForm.this.m_fieldUploadFavIcon.setComponentError((ErrorMessage)new UserError(CmsVaadinUtils.getMessageText("GUI_SITE_FAVICON_MIME_0", new Object[0])));
                CmsEditSiteForm.this.setFaviconIfExist();
                return;
            }
            if (CmsEditSiteForm.this.m_os.size() > 4096) {
                CmsEditSiteForm.this.m_fieldUploadFavIcon.setComponentError((ErrorMessage)new UserError(CmsVaadinUtils.getMessageText("GUI_SITE_FAVICON_SIZE_0", new Object[0])));
                CmsEditSiteForm.this.m_imageCounter = 0;
                CmsEditSiteForm.this.setFaviconIfExist();
                return;
            }
            ++CmsEditSiteForm.this.m_imageCounter;
            CmsEditSiteForm.this.setCurrentFavIcon(CmsEditSiteForm.this.m_os.toByteArray());
        }
    }

    class AliasValidator
    implements Validator {
        private static final long serialVersionUID = 9014118214418269697L;

        AliasValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            String enteredServer = (String)value;
            if (enteredServer == null) {
                return;
            }
            if (enteredServer.isEmpty()) {
                return;
            }
            if (CmsEditSiteForm.this.m_alreadyUsedURL.contains(new CmsSiteMatcher(enteredServer)) && !OpenCms.getSiteManager().getSites().get(new CmsSiteMatcher(enteredServer)).equals(CmsEditSiteForm.this.m_site)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_SERVER_ALREADYUSED_1", enteredServer));
            }
            if (new CmsSiteMatcher(enteredServer).equals(new CmsSiteMatcher(CmsEditSiteForm.this.getFieldServer()))) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_SERVER_EQUAL_ALIAS_0", new Object[0]));
            }
            if (CmsEditSiteForm.this.isDoubleAlias(enteredServer)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_SITE_SERVER_ALREADYUSED_1", enteredServer));
            }
        }
    }

    public class PositionComboBoxElementBean {
        private float m_position;
        private String m_title;

        public PositionComboBoxElementBean(String title, float position) {
            this.m_position = position;
            this.m_title = title;
        }

        public float getPosition() {
            return this.m_position;
        }

        public String getTitle() {
            return this.m_title;
        }
    }
}

