/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sitemanager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.letsencrypt.CmsLetsEncryptConfiguration;
import org.opencms.letsencrypt.CmsSiteConfigToLetsEncryptConfigConverter;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.sitemanager.CmsSiteManager;
import org.opencms.util.CmsStringUtil;

public class CmsSitesWebserverThread
extends A_CmsReportThread {
    static Log LOG = CmsLog.getLog(CmsSitesWebserverThread.class.getName());
    private static final int PORT_HTTP = 80;
    private static final int PORT_HTTPS = 443;
    private String m_filePrefix;
    private String m_loggingDir;
    private String m_scriptPath;
    private String m_secureTemplate;
    private String m_targetPath;
    private String m_templatePath;
    private List<String> m_writtenFiles = new ArrayList<String>();

    public CmsSitesWebserverThread(CmsObject cms, String targetPath, String templatePath, String scriptPath, String filePrefix, String loggingDir, String secureTemplate) {
        super(cms, "write-to-webserver");
        if (targetPath != null) {
            this.m_targetPath = targetPath.endsWith(File.separator) ? targetPath : targetPath + File.separator;
        }
        this.m_templatePath = templatePath;
        this.m_scriptPath = scriptPath;
        this.m_filePrefix = filePrefix;
        this.m_loggingDir = loggingDir;
        this.m_secureTemplate = secureTemplate;
        this.initHtmlReport(cms.getRequestContext().getLocale());
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        LOG.info((Object)("INFO thread for run of server script started by User: " + this.getCms().getRequestContext().getCurrentUser().getName()));
        if (CmsSiteManager.isLetsEncryptConfiguredForWebserverThread()) {
            this.updateLetsEncrypt();
        } else {
            try {
                this.deleteAllWebserverConfigs(this.m_filePrefix);
                this.createAllWebserverConfigs();
                this.executeScript();
                LOG.info((Object)"INFO server script finished successfully");
            }
            catch (Exception e) {
                LOG.error((Object)"Exception on run CmsSitesWebserverThread", (Throwable)e);
                this.getReport().println(e);
            }
            LOG.info((Object)"INFO server script thread closed");
        }
    }

    private void createAllWebserverConfigs() throws IOException {
        List<CmsSite> sites = OpenCms.getSiteManager().getAvailableSites(this.getCms(), true);
        for (CmsSite site : sites) {
            if (site.getSiteMatcher() == null || !site.isWebserver()) continue;
            String filename = this.m_targetPath + this.m_filePrefix + "_" + this.generateWebserverConfigName(site.getSiteMatcher(), "_");
            this.getReport().println(Messages.get().container("RPT_CREATING_CONFIG_FOR_SITE_2", filename, site), 4);
            File newFile = new File(filename);
            if (!newFile.exists()) {
                newFile.getParentFile().mkdirs();
                newFile.createNewFile();
            }
            String content = this.createConfigForSite(site, FileUtils.readFileToString((File)new File(this.m_templatePath)));
            if (site.hasSecureServer()) {
                content = content + this.createConfigForSite(site, FileUtils.readFileToString((File)new File(this.m_secureTemplate)));
            }
            FileUtils.writeStringToFile((File)newFile, (String)content);
            this.m_writtenFiles.add(newFile.getAbsolutePath());
        }
    }

    private String createConfigForSite(CmsSite site, String templateContent) {
        StringTemplate config = new StringTemplate(templateContent);
        String webappPath = OpenCms.getSystemInfo().getWebApplicationRfsPath();
        config.setAttribute("DOCUMENT_ROOT", (Object)webappPath.substring(0, webappPath.length() - 1));
        config.setAttribute("WEBAPP_NAME", (Object)OpenCms.getSystemInfo().getWebApplicationName());
        config.setAttribute("CONTEXT_PATH", (Object)OpenCms.getSystemInfo().getContextPath());
        config.setAttribute("SERVLET_PATH", (Object)OpenCms.getSystemInfo().getServletPath());
        config.setAttribute("DEFAULT_ENCODING", (Object)OpenCms.getSystemInfo().getDefaultEncoding());
        config.setAttribute("CONFIG_FILENAME", (Object)this.generateWebserverConfigName(site.getSiteMatcher(), "_"));
        config.setAttribute("LOGGING_DIRECTORY", (Object)this.m_loggingDir);
        config.setAttribute("SERVER_URL", (Object)site.getUrl());
        config.setAttribute("SERVER_PROTOCOL", (Object)site.getSiteMatcher().getServerProtocol());
        config.setAttribute("SERVER_NAME", (Object)site.getSiteMatcher().getServerName());
        config.setAttribute("SERVER_PORT", site.getSiteMatcher().getServerPort());
        config.setAttribute("SERVER_NAME_WITH_PORT", (Object)this.generateWebserverConfigName(site.getSiteMatcher(), ":"));
        config.setAttribute("SITE_TITLE", (Object)site.getTitle());
        if (site.getErrorPage() != null) {
            config.setAttribute("ERROR_PAGE", (Object)site.getErrorPage());
        }
        if (site.getAliases() != null && !site.getAliases().isEmpty()) {
            config.setAttribute("ALIAS_DIRECTIVE", (Object)"ServerAlias");
            for (CmsSiteMatcher alias : site.getAliases()) {
                config.setAttribute("SERVER_ALIASES", (Object)(this.generateWebserverConfigName(alias, ":") + " "));
            }
        }
        if (site.hasSecureServer()) {
            if (site.getSecureUrl() != null) {
                config.setAttribute("SECURE_URL", (Object)site.getSecureUrl());
            }
            if (site.getSecureServer() != null) {
                config.setAttribute("SECURE_SRV_WITH_PORT", (Object)this.generateWebserverConfigName(site.getSecureServer(), ":"));
                config.setAttribute("SECURE_SERVER_NAME", (Object)site.getSecureServer().getServerName());
                config.setAttribute("SECURE_SERVER_PORT", site.getSecureServer().getServerPort());
                config.setAttribute("SECURE_SERVER_PROTOCOL", (Object)site.getSecureServer().getServerProtocol());
            }
        }
        return config.toString();
    }

    private void deleteAllWebserverConfigs(final String prefix) {
        File file = new File(this.m_targetPath);
        if (file.exists() && file.isDirectory()) {
            File[] configFiles;
            for (File f : configFiles = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            })) {
                this.getReport().println(Messages.get().container("RPT_DELETING_FILE_1", f), 4);
                f.delete();
            }
        }
    }

    private void executeScript() throws IOException, InterruptedException {
        File script = new File(this.m_scriptPath);
        LinkedList<String> params = new LinkedList<String>();
        params.add(script.getAbsolutePath());
        params.addAll(this.m_writtenFiles);
        ProcessBuilder pb = new ProcessBuilder(params.toArray(new String[params.size()]));
        pb.directory(new File(script.getParent()));
        Process pr = pb.start();
        pr.waitFor();
        BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        while (buf.ready()) {
            String line = buf.readLine();
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(line)) continue;
            this.getReport().println(Messages.get().container("RPT_OUTPUT_WEBSERVER_1", buf.readLine()), 4);
        }
    }

    private String generateWebserverConfigName(CmsSiteMatcher macther, String separator) {
        int port = macther.getServerPort();
        String serverName = macther.getServerName();
        String portPart = port != 80 && port != 443 ? separator + port : "";
        return serverName + portPart;
    }

    private void updateLetsEncrypt() {
        this.getReport().println(Messages.get().container("RPT_STARTING_LETSENCRYPT_UPDATE_0"));
        CmsLetsEncryptConfiguration config = OpenCms.getLetsEncryptConfig();
        if (config == null || !config.isValidAndEnabled()) {
            return;
        }
        CmsSiteConfigToLetsEncryptConfigConverter converter = new CmsSiteConfigToLetsEncryptConfigConverter(config);
        boolean ok = converter.run(this.getReport(), OpenCms.getSiteManager());
        if (ok) {
            this.getReport().println(Messages.get().container("RPT_LETSENCRYPT_FINISHED_0"), 4);
        }
    }
}

