/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sitemanager;

import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.BeanItemContainer;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import java.util.ArrayList;
import java.util.List;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSSLMode;
import org.opencms.site.CmsSite;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.sitemanager.CmsEditSiteForm;

public class CmsWorkplaceServerWidget
extends FormLayout {
    private static final long serialVersionUID = -2972167045879745058L;
    private ComboBox m_encryption;
    private ComboBox m_server;
    BeanItemContainer<CmsSite> m_serverContainer;
    protected boolean m_do_not_change = false;

    public CmsWorkplaceServerWidget(List<CmsSite> sites, String server) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        CmsSSLMode sslMode = OpenCms.getSiteManager().getSSLModeForWorkplaceServer(server);
        this.m_encryption.setContainerDataSource((Container)CmsEditSiteForm.getSSLModeContainer("caption", false, sslMode));
        this.m_encryption.setItemCaptionPropertyId((Object)"caption");
        this.m_encryption.setNullSelectionAllowed(false);
        this.m_encryption.setNewItemsAllowed(false);
        this.m_encryption.select((Object)CmsSSLMode.NO);
        this.m_serverContainer = CmsWorkplaceServerWidget.setUpWorkplaceComboBox(sites, this.m_server, false, server, sslMode);
        this.m_encryption.select((Object)sslMode);
        this.m_encryption.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -2628646995757479728L;

            public void valueChange(Property.ValueChangeEvent event) {
                if (CmsWorkplaceServerWidget.this.m_do_not_change) {
                    return;
                }
                CmsWorkplaceServerWidget.this.m_do_not_change = true;
                CmsWorkplaceServerWidget.this.adjustServerPrefix();
                CmsWorkplaceServerWidget.this.m_do_not_change = false;
            }
        });
        this.m_server.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 6670411745575147230L;

            public void valueChange(Property.ValueChangeEvent event) {
                if (CmsWorkplaceServerWidget.this.m_do_not_change) {
                    return;
                }
                CmsWorkplaceServerWidget.this.m_do_not_change = true;
                CmsWorkplaceServerWidget.this.adjustSSL();
                CmsWorkplaceServerWidget.this.m_do_not_change = false;
            }
        });
        this.adjustSSL();
    }

    private static BeanItemContainer<CmsSite> setUpWorkplaceComboBox(List<CmsSite> allSites, final ComboBox combo, boolean nullselect, String defaultValue, CmsSSLMode sslMode) {
        ArrayList<CmsSite> modSites = new ArrayList<CmsSite>();
        CmsSite siteWithDefaultURL = null;
        String defaultURL = defaultValue;
        for (CmsSite site : allSites) {
            CmsSite si = new CmsSite("dummy", site.getUrl());
            si.setSSLMode(site.getSSLMode());
            modSites.add(si);
            if (defaultValue == null || !defaultURL.equals(si.getUrl())) continue;
            siteWithDefaultURL = si;
        }
        if (defaultValue != null && siteWithDefaultURL == null) {
            siteWithDefaultURL = new CmsSite("dummy", defaultURL);
            siteWithDefaultURL.setSSLMode(sslMode);
            modSites.add(0, siteWithDefaultURL);
        }
        final BeanItemContainer objects = new BeanItemContainer(CmsSite.class, modSites);
        combo.setContainerDataSource((Container)objects);
        combo.setNullSelectionAllowed(nullselect);
        combo.setItemCaptionPropertyId((Object)"url");
        combo.setValue((Object)siteWithDefaultURL);
        combo.setNewItemsAllowed(true);
        combo.setImmediate(true);
        combo.setNewItemHandler(new AbstractSelect.NewItemHandler(){
            private static final long serialVersionUID = -4760590374697520609L;

            public void addNewItem(String newItemCaption) {
                CmsSite newItem = new CmsSite("dummy", newItemCaption);
                newItem.setSSLMode(newItemCaption.contains("https:") ? CmsSSLMode.MANUAL : CmsSSLMode.NO);
                objects.addBean((Object)newItem);
                combo.select((Object)newItem);
            }
        });
        return objects;
    }

    public String getServer() {
        if (this.m_server.getValue() == null) {
            return "";
        }
        return ((CmsSite)this.m_server.getValue()).getUrl();
    }

    public CmsSSLMode getSSLMode() {
        return (CmsSSLMode)((Object)this.m_encryption.getValue());
    }

    protected void adjustServerPrefix() {
        CmsSSLMode mode = (CmsSSLMode)((Object)this.m_encryption.getValue());
        if (this.simpleReturn(mode)) {
            return;
        }
        String toBeReplaced = "http:";
        String newString = "https:";
        if (mode.equals((Object)CmsSSLMode.NO) | mode.equals((Object)CmsSSLMode.SECURE_SERVER)) {
            toBeReplaced = "https:";
            newString = "http:";
        }
        if (((CmsSite)this.m_server.getValue()).getUrl().contains(toBeReplaced)) {
            String newURL = ((CmsSite)this.m_server.getValue()).getUrl().replaceAll(toBeReplaced, newString);
            CmsSite newSite = new CmsSite("dummy", newURL);
            if (!this.m_serverContainer.containsId((Object)newSite)) {
                this.m_serverContainer.addItem((Object)newSite);
            }
            this.m_server.select((Object)newSite);
        }
    }

    protected void adjustSSL() {
        if (this.simpleReturn(null)) {
            return;
        }
        CmsSSLMode siteMode = ((CmsSite)this.m_server.getValue()).getSSLMode();
        this.m_encryption.setValue((Object)(siteMode.equals((Object)CmsSSLMode.SECURE_SERVER) ? CmsSSLMode.NO : siteMode));
    }

    private boolean simpleReturn(CmsSSLMode mode) {
        if (this.m_server.getValue() == null) {
            return true;
        }
        return mode != null && (mode.equals((Object)CmsSSLMode.NO) ? ((CmsSite)this.m_server.getValue()).getUrl().contains("http:") : ((CmsSite)this.m_server.getValue()).getUrl().contains("https:"));
    }
}

