/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.components.CmsBasicDialog;

public class CmsDeleteOUDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = -7191571070148172989L;
    private static final Log LOG = CmsLog.getLog(CmsDeleteOUDialog.class);
    private Label m_label;
    private Label m_icon;
    private Button m_cancelButton;
    private Button m_okButton;
    private FormLayout m_principalSelectLayout;
    private CmsObject m_cms;
    private String m_ouName;
    private Panel m_dependencyPanel;

    public CmsDeleteOUDialog(CmsObject cms, String ouName, Window window, CmsAccountsApp app) {
        this.m_ouName = ouName;
        this.init(cms, window, app);
        this.m_dependencyPanel.setVisible(false);
        this.m_principalSelectLayout.setVisible(false);
        try {
            List<CmsUser> userList = OpenCms.getOrgUnitManager().getUsers(this.m_cms, ouName, true);
            List<CmsOrganizationalUnit> oUs = OpenCms.getOrgUnitManager().getOrganizationalUnits(this.m_cms, ouName, true);
            if (userList.isEmpty() && oUs.isEmpty()) {
                this.m_label.setValue(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_DELETE_OU_CONFIRM_1", ouName));
            } else {
                this.m_label.setValue(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_DELETE_OU_NOT_POSSIBLE_1", ouName));
                this.m_okButton.setEnabled(false);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read OU", (Throwable)e);
        }
    }

    void deletePrincipal() {
        try {
            OpenCms.getOrgUnitManager().deleteOrganizationalUnit(this.m_cms, this.m_ouName);
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to delete OU");
        }
    }

    private void init(CmsObject cms, final Window window, final CmsAccountsApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        try {
            this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getOUInfo(OpenCms.getOrgUnitManager().readOrganizationalUnit(A_CmsUI.getCmsObject(), this.m_ouName))));
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read OU", (Throwable)e);
        }
        this.m_icon.setContentMode(ContentMode.HTML);
        this.m_icon.setValue(FontOpenCms.WARNING.getHtml());
        this.m_cms = cms;
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -7845894751587879028L;

            public void buttonClick(Button.ClickEvent event) {
                CmsDeleteOUDialog.this.deletePrincipal();
                window.close();
                app.reload();
            }
        });
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 6649262870116199591L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
    }
}

