/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsDeleteMultiplePrincipalDialog;
import org.opencms.ui.apps.user.CmsGroupEditDialog;
import org.opencms.ui.apps.user.CmsImportExportUserDialog;
import org.opencms.ui.apps.user.CmsOuTreeType;
import org.opencms.ui.apps.user.CmsShowResourcesDialog;
import org.opencms.ui.apps.user.I_CmsFilterableTable;
import org.opencms.ui.apps.user.I_CmsOuTreeType;
import org.opencms.ui.apps.user.I_CmsToggleTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsGroupTable
extends Table
implements I_CmsFilterableTable,
I_CmsToggleTable {
    private static final Log LOG = CmsLog.getLog(CmsGroupTable.class);
    private static final long serialVersionUID = -6511159488669996003L;
    protected CmsAccountsApp m_app;
    protected String m_ou;
    CmsObject m_cms;
    List<CmsGroup> m_groups;
    List<CmsGroup> m_indirects;
    CmsContextMenu m_menu;
    private IndexedContainer m_container;
    private VerticalLayout m_emptyLayout;
    private boolean m_fullLoaded;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;
    private I_CmsOuTreeType m_type;

    public CmsGroupTable(String ou, CmsAccountsApp app, I_CmsOuTreeType type, boolean showAll) {
        this.m_app = app;
        this.m_ou = ou;
        this.m_type = type;
        this.m_indirects = new ArrayList<CmsGroup>();
        try {
            this.m_cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            this.m_cms.getRequestContext().setSiteRoot("");
        }
        catch (CmsException e) {
            this.m_cms = A_CmsUI.getCmsObject();
        }
        try {
            List<CmsGroup> directs = this.m_app.readGroupsForOu(this.m_cms, ou, this.m_type, false);
            this.m_fullLoaded = false;
            if (showAll) {
                this.setAllGroups(directs);
            } else {
                this.m_groups = directs;
            }
        }
        catch (CmsException e) {
            e.printStackTrace();
        }
        this.init(ou);
    }

    public void fillGroupItem(Item item, CmsGroup group, List<CmsGroup> indirects) {
        item.getItemProperty((Object)TableProperty.Name).setValue((Object)group.getName());
        item.getItemProperty((Object)TableProperty.Description).setValue((Object)group.getDescription(A_CmsUI.get().getLocale()));
        item.getItemProperty((Object)TableProperty.OU).setValue((Object)group.getOuFqn());
        if (indirects.contains(group)) {
            item.getItemProperty((Object)TableProperty.INDIRECT).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void filter(String data) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(data)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)TableProperty.Name, data, true, false), new SimpleStringFilter((Object)TableProperty.Description, data, true, false)}));
        }
    }

    @Override
    public int getCurrentSize() {
        return this.size();
    }

    @Override
    public VerticalLayout getEmptyLayout() {
        this.m_emptyLayout = CmsVaadinUtils.getInfoLayout(CmsOuTreeType.GROUP.getEmptyMessageKey());
        this.setVisible(this.size() > 0);
        this.m_emptyLayout.setVisible(this.size() == 0);
        return this.m_emptyLayout;
    }

    @Override
    public void toggle(boolean pressed) {
        try {
            if (pressed && !this.m_fullLoaded) {
                this.setAllGroups(this.m_groups);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Error loading groups", (Throwable)e);
        }
        this.fillContainer(pressed);
    }

    protected boolean canDelete(Set<String> groupIds) {
        return true;
    }

    protected boolean canImportData(Set<String> groupIds) {
        return groupIds.size() == 1;
    }

    protected void fillContainer(boolean showIndirect) {
        Item item;
        this.m_container.removeAllContainerFilters();
        this.m_container.removeAllItems();
        for (CmsGroup group : this.m_groups) {
            if (this.m_indirects.contains(group)) continue;
            item = this.m_container.addItem((Object)group);
            this.m_app.fillGroupItem(item, group, this.m_indirects);
        }
        if (showIndirect) {
            for (CmsGroup group : this.m_indirects) {
                item = this.m_container.addItem((Object)group);
                this.m_app.fillGroupItem(item, group, this.m_indirects);
            }
        }
    }

    protected void init(String ou) {
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.m_container = new IndexedContainer();
        for (TableProperty prop : TableProperty.values()) {
            this.m_container.addContainerProperty((Object)prop, prop.getType(), prop.getDefault());
            this.setColumnHeader((Object)prop, prop.getName());
        }
        this.m_app.addGroupContainerProperties(this.m_container);
        this.setContainerDataSource((Container)this.m_container);
        this.setItemIconPropertyId((Object)TableProperty.Icon);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnWidth(null, 40);
        this.setSelectable(true);
        this.setMultiSelect(true);
        for (CmsGroup group : this.m_groups) {
            Item item = this.m_container.addItem((Object)group);
            this.m_app.fillGroupItem(item, group, this.m_indirects);
        }
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 4807195510202231174L;

            public void itemClick(ItemClickEvent event) {
                CmsGroupTable.this.changeValueIfNotMultiSelect(event.getItemId());
                if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || event.getPropertyId() == null) {
                    HashSet<String> groupIds = new HashSet<String>();
                    for (CmsGroup group : (Set)CmsGroupTable.this.getValue()) {
                        groupIds.add(group.getId().getStringValue());
                    }
                    CmsGroupTable.this.m_menu.setEntries(CmsGroupTable.this.getMenuEntries(), groupIds);
                    CmsGroupTable.this.m_menu.openForTable((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId(), CmsGroupTable.this);
                    return;
                }
                if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && event.getPropertyId().equals((Object)TableProperty.Name)) {
                    CmsGroupTable.this.updateApp(((CmsGroup)((Set)CmsGroupTable.this.getValue()).iterator().next()).getId().getStringValue());
                }
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                String css = "";
                if (((Boolean)source.getItem(itemId).getItemProperty((Object)TableProperty.INDIRECT).getValue()).booleanValue()) {
                    css = css + " o-table-cell-disabled o-expired";
                }
                if (TableProperty.Name.equals(propertyId)) {
                    css = css + " o-hover-column";
                }
                return css;
            }
        });
        this.setVisibleColumns(new Object[]{TableProperty.Name, TableProperty.Description, TableProperty.OU});
    }

    protected void updateApp(String uuid) {
        try {
            CmsGroup group = this.m_cms.readGroup(new CmsUUID(uuid));
            this.m_app.update(group.getOuFqn(), this.m_type, group.getId(), "");
        }
        catch (CmsException e) {
            LOG.error((Object)"unable to read group.", (Throwable)e);
        }
    }

    void changeValueIfNotMultiSelect(Object itemId) {
        Set value = (Set)this.getValue();
        if (value == null) {
            this.select(itemId);
        } else if (!value.contains(itemId)) {
            this.setValue(null);
            this.select(itemId);
        }
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EntryOpen());
            this.m_menuEntries.add(new EntryEdit());
            this.m_menuEntries.add(new EntryShowResources());
            this.m_menuEntries.add(new ImExport());
            this.m_menuEntries.add(new EntryDelete());
        }
        return this.m_menuEntries;
    }

    private void setAllGroups(List<CmsGroup> directs) throws CmsException {
        this.m_fullLoaded = true;
        this.m_groups = this.m_app.readGroupsForOu(this.m_cms, this.m_ou, this.m_type, true);
        this.m_indirects.clear();
        for (CmsGroup group : this.m_groups) {
            if (directs.contains(group)) continue;
            this.m_indirects.add(group);
        }
    }

    class ImExport
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        ImExport() {
        }

        @Override
        public void executeAction(Set<String> context) {
            boolean includeTechnicalFields = false;
            try {
                OpenCms.getRoleManager().checkRole(CmsGroupTable.this.m_cms, CmsRole.ADMINISTRATOR);
                includeTechnicalFields = true;
            }
            catch (CmsRoleViolationException cmsRoleViolationException) {
                // empty catch block
            }
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_DIALOGNAME_0", new Object[0]));
            window.setContent((Component)CmsImportExportUserDialog.getExportUserDialogForGroup(new CmsUUID(context.iterator().next()), CmsGroupTable.this.m_ou, window, includeTechnicalFields));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_IMEXPORT_CONTEXTMENUNAME_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            return CmsMenuItemVisibilityMode.activeInactive(CmsGroupTable.this.canImportData(context));
        }
    }

    class EntryShowResources
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryShowResources() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_SHOW_RESOURCES_0", new Object[0]));
            window.setContent((Component)new CmsShowResourcesDialog(context.iterator().next(), window));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_SHOW_RESOURCES_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class EntryOpen
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EntryOpen() {
        }

        @Override
        public void executeAction(Set<String> context) {
            CmsGroupTable.this.updateApp(context.iterator().next());
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_OPEN_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            if (CmsGroupTable.this.m_app != null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
    }

    class EntryEdit
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryEdit() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow();
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_GROUP_0", new Object[0]));
            window.setContent((Component)new CmsGroupEditDialog(CmsGroupTable.this.m_cms, new CmsUUID(context.iterator().next()), window, CmsGroupTable.this.m_app));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_GROUP_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            if (context.size() > 1) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
            }
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }

    class EntryDelete
    implements I_CmsSimpleContextMenuEntry<Set<String>> {
        EntryDelete() {
        }

        @Override
        public void executeAction(Set<String> context) {
            Window window = CmsBasicDialog.prepareWindow();
            CmsDeleteMultiplePrincipalDialog dialog = new CmsDeleteMultiplePrincipalDialog(CmsGroupTable.this.m_cms, context, window, CmsGroupTable.this.m_app);
            window.setContent((Component)dialog);
            window.setCaption(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GROUP_DELETE_0", new Object[0]));
            A_CmsUI.get().addWindow(window);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GROUP_DELETE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            boolean ok = CmsGroupTable.this.canDelete(context);
            return ok ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
        }
    }

    public static enum TableProperty {
        Description(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GROUP_DESCRIPTION_0", new Object[0]), String.class, ""),
        Icon(null, Resource.class, new CmsCssIcon("oc-icon-24-group")),
        INDIRECT("", Boolean.class, new Boolean(false)),
        Name(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GROUP_NAME_0", new Object[0]), String.class, ""),
        OU(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_GROUP_OU_0", new Object[0]), String.class, "");

        private Object m_defaultValue;
        private String m_headerMessage;
        private Class<?> m_type;

        private TableProperty(String name, Class<?> type, Object defaultValue) {
            this.m_headerMessage = name;
            this.m_type = type;
            this.m_defaultValue = defaultValue;
        }

        Object getDefault() {
            return this.m_defaultValue;
        }

        String getName() {
            return this.m_headerMessage;
        }

        Class<?> getType() {
            return this.m_type;
        }
    }
}

