/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsGroupTable;

public class CmsGroupsOfUserTable
extends Table {
    private static final long serialVersionUID = 1L;
    private CmsAccountsApp m_app;
    private IndexedContainer m_container;

    public void init(CmsAccountsApp app, CmsObject cms, CmsUser user, List<CmsGroup> groups) {
        this.m_app = app;
        if (this.m_container == null) {
            this.m_container = new IndexedContainer();
            for (CmsGroupTable.TableProperty prop : CmsGroupTable.TableProperty.values()) {
                this.m_container.addContainerProperty((Object)prop, prop.getType(), prop.getDefault());
                this.setColumnHeader((Object)prop, prop.getName());
            }
            this.m_app.addGroupContainerProperties(this.m_container);
            this.setContainerDataSource((Container)this.m_container);
            this.setItemIconPropertyId((Object)CmsGroupTable.TableProperty.Icon);
            this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
            this.setColumnWidth(null, 40);
            this.setSelectable(false);
            this.setMultiSelect(false);
            this.setVisibleColumns(new Object[]{CmsGroupTable.TableProperty.Name, CmsGroupTable.TableProperty.OU});
        }
        this.m_container.removeAllItems();
        for (CmsGroup group : groups) {
            Item item = this.m_container.addItem((Object)group);
            this.m_app.fillGroupItem(item, group, new ArrayList<CmsGroup>());
        }
    }
}

