/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.google.common.base.Supplier;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextArea;
import com.vaadin.v7.ui.TextField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsDefaultValidationHandler;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.editablegroup.CmsEditableGroup;
import org.opencms.ui.components.editablegroup.I_CmsEditableGroupRow;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.util.CmsFileUtil;

public class CmsOUEditDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = -1462196157732607548L;
    static Log LOG = CmsLog.getLog(CmsOUEditDialog.class.getName());
    protected CmsObject m_cms;
    private CmsOrganizationalUnit m_ou;
    Button m_ok;
    private TextField m_name;
    private Button m_cancel;
    private TextArea m_description;
    Label m_parentOu;
    private CheckBox m_hideLogin;
    private CheckBox m_webuser;
    private FormLayout m_resLayout;
    private CmsEditableGroup m_ouResources;

    public CmsOUEditDialog(CmsObject cms, String ou, final Window window, final CmsAccountsApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        if (ou != null) {
            try {
                this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getOUInfo(OpenCms.getOrgUnitManager().readOrganizationalUnit(A_CmsUI.getCmsObject(), ou))));
            }
            catch (CmsException e1) {
                LOG.error((Object)"Unable to read OU", (Throwable)e1);
            }
        }
        this.m_cms = cms;
        Supplier<Component> fieldFactory = new Supplier<Component>(){

            public Component get() {
                CmsPathSelectField field = new CmsPathSelectField();
                field.setUseRootPaths(true);
                field.setCmsObject(CmsOUEditDialog.this.m_cms);
                try {
                    field.setValue(OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(CmsOUEditDialog.this.m_cms, CmsOUEditDialog.this.m_parentOu.getValue()).get(0).getRootPath());
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
                return field;
            }
        };
        this.m_ouResources = new CmsEditableGroup((AbstractOrderedLayout)this.m_resLayout, fieldFactory, CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_OU_ADD_RESOURCE_0", new Object[0]));
        this.m_ouResources.init();
        try {
            if (ou != null) {
                this.m_ou = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_cms, ou);
                this.m_name.setEnabled(false);
                this.m_name.setValue(this.m_ou.getName());
                this.m_description.setValue(this.m_ou.getDescription());
                this.m_parentOu.setValue(this.m_ou.getParentFqn().equals("") ? "/" : this.m_ou.getParentFqn());
                this.m_hideLogin.setValue((Object)new Boolean(this.m_ou.hasFlagHideLogin()));
                this.m_webuser.setValue((Object)new Boolean(this.m_ou.hasFlagWebuser()));
                this.m_webuser.setEnabled(false);
                for (CmsResource resource : OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.m_cms, this.m_ou.getName())) {
                    CmsPathSelectField field = new CmsPathSelectField();
                    field.setValue(resource.getRootPath());
                    field.setUseRootPaths(true);
                    field.setCmsObject(this.m_cms);
                    this.m_ouResources.addRow((Component)field);
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"unable to read group", (Throwable)e);
        }
        this.m_ok.setEnabled(this.m_ou != null);
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 2337532424806798793L;

            public void buttonClick(Button.ClickEvent event) {
                CmsOUEditDialog.this.validate();
                if (CmsOUEditDialog.this.isValid()) {
                    CmsOUEditDialog.this.saveOU();
                    window.close();
                    app.reload();
                }
            }
        });
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -6389260624197980323L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
        Property.ValueChangeListener listener = new Property.ValueChangeListener(){
            private static final long serialVersionUID = -7480617292190495288L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsOUEditDialog.this.m_ok.setEnabled(true);
            }
        };
        this.m_description.addValueChangeListener(listener);
        this.m_name.addValueChangeListener(listener);
    }

    public CmsOUEditDialog(CmsObject cms, Window window, String ou, CmsAccountsApp app) {
        this(cms, null, window, app);
        this.m_parentOu.setValue(ou.equals("") ? "/" : ou);
        try {
            this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getOUInfo(OpenCms.getOrgUnitManager().readOrganizationalUnit(A_CmsUI.getCmsObject(), this.m_parentOu.getValue()))));
        }
        catch (CmsException e1) {
            LOG.error((Object)"Unable to read OU", (Throwable)e1);
        }
        CmsPathSelectField field = new CmsPathSelectField();
        field.setUseRootPaths(true);
        field.setCmsObject(this.m_cms);
        try {
            field.setValue(OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(cms, ou).get(0).getRootPath());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_ouResources.addRow((Component)field);
    }

    protected boolean isInvalidResourceName(String resourceName) {
        if (resourceName == null) {
            return true;
        }
        try {
            this.m_cms.readResource(resourceName);
            return false;
        }
        catch (CmsException cmsException) {
            return true;
        }
    }

    protected boolean isOutOfOu(String resourceName) {
        if (resourceName == null) {
            return true;
        }
        try {
            boolean notOk = true;
            for (CmsResource res : OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.m_cms, this.m_parentOu.getValue())) {
                if (!resourceName.startsWith(res.getRootPath())) continue;
                notOk = false;
            }
            return notOk;
        }
        catch (CmsException cmsException) {
            return true;
        }
    }

    protected boolean isValid() {
        boolean res = true;
        res &= this.m_description.isValid();
        if (!(res &= this.m_name.isValid())) {
            return res;
        }
        for (I_CmsEditableGroupRow row : this.m_ouResources.getRows()) {
            if (((AbstractField)row.getComponent()).isValid()) continue;
            return false;
        }
        return true;
    }

    protected void validate() {
        if (this.m_ou == null) {
            this.m_name.removeAllValidators();
            this.m_name.addValidator((Validator)new NameValidator());
        }
        this.m_description.setRequired(true);
        this.m_description.setRequiredError("Required");
        if (this.m_ouResources.getRows().isEmpty() & (Boolean)this.m_webuser.getValue() == false) {
            CmsPathSelectField field = new CmsPathSelectField();
            field.setUseRootPaths(true);
            field.setCmsObject(this.m_cms);
            this.m_ouResources.addRow((Component)field);
        }
        for (I_CmsEditableGroupRow row : this.m_ouResources.getRows()) {
            ((AbstractField)row.getComponent()).removeAllValidators();
            ((AbstractField)row.getComponent()).addValidator((Validator)new ResourceValidator());
        }
    }

    void saveOU() {
        try {
            ArrayList<String> resources = new ArrayList<String>();
            for (I_CmsEditableGroupRow row : this.m_ouResources.getRows()) {
                resources.add(((CmsPathSelectField)row.getComponent()).getValue());
            }
            if (this.m_ou == null) {
                String parentOu = this.m_parentOu.getValue();
                if (!parentOu.endsWith("/")) {
                    parentOu = parentOu + "/";
                }
                if (resources.contains("null")) {
                    resources.remove("null");
                }
                List<String> resourceNames = CmsFileUtil.removeRedundancies(resources);
                this.m_ou = OpenCms.getOrgUnitManager().createOrganizationalUnit(this.m_cms, parentOu + (String)this.m_name.getValue(), (String)this.m_description.getValue(), this.getFlags(), resourceNames.isEmpty() ? null : resourceNames.get(0));
                if (!resourceNames.isEmpty()) {
                    resourceNames.remove(0);
                    Iterator<String> itResourceNames = CmsFileUtil.removeRedundancies(resourceNames).iterator();
                    while (itResourceNames.hasNext()) {
                        OpenCms.getOrgUnitManager().addResourceToOrgUnit(this.m_cms, this.m_ou.getName(), itResourceNames.next());
                    }
                }
            } else {
                this.m_ou.setDescription((String)this.m_description.getValue());
                this.m_ou.setFlags(this.getFlags());
                List<String> resourceNamesNew = CmsFileUtil.removeRedundancies(resources);
                List<CmsResource> resourcesOld = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.m_cms, this.m_ou.getName());
                ArrayList<String> resourceNamesOld = new ArrayList<String>();
                for (CmsResource resourceOld : resourcesOld) {
                    resourceNamesOld.add(this.m_cms.getSitePath(resourceOld));
                }
                for (String resourceNameNew : resourceNamesNew) {
                    if (resourceNamesOld.contains(resourceNameNew)) continue;
                    OpenCms.getOrgUnitManager().addResourceToOrgUnit(this.m_cms, this.m_ou.getName(), resourceNameNew);
                }
                for (String resourceNameOld : resourceNamesOld) {
                    if (resourceNamesNew.contains(resourceNameOld)) continue;
                    OpenCms.getOrgUnitManager().removeResourceFromOrgUnit(this.m_cms, this.m_ou.getName(), resourceNameOld);
                }
                OpenCms.getOrgUnitManager().writeOrganizationalUnit(this.m_cms, this.m_ou);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to save OU", (Throwable)e);
        }
    }

    private int getFlags() {
        int flags = 0;
        if (((Boolean)this.m_hideLogin.getValue()).booleanValue()) {
            ++flags;
        }
        if (((Boolean)this.m_webuser.getValue()).booleanValue()) {
            flags += 8;
        }
        return flags;
    }

    protected class ResourceValidator
    implements Validator {
        private static final long serialVersionUID = -2325058988240648143L;

        protected ResourceValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (CmsOUEditDialog.this.isInvalidResourceName((String)value)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_OU_RESOURCE_NOT_VALID_0", new Object[0]));
            }
            if (CmsOUEditDialog.this.isOutOfOu((String)value)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_OU_RESOURCE_OUT_OF_OU_0", new Object[0]));
            }
        }
    }

    protected class NameValidator
    implements Validator {
        private static final long serialVersionUID = 6830449175508751039L;

        protected NameValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            try {
                CmsDefaultValidationHandler handler = new CmsDefaultValidationHandler();
                handler.checkUserName((String)value);
            }
            catch (CmsIllegalArgumentException e) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_VALIDATION_LOGINNAME_INVALID_0", new Object[0]));
            }
        }
    }
}

