/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.server.Resource;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.util.CmsUUID;

public class CmsResourceInfoTable
extends Table {
    private static final long serialVersionUID = 5999721724863889097L;
    private static String PROP_ELEMENT = "element";
    IndexedContainer m_container;

    public CmsResourceInfoTable(CmsObject cms, Set<CmsUUID> userIDs, Set<CmsUUID> groupIDs) {
        ArrayList<CmsUser> user = new ArrayList<CmsUser>();
        try {
            for (CmsUUID group : groupIDs) {
                user.addAll(cms.getUsersOfGroup(cms.readGroup(group).getName()));
            }
            HashSet<CmsUUID> principalIDs = new HashSet<CmsUUID>();
            principalIDs.addAll(userIDs);
            principalIDs.addAll(groupIDs);
            HashSet<CmsResource> resources = new HashSet<CmsResource>();
            for (CmsUUID id : principalIDs) {
                resources.addAll(cms.getResourcesForPrincipal(id, null, false));
            }
            this.init(resources, user);
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    public CmsResourceInfoTable(Set<CmsResource> resources, List<CmsUser> user) {
        Item item;
        this.addStyleName("o-no-padding");
        this.m_container = new IndexedContainer();
        this.m_container.addContainerProperty((Object)PROP_ELEMENT, CmsResourceInfo.class, null);
        for (CmsResource res : resources) {
            item = this.m_container.addItem((Object)res);
            item.getItemProperty((Object)PROP_ELEMENT).setValue((Object)new CmsResourceInfo(res));
        }
        if (user != null) {
            for (CmsUser us : user) {
                item = this.m_container.addItem((Object)us);
                item.getItemProperty((Object)PROP_ELEMENT).setValue((Object)new CmsResourceInfo(us.getSimpleName(), us.getDescription(), (Resource)new CmsCssIcon("oc-icon-24-user")));
            }
        }
        this.setColumnHeaderMode(Table.ColumnHeaderMode.HIDDEN);
        this.setContainerDataSource((Container)this.m_container);
        this.setVisibleColumns(new Object[]{PROP_ELEMENT});
    }

    private void init(Set<CmsResource> resources, List<CmsUser> user) {
        Item item;
        this.addStyleName("o-no-padding");
        this.m_container = new IndexedContainer();
        this.m_container.addContainerProperty((Object)PROP_ELEMENT, CmsResourceInfo.class, null);
        for (CmsResource res : resources) {
            item = this.m_container.addItem((Object)res);
            if (item == null) continue;
            item.getItemProperty((Object)PROP_ELEMENT).setValue((Object)new CmsResourceInfo(res));
        }
        if (user != null) {
            for (CmsUser us : user) {
                item = this.m_container.addItem((Object)us);
                if (item == null) continue;
                item.getItemProperty((Object)PROP_ELEMENT).setValue((Object)new CmsResourceInfo(us.getSimpleName(), us.getDescription(), (Resource)new CmsCssIcon("oc-icon-24-user")));
            }
        }
        this.setColumnHeaderMode(Table.ColumnHeaderMode.HIDDEN);
        this.setContainerDataSource((Container)this.m_container);
        this.setVisibleColumns(new Object[]{PROP_ELEMENT});
    }
}

