/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsOuTreeType;
import org.opencms.ui.apps.user.CmsUserTable;
import org.opencms.ui.apps.user.I_CmsFilterableTable;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsRoleTable
extends Table
implements I_CmsFilterableTable {
    private static final long serialVersionUID = 7863356514060544048L;
    private static final Log LOG = CmsLog.getLog(CmsUserTable.class);
    private IndexedContainer m_container;
    CmsObject m_cms;
    CmsContextMenu m_menu;
    protected String m_group;
    private List<I_CmsSimpleContextMenuEntry<Set<String>>> m_menuEntries;
    private String m_parentOU;
    private CmsAccountsApp m_app;

    public CmsRoleTable(CmsAccountsApp app, String ou) {
        try {
            this.m_app = app;
            this.m_parentOU = ou;
            this.m_cms = this.getCmsObject();
            List<CmsRole> roles = OpenCms.getRoleManager().getRoles(this.m_cms, ou, false);
            this.init(roles);
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read user.", (Throwable)e);
        }
    }

    @Override
    public void filter(String data) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(data)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)TableProperty.Name, data, true, false), new SimpleStringFilter((Object)TableProperty.Description, data, true, false)}));
        }
    }

    @Override
    public VerticalLayout getEmptyLayout() {
        VerticalLayout layout = new VerticalLayout();
        layout.setVisible(false);
        return layout;
    }

    protected void updateApp(CmsRole role) {
        this.m_app.update(this.m_parentOU, CmsOuTreeType.ROLE, role.getId(), "");
    }

    List<I_CmsSimpleContextMenuEntry<Set<String>>> getMenuEntries() {
        if (this.m_menuEntries == null) {
            this.m_menuEntries = new ArrayList<I_CmsSimpleContextMenuEntry<Set<String>>>();
            this.m_menuEntries.add(new EntryOpen());
        }
        return this.m_menuEntries;
    }

    private CmsObject getCmsObject() {
        CmsObject cms;
        try {
            cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
        }
        catch (CmsException e) {
            cms = A_CmsUI.getCmsObject();
        }
        return cms;
    }

    private void init(List<CmsRole> roles) {
        CmsRole.applySystemRoleOrder(roles);
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.m_container = new IndexedContainer();
        for (TableProperty prop : TableProperty.values()) {
            this.m_container.addContainerProperty((Object)prop, prop.getType(), prop.getDefault());
            this.setColumnHeader((Object)prop, prop.getName());
        }
        this.setContainerDataSource((Container)this.m_container);
        this.setItemIconPropertyId((Object)TableProperty.Icon);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnWidth(null, 40);
        this.setSelectable(true);
        this.setVisibleColumns(new Object[]{TableProperty.Name, TableProperty.OU});
        for (CmsRole role : roles) {
            Item item = this.m_container.addItem((Object)role);
            item.getItemProperty((Object)TableProperty.Name).setValue((Object)role.getName(A_CmsUI.get().getLocale()));
            item.getItemProperty((Object)TableProperty.Description).setValue((Object)role.getDescription(A_CmsUI.get().getLocale()));
            item.getItemProperty((Object)TableProperty.OU).setValue((Object)role.getOuFqn());
        }
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 4807195510202231174L;

            public void itemClick(ItemClickEvent event) {
                CmsRoleTable.this.setValue(null);
                CmsRoleTable.this.select(event.getItemId());
                if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || event.getPropertyId() == null) {
                    CmsRoleTable.this.m_menu.setEntries(CmsRoleTable.this.getMenuEntries(), Collections.singleton(((CmsRole)CmsRoleTable.this.getValue()).getId().getStringValue()));
                    CmsRoleTable.this.m_menu.openForTable((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId(), CmsRoleTable.this);
                } else if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT) && event.getPropertyId().equals((Object)TableProperty.Name)) {
                    CmsRoleTable.this.updateApp((CmsRole)CmsRoleTable.this.getValue());
                }
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                if (TableProperty.Name.equals(propertyId)) {
                    return " o-hover-column";
                }
                return "";
            }
        });
        this.setVisibleColumns(new Object[]{TableProperty.Name, TableProperty.Description, TableProperty.OU});
    }

    static enum TableProperty {
        Icon(null, Resource.class, new CmsCssIcon("oc-icon-24-role")),
        Name(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_NAME_0", new Object[0]), String.class, ""),
        Description(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_DESCRIPTION_0", new Object[0]), String.class, ""),
        OU(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_OU_0", new Object[0]), String.class, "");

        private Object m_defaultValue;
        private String m_headerMessage;
        private Class<?> m_type;

        private TableProperty(String name, Class<?> type, Object defaultValue) {
            this.m_headerMessage = name;
            this.m_type = type;
            this.m_defaultValue = defaultValue;
        }

        Object getDefault() {
            return this.m_defaultValue;
        }

        String getName() {
            return this.m_headerMessage;
        }

        Class<?> getType() {
            return this.m_type;
        }
    }

    class EntryOpen
    implements I_CmsSimpleContextMenuEntry<Set<String>>,
    I_CmsSimpleContextMenuEntry.I_HasCssStyles {
        EntryOpen() {
        }

        @Override
        public void executeAction(Set<String> context) {
            CmsRoleTable.this.updateApp(CmsRole.valueOfId(new CmsUUID(context.iterator().next())));
        }

        @Override
        public String getStyles() {
            return "bold";
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_OPEN_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(Set<String> context) {
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
    }
}

