/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.shared.ui.datefield.DateTimeResolution;
import com.vaadin.ui.DateTimeField;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.Messages;

public class CmsDateField
extends DateTimeField {
    private static final long serialVersionUID = 1L;

    public CmsDateField() {
        this.setResolution((Enum)DateTimeResolution.MINUTE);
        String parseError = Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_INVALID_DATE_FORMAT_0");
        this.setParseErrorMessage(parseError);
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static Date localDateTimeToDate(LocalDateTime local) {
        if (local == null) {
            return null;
        }
        ZonedDateTime zdt = local.atZone(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    public Date getDate() {
        return CmsDateField.localDateTimeToDate((LocalDateTime)this.getValue());
    }

    public void setDate(Date date) {
        this.setValue(CmsDateField.dateToLocalDateTime(date));
    }
}

