/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsDialogContext;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsEditPropertyContext;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.contextmenu.CmsContextMenuEditHandler;
import org.opencms.util.CmsUUID;

public class CmsFileTableDialogContext
extends A_CmsDialogContext
implements I_CmsEditPropertyContext {
    private CmsFileTable m_fileTable;
    private Collection<CmsResourceTableProperty> m_editableProperties;

    public CmsFileTableDialogContext(String appId, I_CmsDialogContext.ContextType contextType, CmsFileTable fileTable, List<CmsResource> resources) {
        super(appId, contextType, resources);
        this.m_fileTable = fileTable;
    }

    @Override
    public void editProperty(Object propertyId) {
        new CmsContextMenuEditHandler(this.getResources().get(0).getStructureId(), (CmsResourceTableProperty)propertyId, this.m_fileTable, this).start();
    }

    @Override
    public void finish(CmsProject project, String siteRoot) {
        super.finish(null);
        super.reload();
    }

    @Override
    public void finish(Collection<CmsUUID> ids) {
        super.finish(ids);
        if (ids != null) {
            this.m_fileTable.update(ids, false);
        }
    }

    @Override
    public void focus(CmsUUID cmsUUID) {
    }

    @Override
    public List<CmsUUID> getAllStructureIdsInView() {
        return Lists.newArrayList(this.m_fileTable.getAllIds());
    }

    @Override
    public boolean isPropertyEditable(Object propertyId) {
        return this.getResources().size() == 1 && this.m_editableProperties != null && this.m_editableProperties.contains(propertyId) && this.m_fileTable.isColumnVisible((CmsResourceTableProperty)propertyId);
    }

    public void setEditableProperties(Collection<CmsResourceTableProperty> editableProperties) {
        this.m_editableProperties = editableProperties;
    }

    @Override
    public void updateUserInfo() {
    }
}

