/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.UI;
import com.vaadin.v7.ui.TextField;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.util.CmsMacroResolver;

public class CmsMacroResolverDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 4326570443207345219L;
    Runnable m_cancelAction;
    Runnable m_okAction;
    private Map<TextField, String> m_bundleComponentKeyMap = new HashMap<TextField, String>();
    private FormLayout m_bundleValues;
    private Button m_cancelButton;
    private Button m_okButton;

    public CmsMacroResolverDialog(Runnable okAction, Runnable cancelAction, CmsResource resource) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_okAction = okAction;
        this.m_cancelAction = cancelAction;
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (CmsMacroResolverDialog.this.m_okAction != null) {
                    CmsMacroResolverDialog.this.m_okAction.run();
                }
            }
        });
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (CmsMacroResolverDialog.this.m_cancelAction != null) {
                    CmsMacroResolverDialog.this.m_cancelAction.run();
                }
            }
        });
        try {
            CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            CmsResource descriptor = cms.readResource(resource.getRootPath() + ".macros" + "/" + "siteMacroBundle" + "_desc");
            Properties resourceBundle = this.getLocalizedBundle(cms, resource.getRootPath());
            Map<String, String[]> bundleKeyDescriptorMap = CmsMacroResolver.getBundleMapFromResources(resourceBundle, descriptor, cms);
            for (String key : bundleKeyDescriptorMap.keySet()) {
                TextField field = new TextField();
                field.setCaption(bundleKeyDescriptorMap.get(key)[0]);
                field.setValue(bundleKeyDescriptorMap.get(key)[1]);
                field.setWidth("100%");
                this.m_bundleValues.addComponent((Component)field);
                this.m_bundleComponentKeyMap.put(field, key);
            }
        }
        catch (IOException | CmsException exception) {
            // empty catch block
        }
    }

    public Map<String, String> getMacroMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.m_bundleComponentKeyMap != null) {
            Set<TextField> fields = this.m_bundleComponentKeyMap.keySet();
            for (TextField field : fields) {
                map.put(this.m_bundleComponentKeyMap.get(field), (String)field.getValue());
            }
        }
        return map;
    }

    private String getAvailableLocalVariant(CmsObject cms, String path, String baseName) {
        A_CmsUI.get();
        List<String> localVariations = CmsLocaleManager.getLocaleVariants(baseName, UI.getCurrent().getLocale(), false, true);
        for (String name : localVariations) {
            if (!cms.existsResource(path + name)) continue;
            return name;
        }
        return null;
    }

    private Properties getLocalizedBundle(CmsObject cms, String path) throws CmsException, IOException {
        CmsResource bundleResource = cms.readResource(path + ".macros" + "/" + this.getAvailableLocalVariant(cms, path + ".macros" + "/", "siteMacroBundle"));
        Properties ret = new Properties();
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(cms.readFile(bundleResource).getContents()), StandardCharsets.UTF_8);
        ret.load(reader);
        return ret;
    }
}

