/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.UI;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsUserIconHelper;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.CmsPreferencesDialogAction;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.components.CmsUploadButton;
import org.opencms.ui.components.CmsVerticalMenu;
import org.opencms.ui.components.Messages;
import org.opencms.ui.dialogs.CmsEmbeddedDialogContext;
import org.opencms.ui.dialogs.CmsUserDataDialog;
import org.opencms.ui.login.CmsChangePasswordDialog;
import org.opencms.ui.login.CmsLoginController;
import org.opencms.ui.shared.components.CmsUploadState;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsAccountInfo;

public class CmsUserInfo
extends VerticalLayout {
    private static final String LINE_BREAK = "<br />";
    private static final long serialVersionUID = 7215454442218119869L;
    static Log LOG = CmsLog.getLog(CmsUserInfo.class.getName());
    static final String DIV_HTML = "<div style=\"vertical-align:middle;\">";
    static final String HTML_SPACE = "&nbsp;";
    static final String DIV_END = "</div>";
    I_CmsDialogContext m_context;
    CmsUser m_user;
    private Label m_info;
    private Label m_details;
    private HorizontalLayout m_infoPanel;
    private CmsVerticalMenu m_menu;
    private CmsUploadButton.I_UploadListener m_uploadListener;

    public CmsUserInfo(CmsUUID cmsUUID) {
        this(cmsUUID, null);
    }

    public CmsUserInfo(CmsUUID cmsUUID, String widthString) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        if (widthString != null) {
            this.m_info.setWidth(widthString);
        }
        try {
            CmsObject cms = A_CmsUI.getCmsObject();
            this.m_user = cms.readUser(cmsUUID);
            this.m_info.setContentMode(ContentMode.HTML);
            this.m_info.setValue(this.generateInfo(cms, UI.getCurrent().getLocale()));
            this.m_details.setContentMode(ContentMode.HTML);
            this.m_details.setValue(this.generateInfoDetails(cms, UI.getCurrent().getLocale()));
            this.m_infoPanel.addComponent(this.createImageButton(), 0);
            this.m_menu.setVisible(false);
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read user", (Throwable)e);
        }
    }

    public CmsUserInfo(CmsUploadButton.I_UploadListener uploadListener, I_CmsDialogContext context) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        CmsObject cms = A_CmsUI.getCmsObject();
        this.m_uploadListener = uploadListener;
        this.m_user = cms.getRequestContext().getCurrentUser();
        this.m_context = context;
        this.m_info.setContentMode(ContentMode.HTML);
        this.m_info.setValue(this.generateInfo(cms, UI.getCurrent().getLocale()));
        this.m_details.setContentMode(ContentMode.HTML);
        this.m_details.setValue(this.generateInfoDetails(cms, UI.getCurrent().getLocale()));
        this.m_infoPanel.addComponent(this.createImageButton(), 0);
        this.initUserMenu();
    }

    public void addDetailLine(String lineHtml) {
        lineHtml = lineHtml.isEmpty() ? HTML_SPACE : lineHtml;
        this.m_details.setValue(this.m_details.getValue() + DIV_HTML + lineHtml + DIV_END);
    }

    void editUserData() {
        if (this.m_context instanceof CmsEmbeddedDialogContext) {
            ((CmsEmbeddedDialogContext)this.m_context).closeWindow(true);
        } else {
            A_CmsUI.get().closeWindows();
        }
        CmsUserDataDialog dialog = new CmsUserDataDialog(this.m_context);
        this.m_context.start(CmsVaadinUtils.getMessageText("GUI_USER_EDIT_0", new Object[0]), (Component)dialog);
    }

    void logout() {
        CmsLoginController.logout();
    }

    private Component createImageButton() {
        CssLayout layout = new CssLayout();
        layout.addStyleName("o-user-image");
        Image userImage = new Image();
        userImage.setSource((Resource)new ExternalResource(OpenCms.getWorkplaceAppManager().getUserIconHelper().getBigIconPath(A_CmsUI.getCmsObject(), this.m_user)));
        layout.addComponent((Component)userImage);
        if (!CmsAppWorkplaceUi.isOnlineProject() & this.m_uploadListener != null) {
            CmsUploadButton uploadButton = this.createImageUploadButton(null, (Resource)FontOpenCms.UPLOAD_SMALL, this.m_user, this.m_uploadListener);
            layout.addComponent((Component)uploadButton);
            if (CmsUserIconHelper.hasUserImage(this.m_user)) {
                Button deleteButton = new Button((Resource)FontOpenCms.TRASH_SMALL);
                deleteButton.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 1L;

                    public void buttonClick(Button.ClickEvent event) {
                        OpenCms.getWorkplaceAppManager().getUserIconHelper().deleteUserImage(A_CmsUI.getCmsObject());
                        CmsUserInfo.this.m_context.updateUserInfo();
                    }
                });
                layout.addComponent((Component)deleteButton);
            }
        }
        return layout;
    }

    private CmsUploadButton createImageUploadButton(String label, Resource icon, CmsUser user, CmsUploadButton.I_UploadListener uploadListener) {
        CmsUploadButton uploadButton = new CmsUploadButton("/system/userimages/temp/");
        if (label != null) {
            uploadButton.setCaption(label);
        }
        if (icon != null) {
            uploadButton.setIcon(icon);
        }
        uploadButton.getState().setUploadType(CmsUploadState.UploadType.singlefile);
        uploadButton.getState().setTargetFileNamePrefix(user.getId().toString());
        uploadButton.getState().setDialogTitle(CmsVaadinUtils.getMessageText("GUI_USER_INFO_UPLOAD_IMAGE_DIALOG_TITLE_0", new Object[0]));
        uploadButton.addUploadListener(uploadListener);
        return uploadButton;
    }

    private String generateInfo(CmsObject cms, Locale locale) {
        StringBuffer infoHtml = new StringBuffer(128);
        infoHtml.append("<p>").append(CmsStringUtil.escapeHtml(this.m_user.getSimpleName())).append("</p>");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_user.getFirstname())) {
            infoHtml.append(CmsStringUtil.escapeHtml(this.m_user.getFirstname())).append(HTML_SPACE);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_user.getLastname())) {
            infoHtml.append(CmsStringUtil.escapeHtml(this.m_user.getLastname()));
        }
        infoHtml.append(LINE_BREAK);
        return infoHtml.toString();
    }

    private String generateInfoDetails(CmsObject cms, Locale locale) {
        StringBuffer infoHtml = new StringBuffer(128);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_user.getEmail())) {
            infoHtml.append(CmsStringUtil.escapeHtml(this.m_user.getEmail())).append(LINE_BREAK);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_user.getOuFqn())) {
            infoHtml.append(CmsStringUtil.escapeHtml(this.m_user.getOuFqn())).append(LINE_BREAK);
        }
        for (CmsAccountInfo info : OpenCms.getWorkplaceManager().getAccountInfos()) {
            String value;
            if (info.getField().equals((Object)CmsAccountInfo.Field.firstname) || info.getField().equals((Object)CmsAccountInfo.Field.lastname) || CmsAccountInfo.Field.email.equals((Object)info.getField()) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(value = info.getValue(this.m_user))) continue;
            infoHtml.append(CmsStringUtil.escapeHtml(value)).append(LINE_BREAK);
        }
        if (OpenCms.getSessionManager().getSessionInfos(this.m_user.getId()).size() > 0) {
            infoHtml.append(Messages.get().getBundle(locale).key("GUI_USER_INFO_ONLINE_SINCE_1", DateFormat.getTimeInstance(2, locale).format(new Date(this.m_user.getLastlogin())))).append(LINE_BREAK);
        }
        return infoHtml.toString();
    }

    private void initUserMenu() {
        if (!this.m_user.isManaged()) {
            this.m_menu.addMenuEntry(CmsVaadinUtils.getMessageText("GUI_CHANGE_PASSWORD_BUTTON_0", new Object[0]), null).addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    CmsUserInfo.this.m_context.start(CmsVaadinUtils.getMessageText("GUI_PWCHANGE_HEADER_0", new Object[0]) + CmsUserInfo.this.m_user.getSimpleName(), (Component)new CmsChangePasswordDialog(CmsUserInfo.this.m_context));
                }
            });
        }
        final CmsPreferencesDialogAction preferencesAction = new CmsPreferencesDialogAction();
        this.m_menu.addMenuEntry(preferencesAction.getTitle(A_CmsUI.get().getLocale()), null).addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                preferencesAction.executeAction(CmsUserInfo.this.m_context);
            }
        });
        if (!this.m_user.isManaged()) {
            this.m_menu.addMenuEntry(CmsVaadinUtils.getMessageText("GUI_USER_EDIT_0", new Object[0]), null).addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    CmsUserInfo.this.editUserData();
                }
            });
        }
        this.m_menu.addMenuEntry(CmsVaadinUtils.getMessageText("GUI_EXPLORER_CONTEXT_LOGOUT_0", new Object[0]), null).addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUserInfo.this.logout();
            }
        });
    }
}

