/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.categoryselect;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.HierarchicalContainer;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TreeTable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.util.CmsStringUtil;

public class CmsCategoryTree
extends TreeTable {
    private static final String CHECKBOX = "checkbox";
    private static final String PATH = "path";
    private static final long serialVersionUID = 8046665824980274707L;
    private static final String TITLE = "title";
    Map<CmsCategory, CheckBox> m_checkboxes = new HashMap<CmsCategory, CheckBox>();
    private HierarchicalContainer m_container = new HierarchicalContainer();
    private boolean m_isDiplayOny;

    public CmsCategoryTree() {
        this.setContainerDataSource((Container)this.m_container);
        Table.ColumnGenerator captionGenerator = new Table.ColumnGenerator(){
            private static final long serialVersionUID = 1L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                String result = null;
                if (CmsCategoryTree.TITLE.equals(columnId)) {
                    result = ((CmsCategory)itemId).getTitle();
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
                        result = ((CmsCategory)itemId).getName();
                    }
                } else if (CmsCategoryTree.PATH.equals(columnId)) {
                    result = ((CmsCategory)itemId).getPath();
                } else if (CmsCategoryTree.CHECKBOX.equals(columnId)) {
                    result = CmsCategoryTree.this.m_checkboxes.get(itemId);
                }
                return result;
            }
        };
        this.addGeneratedColumn(TITLE, captionGenerator);
        this.addGeneratedColumn(PATH, captionGenerator);
        this.addGeneratedColumn(CHECKBOX, captionGenerator);
        this.setVisibleColumns(new Object[]{CHECKBOX, TITLE, PATH});
        this.setColumnWidth(CHECKBOX, 40);
        this.setColumnHeaderMode(Table.ColumnHeaderMode.HIDDEN);
        this.setItemCaptionPropertyId(TITLE);
    }

    public CmsCategoryTree(CmsObject cms, String contextPath) {
        this();
        this.loadCategories(cms, contextPath);
    }

    public Collection<CmsCategory> getSelectedCategories() {
        HashSet<CmsCategory> result = new HashSet<CmsCategory>();
        if (this.m_isDiplayOny) {
            result.addAll(this.getItemIds());
        } else {
            for (Map.Entry<CmsCategory, CheckBox> entry : this.m_checkboxes.entrySet()) {
                if (!((Boolean)entry.getValue().getValue()).booleanValue()) continue;
                result.add(entry.getKey());
            }
        }
        return result;
    }

    public void setCategories(List<CmsCategory> categories) {
        block0: for (int i = 0; i < categories.size(); ++i) {
            CmsCategory cat = categories.get(i);
            this.m_container.addItem((Object)cat);
            this.m_checkboxes.put(cat, new CheckBox());
            String parentPath = CmsResource.getParentFolder(cat.getPath());
            if (parentPath.length() <= 1) continue;
            for (int j = i - 1; j >= 0; --j) {
                if (!categories.get(j).getPath().equals(parentPath)) continue;
                this.m_container.setParent((Object)cat, (Object)categories.get(j));
                continue block0;
            }
        }
        for (CmsCategory cat : categories) {
            if (this.m_container.getChildren((Object)cat) != null && this.m_container.getChildren((Object)cat).size() != 0) continue;
            this.m_container.setChildrenAllowed((Object)cat, false);
        }
    }

    public void setDisplayOnly(boolean displayOnly) {
        this.m_isDiplayOny = displayOnly;
        if (displayOnly) {
            this.setVisibleColumns(new Object[]{TITLE, PATH});
        } else {
            this.setVisibleColumns(new Object[]{CHECKBOX, TITLE, PATH});
        }
    }

    public void setSelectedCategories(Collection<CmsCategory> categories) {
        for (Map.Entry<CmsCategory, CheckBox> entry : this.m_checkboxes.entrySet()) {
            entry.getValue().setValue((Object)categories.contains(entry.getKey()));
            CmsCategory parentCat = (CmsCategory)this.getParent(entry.getKey());
            if (parentCat == null) continue;
            this.setCollapsed(parentCat, false);
        }
    }

    void loadCategories(CmsObject cms, String contextPath) {
        this.m_checkboxes.clear();
        this.m_container.removeAllItems();
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        CmsCategoryService catService = CmsCategoryService.getInstance();
        try {
            List<CmsCategory> categories = catService.readCategories(cms, "", true, contextPath);
            categories = catService.localizeCategories(cms, categories, wpLocale);
            this.setCategories(categories);
        }
        catch (CmsException e) {
            e.printStackTrace();
        }
    }
}

