/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.codemirror;

import com.vaadin.annotations.JavaScript;
import com.vaadin.event.FieldEvents;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.JavaScriptComponentState;
import com.vaadin.ui.AbstractJavaScriptComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.JavaScriptFunction;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Property;
import elemental.json.JsonArray;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.ui.components.Messages;
import org.opencms.workplace.CmsWorkplace;

@JavaScript(value={"codemirror-connector.js"})
public class CmsCodeMirror
extends AbstractJavaScriptComponent
implements Property<String>,
Property.ValueChangeNotifier {
    private static final Method BLUR_METHOD;
    private static String[] CSS_URIS;
    private static final String HTML_ID_PREFIX = "cm-addon-";
    private static String[] JAVASCRIPT_URIS;
    private static long m_componentCount;
    private static final long serialVersionUID = -4921119175861329688L;
    private static final Method VALUE_CHANGE_METHOD;
    private String m_codeValue = "";
    private final long m_componentId = m_componentCount++;

    public CmsCodeMirror() {
        this.getState().m_id = this.m_componentId;
        this.getState().m_contentValue = this.m_codeValue;
        CmsMessages messages = Messages.get().getBundle(UI.getCurrent().getLocale());
        this.getState().m_shortcutsMessage = this.getShortcutMessages(messages);
        this.getState().m_messages = this.getLocalizationMessages(messages);
        if (CSS_URIS == null) {
            CSS_URIS = new String[]{CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/lib/codemirror.css"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/theme/eclipse.css"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/dialog/dialog.css"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/hint/show-hint.css")};
        }
        this.getState().m_cssURIs = CSS_URIS;
        if (JAVASCRIPT_URIS == null) {
            JAVASCRIPT_URIS = new String[]{CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/lib/codemirror.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/dialog/dialog.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/search/searchcursor.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/js/search.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/edit/closebrackets.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/edit/closetag.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/edit/matchbrackets.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/hint/show-hint.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/hint/html-hint.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/hint/javascript-hint.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/hint/xml-hint.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/fold/foldcode.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/fold/brace-fold.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/fold/xml-fold.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/comment/comment.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/addon/selection/active-line.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/mode/css/css.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/mode/xml/xml.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/mode/clike/clike.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/mode/javascript/javascript.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/mode/css/css.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/dist/mode/htmlmixed/htmlmixed.js"), CmsWorkplace.getStaticResourceUri("/editors/codemirror/js/htmlembedded_modified.js")};
        }
        this.getState().m_scriptURIs = JAVASCRIPT_URIS;
        this.addFunction("onBlur", new JavaScriptFunction(){
            private static final long serialVersionUID = 1L;

            public void call(JsonArray arguments) {
                CmsCodeMirror.this.onBlur(arguments.getString(0));
            }
        });
        this.addFunction("onChange", new JavaScriptFunction(){
            private static final long serialVersionUID = 1L;

            public void call(JsonArray arguments) {
                CmsCodeMirror.this.onChange(arguments.getString(0));
            }
        });
        this.addStyleName("o-codemirror");
    }

    public void addBlurListener(FieldEvents.BlurListener listener) {
        this.addListener(FieldEvents.BlurEvent.class, listener, BLUR_METHOD);
        this.markAsDirty();
    }

    @Deprecated
    public void addListener(Property.ValueChangeListener listener) {
        this.addValueChangeListener(listener);
    }

    public void addValueChangeListener(Property.ValueChangeListener listener) {
        this.addListener(Property.ValueChangeEvent.class, listener, VALUE_CHANGE_METHOD);
        this.markAsDirty();
    }

    public String getFontSize() {
        return this.getState().m_fontSize;
    }

    public Class<? extends String> getType() {
        return String.class;
    }

    public String getValue() {
        return this.m_codeValue;
    }

    public boolean isCloseBrackets() {
        return this.getState().m_closeBrackets;
    }

    public boolean isHighlighting() {
        return this.getState().m_highlighting;
    }

    public boolean isLineWrapping() {
        return this.getState().m_lineWrapping;
    }

    public boolean isReadOnly() {
        return super.isReadOnly();
    }

    public boolean isTabsVisible() {
        return this.getState().m_tabsVisible;
    }

    public void registerSearchReplace(Button search, Button replace) {
        if (this.getState().m_enableSearchReplace) {
            throw new RuntimeException("Search/replace already registered.");
        }
        search.setId(HTML_ID_PREFIX + this.m_componentId + "-search");
        replace.setId(HTML_ID_PREFIX + this.m_componentId + "-replace");
        this.getState().m_enableSearchReplace = true;
        this.markAsDirty();
    }

    public void registerUndoRedo(Button undo, Button redo) {
        if (this.getState().m_enableUndoRedo) {
            throw new RuntimeException("Undo/redo already registered.");
        }
        undo.setId(HTML_ID_PREFIX + this.m_componentId + "-undo");
        redo.setId(HTML_ID_PREFIX + this.m_componentId + "-redo");
        this.getState().m_enableUndoRedo = true;
        this.markAsDirty();
    }

    public void removeBlurListener(FieldEvents.BlurNotifier listener) {
        this.removeListener(FieldEvents.BlurEvent.class, listener, BLUR_METHOD);
        this.markAsDirty();
    }

    @Deprecated
    public void removeListener(Property.ValueChangeListener listener) {
        this.removeValueChangeListener(listener);
    }

    public void removeValueChangeListener(Property.ValueChangeListener listener) {
        this.removeListener(Property.ValueChangeEvent.class, listener, VALUE_CHANGE_METHOD);
        this.markAsDirty();
    }

    public void setCloseBrackets(boolean closeBrackets) {
        this.getState().m_closeBrackets = closeBrackets;
        this.markAsDirty();
    }

    public void setFontSize(String fontSize) {
        this.getState().m_fontSize = fontSize;
        this.markAsDirty();
    }

    public void setHeight(float height, Sizeable.Unit unit) {
        super.setHeight(height, unit);
        this.getState().m_height = height + unit.getSymbol();
        this.markAsDirty();
    }

    public void setHeight(String height) {
        super.setHeight(height);
        this.getState().m_height = height;
        this.markAsDirty();
    }

    public void setHighlighting(boolean highlighting) {
        this.getState().m_highlighting = highlighting;
        this.markAsDirty();
    }

    public void setLanguage(CodeMirrorLanguage codeMirrorLanguage) {
        this.getState().m_mode = codeMirrorLanguage.getLanguageName();
        this.markAsDirty();
    }

    public void setLineWrapping(boolean lineWrapping) {
        this.getState().m_lineWrapping = lineWrapping;
        this.markAsDirty();
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
    }

    public void setTabsVisible(boolean tabsVisible) {
        this.getState().m_tabsVisible = tabsVisible;
        this.markAsDirty();
    }

    public void setTheme(CodeMirrorTheme codeMirrorTheme) {
        this.getState().m_theme = codeMirrorTheme.getThemeName();
        this.markAsDirty();
    }

    public void setValue(String value) {
        this.m_codeValue = value;
        this.getState().m_contentValue = value;
        this.markAsDirty();
    }

    public void setWidth(float width, Sizeable.Unit unit) {
        super.setWidth(width, unit);
        this.getState().m_width = width + unit.getSymbol();
        this.markAsDirty();
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this.getState().m_width = width;
        this.markAsDirty();
    }

    protected CodeMirrorState getState() {
        return (CodeMirrorState)super.getState();
    }

    void onBlur(String value) {
        this.m_codeValue = value;
        this.fireEvent((EventObject)new FieldEvents.BlurEvent((Component)this));
    }

    void onChange(String value) {
        boolean changed = !this.m_codeValue.equals(value);
        this.m_codeValue = value;
        if (changed) {
            this.fireEvent((EventObject)((Object)new ValueChangeEvent(this)));
        }
    }

    private String getLocalizationMessages(CmsMessages messages) {
        JSONObject result = new JSONObject();
        try {
            result.put("search", messages.key("GUI_CODEMIRROR_LANG_SEARCH_0"));
            result.put("hint", messages.key("GUI_CODEMIRROR_LANG_HINT_0"));
            result.put("replace", messages.key("GUI_CODEMIRROR_LANG_REPLACE_0"));
            result.put("replacewith", messages.key("GUI_CODEMIRROR_LANG_REPLACE_WITH_0"));
            result.put("replaceconfirm", messages.key("GUI_CODEMIRROR_LANG_REPLACE_CONFIRM_0"));
            result.put("replaceyes", messages.key("GUI_CODEMIRROR_LANG_REPLACE_YES_0"));
            result.put("replaceno", messages.key("GUI_CODEMIRROR_LANG_RELACE_NO_0"));
            result.put("replacestop", messages.key("GUI_CODEMIRROR_LANG_REPLACE_STOP_0"));
            result.put("fontsize", messages.key("GUI_CODEMIRROR_LANG_FONT_SIZE_0"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return result.toString();
    }

    private String getShortcutMessages(CmsMessages messages) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<span class=\"col1\"><b>").append(messages.key("GUI_CODEMIRROR_SHORTCUT_SEARCH_0"));
        buffer.append("</b> ").append(messages.key("GUI_CODEMIRROR_SHORTCUT_SEARCH_HELP_0"));
        buffer.append(" </span><span class=\"col2\"><b>").append(messages.key("GUI_CODEMIRROR_SHORTCUT_FIND_NEXT_0"));
        buffer.append("</b> ").append(messages.key("GUI_CODEMIRROR_SHORTCUT_FIND_NEXT_HELP_0"));
        buffer.append(" </span><span class=\"col3\"><b>").append(messages.key("GUI_CODEMIRROR_SHORTCUT_FIND_PREVIOUS_0"));
        buffer.append("</b> ").append(messages.key("GUI_CODEMIRROR_SHORTCUT_FIND_PREVIOUS_HELP_0"));
        buffer.append(" </span><span class=\"col1\"><b>").append(messages.key("GUI_CODEMIRROR_SHORTCUT_REPLACE_0"));
        buffer.append("</b> ").append(messages.key("GUI_CODEMIRROR_SHORTCUT_REPLACE_HELP_0"));
        buffer.append(" </span><span class=\"col2\"><b>").append(messages.key("GUI_CODEMIRROR_SHORTCUT_REPLACE_ALL_0"));
        buffer.append("</b> ").append(messages.key("GUI_CODEMIRROR_SHORTCUT_REPLACE_ALL_HELP_0")).append("</span>");
        return buffer.toString();
    }

    static {
        try {
            VALUE_CHANGE_METHOD = Property.ValueChangeListener.class.getDeclaredMethod("valueChange", Property.ValueChangeEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in ValueChangeListener");
        }
        try {
            BLUR_METHOD = FieldEvents.BlurListener.class.getDeclaredMethod("blur", FieldEvents.BlurEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in ValueChangeListener");
        }
    }

    public static class ValueChangeEvent
    extends Component.Event
    implements Property.ValueChangeEvent {
        private static final long serialVersionUID = 1L;

        public ValueChangeEvent(CmsCodeMirror eventSource) {
            super((Component)eventSource);
        }

        public Property getProperty() {
            return (Property)this.getSource();
        }
    }

    public static enum CodeMirrorTheme {
        AMBIANCE("ambiance"),
        BASE16_DARK("base16-dark"),
        BASE16_LIGHT("base16-light"),
        BLACKBOARD("blackboard"),
        COBALT("cobalt"),
        DAY_3024("3024-day"),
        DEFAULT("default"),
        ECLIPSE("eclipse"),
        ELEGANT("elegant"),
        ERLANG_DARK("erlang-dark"),
        ERLANG_LIGHT("erlang-light"),
        LESSER_DARK("lesser-dark"),
        MBO("mbo"),
        MDN_LIKE("mdn-like"),
        MIDNIGHT("midnight"),
        MONOKAI("monokai"),
        NEAT("neat"),
        NIGHT("night"),
        NIGHT_3024("3024-night"),
        PARAISO_DARK("paraiso-dark"),
        PARAISO_LIGHT("paraiso-light"),
        PASTEL_ON_DARK("paster-on-dark"),
        RUBYBLUE("rubyblue"),
        SOLARIZED_DARK("solarized dark"),
        SOLARIZED_LIGHT("solarized light"),
        THE_MATRIX("the-matrix"),
        TOMORROW_NIGHT_EIGHTIES("tomorrow-night-eighties"),
        TWILIGHT("twilight"),
        VIBRANT_INK("vibrant-ink"),
        XQ_DARK("xq-dark"),
        XQ_LIGHT("xq-light");

        private final String m_themeName;

        private CodeMirrorTheme(String themeName) {
            this.m_themeName = themeName;
        }

        public String getThemeName() {
            return this.m_themeName;
        }

        public String toString() {
            return this.m_themeName;
        }
    }

    public static class CodeMirrorState
    extends JavaScriptComponentState {
        private static final long serialVersionUID = 1L;
        public boolean m_closeBrackets = true;
        public String m_contentValue = "//please start to code";
        public String[] m_cssURIs;
        public boolean m_enableSearchReplace;
        public boolean m_enableUndoRedo;
        public String m_fontSize = "14px";
        public String m_height = "600";
        public boolean m_highlighting = true;
        public long m_id;
        public boolean m_lineWrapping = true;
        public String m_mode = CodeMirrorLanguage.JAVASCRIPT.toString();
        public String[] m_scriptURIs;
        public String m_shortcutsMessage;
        public boolean m_tabsVisible = true;
        public String m_theme = CodeMirrorTheme.ECLIPSE.toString();
        public String m_width = "600";
        public String m_messages;
    }

    public static enum CodeMirrorLanguage {
        CSS("css", new String[]{"css"}),
        HTML("text/html", new String[]{"html", "htm", "xhtml"}),
        JAVA("text/x-java", new String[]{"java"}),
        JAVASCRIPT("javascript", new String[]{"js"}),
        JSP("application/x-jsp", new String[]{"jsp"}),
        XML("application/xml", new String[]{"xml", "xsd"});

        private final String m_languageName;
        private Set<String> m_supportedFileTypes;

        private CodeMirrorLanguage(String languageName, String[] fileTypes) {
            this.m_languageName = languageName;
            this.m_supportedFileTypes = new HashSet<String>(Arrays.asList(fileTypes));
        }

        public String getLanguageName() {
            return this.m_languageName;
        }

        public boolean isSupportedFileType(String fileNameSuffix) {
            return this.m_supportedFileTypes.contains(fileNameSuffix);
        }

        public String toString() {
            return this.m_languageName;
        }
    }
}

