/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.extensions;

import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import java.util.HashSet;
import java.util.Set;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.shared.rpc.I_CmsJSPBrowserFrameRpc;
import org.opencms.util.CmsUUID;

public class CmsJSPBrowserFrameExtension
extends AbstractExtension
implements I_CmsJSPBrowserFrameRpc {
    private static final long serialVersionUID = -417339050505442749L;
    private I_CmsDialogContext m_context;
    private Window m_window;

    private CmsJSPBrowserFrameExtension(String link, I_CmsDialogContext context) {
        this.m_context = context;
        ExternalResource res = new ExternalResource(link);
        BrowserFrame browser = new BrowserFrame("Browser", (Resource)res);
        browser.setSizeFull();
        this.m_window = new Window();
        this.m_window.setSizeFull();
        this.m_window.addStyleName("o-jspwindow");
        this.m_window.setContent((Component)browser);
        this.m_window.setClosable(false);
        this.m_window.setDraggable(false);
        CmsAppWorkplaceUi.get().addWindow(this.m_window);
        super.extend((AbstractClientConnector)browser);
        this.registerRpc(this);
    }

    public static void showExtendedBrowserFrame(String jspLink, I_CmsDialogContext context) {
        new CmsJSPBrowserFrameExtension(jspLink, context);
    }

    @Override
    public void cancelParentWindow(String[] uuids) {
        this.m_window.close();
        this.m_context.finish(this.getSetFromUUIDStrings(uuids));
    }

    private Set<CmsUUID> getSetFromUUIDStrings(String[] uuids) {
        HashSet<CmsUUID> res = new HashSet<CmsUUID>();
        for (String uuid : uuids) {
            res.add(new CmsUUID(uuid));
        }
        return res;
    }
}

