/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.extensions;

import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.ui.AbstractComponent;
import java.util.ArrayList;
import java.util.List;
import org.opencms.ui.components.CmsUploadButton;
import org.opencms.ui.shared.components.CmsUploadAreaState;
import org.opencms.ui.shared.rpc.I_CmsUploadRpc;

public class CmsUploadAreaExtension
extends AbstractExtension
implements I_CmsUploadRpc {
    private static final long serialVersionUID = 3978957151754705873L;
    private List<CmsUploadButton.I_UploadListener> m_listeners;

    public CmsUploadAreaExtension(AbstractComponent component) {
        this.extend((AbstractClientConnector)component);
        this.registerRpc(this);
        this.m_listeners = new ArrayList<CmsUploadButton.I_UploadListener>();
    }

    public void addUploadListener(CmsUploadButton.I_UploadListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void onUploadFinished(List<String> files) {
        for (CmsUploadButton.I_UploadListener listener : this.m_listeners) {
            listener.onUploadFinished(files);
        }
    }

    public void removeUploadListener(CmsUploadButton.I_UploadListener listener) {
        this.m_listeners.remove(listener);
    }

    public void setTargetFolder(String targetFolder) {
        this.getState().setTargetFolderRootPath(targetFolder);
    }

    protected CmsUploadAreaState getState() {
        return (CmsUploadAreaState)super.getState();
    }
}

