/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.fileselect;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;

public class CmsNavigationFilter
implements Container.Filter {
    private static final long serialVersionUID = 1L;
    private List<String> m_navigationPaths = Lists.newArrayList();

    public CmsNavigationFilter(CmsObject cms, CmsResource root) throws CmsException {
        CmsObject rootCms = OpenCms.initCmsObject(cms);
        rootCms.getRequestContext().setSiteRoot("");
        HashSet navResources = Sets.newHashSet(rootCms.readResourcesWithProperty("NavText"));
        navResources.addAll(rootCms.readResourcesWithProperty("NavPos"));
        for (CmsResource res : navResources) {
            if (res.getRootPath().startsWith("/system/workplace")) continue;
            this.m_navigationPaths.addAll(this.getAncestorPaths(res.getRootPath()));
        }
    }

    public boolean appliesToProperty(Object propertyId) {
        return false;
    }

    public boolean passesFilter(Object itemId, Item item) throws UnsupportedOperationException {
        CmsResource res = (CmsResource)item.getItemProperty((Object)"RESOURCE").getValue();
        if (res == null) {
            return true;
        }
        return this.m_navigationPaths.contains(res.getRootPath());
    }

    List<String> getAncestorPaths(String path) {
        ArrayList result = Lists.newArrayList();
        while (path != null) {
            result.add(path);
            path = CmsResource.getParentFolder(path);
        }
        return result;
    }
}

