/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components.fileselect;

import com.google.common.collect.Lists;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.HierarchicalContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsResourceIcon;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.util.I_CmsItemSorter;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsResourceTreeContainer
extends HierarchicalContainer {
    public static final String PROPERTY_RESOURCE = "RESOURCE";
    public static final String PROPERTY_SITEMAP_CAPTION = "SITEMAP_CAPTION";
    private static final Log LOG = CmsLog.getLog(CmsResourceTreeContainer.class);
    private static final long serialVersionUID = 1L;
    private CmsResourceFilter m_filter;

    public CmsResourceTreeContainer(CmsResourceFilter filter) {
        this.m_filter = filter;
        this.defineProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeItem(CmsObject cms, CmsResource resource, CmsUUID parentId) {
        ArrayList filters = Lists.newArrayList((Iterable)this.getContainerFilters());
        this.removeAllContainerFilters();
        try {
            Item resourceItem = this.getItem(resource.getStructureId());
            if (resourceItem == null) {
                resourceItem = this.addItem(resource.getStructureId());
            }
            this.fillProperties(cms, resourceItem, resource, parentId);
            if (resource.isFile()) {
                this.setChildrenAllowed(resource.getStructureId(), false);
            }
            if (parentId != null) {
                this.setParent(resource.getStructureId(), parentId);
            }
        }
        finally {
            for (Container.Filter filter : filters) {
                this.addContainerFilter(filter);
            }
        }
    }

    public Collection<?> getSortableContainerPropertyIds() {
        if (this.getItemSorter() instanceof I_CmsItemSorter) {
            return ((I_CmsItemSorter)this.getItemSorter()).getSortableContainerPropertyIds((Container)this);
        }
        return super.getSortableContainerPropertyIds();
    }

    public void initRoot(CmsObject cms, CmsResource root) {
        this.addTreeItem(cms, root, null);
        this.readTreeLevel(cms, root.getStructureId());
    }

    public void readTreeLevel(CmsObject cms, CmsUUID parentId) {
        try {
            CmsResource parent = cms.readResource(parentId, this.m_filter);
            List<CmsResource> children = cms.readResources(parent, this.m_filter, false);
            this.setChildrenAllowed(parentId, !children.isEmpty());
            for (CmsResource resource : children) {
                this.addTreeItem(cms, resource, parentId);
            }
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(CmsVaadinUtils.getMessageText("ERR_EXPLORER_CAN_NOT_READ_RESOURCE_1", parentId), e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void removeChildren(CmsUUID parentId) {
        Collection children = this.getChildren(parentId);
        if (children != null) {
            ArrayList childIds = new ArrayList(children);
            for (Object childId : childIds) {
                this.removeItemRecursively(childId);
            }
        }
    }

    public void update(CmsObject cms, CmsUUID id, CmsResourceFilter filter) throws CmsException {
        try {
            CmsResource resource = cms.readResource(id, filter);
            CmsResource parent = cms.readParentFolder(id);
            CmsUUID parentId = parent.getStructureId();
            Item resourceItem = this.getItem(id);
            if (resourceItem != null) {
                this.fillProperties(cms, resourceItem, resource, parentId);
                if (parentId != null) {
                    this.setParent(resource.getStructureId(), parentId);
                }
            } else {
                this.addTreeItem(cms, resource, parentId);
            }
        }
        catch (CmsVfsResourceNotFoundException e) {
            this.removeItemRecursively(id);
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void updateSort() {
        this.doSort();
        if (this.isFiltered()) {
            this.filterAll();
        } else {
            this.fireItemSetChange();
        }
    }

    protected void defineProperties() {
        this.addContainerProperty(CmsResourceTableProperty.PROPERTY_RESOURCE_NAME, String.class, null);
        this.addContainerProperty(CmsResourceTableProperty.PROPERTY_STATE, CmsResourceState.class, null);
        this.addContainerProperty(CmsResourceTableProperty.PROPERTY_TREE_CAPTION, String.class, null);
        this.addContainerProperty(CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT, Boolean.class, Boolean.TRUE);
        this.addContainerProperty(CmsResourceTableProperty.PROPERTY_IS_FOLDER, Boolean.class, Boolean.TRUE);
        this.addContainerProperty(PROPERTY_RESOURCE, CmsResource.class, null);
        this.addContainerProperty(CmsResourceTableProperty.PROPERTY_IN_NAVIGATION, Boolean.class, Boolean.FALSE);
        this.addContainerProperty(CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION, Float.class, Float.valueOf(Float.MAX_VALUE));
        this.addContainerProperty(PROPERTY_SITEMAP_CAPTION, String.class, "");
        this.addContainerProperty(CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT, CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT.getColumnType(), "");
    }

    protected void fillProperties(CmsObject cms, Item resourceItem, CmsResource resource, CmsUUID parentId) {
        resourceItem.getItemProperty((Object)PROPERTY_RESOURCE).setValue((Object)resource);
        String name = this.getName(cms, resource, parentId);
        if (resource.isFolder() && !name.endsWith("/")) {
            name = name + "/";
        }
        CmsResourceUtil resUtil = new CmsResourceUtil(cms, resource);
        resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_RESOURCE_NAME).setValue((Object)name);
        resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_STATE).setValue((Object)resource.getState());
        resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_INSIDE_PROJECT).setValue((Object)resUtil.isInsideProject());
        resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IS_FOLDER).setValue((Object)resource.isFolder());
        try {
            CmsObject rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            CmsJspNavBuilder builder = new CmsJspNavBuilder(rootCms);
            CmsJspNavElement nav = builder.getNavigationForResource(resource.getRootPath(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            boolean inNavigation = nav.isInNavigation();
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_IN_NAVIGATION).setValue((Object)inNavigation);
            if (inNavigation) {
                resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_POSITION).setValue((Object)Float.valueOf(nav.getNavPosition()));
            }
            String navText = null;
            if (nav.getProperties().containsKey("NavText")) {
                navText = nav.getProperties().get("NavText");
            } else if (nav.getProperties().containsKey("Title")) {
                navText = nav.getProperties().get("Title");
            }
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_NAVIGATION_TEXT).setValue((Object)navText);
            String folderCaption = CmsResourceIcon.getTreeCaptionHTML(name, resUtil, null, false);
            resourceItem.getItemProperty((Object)CmsResourceTableProperty.PROPERTY_TREE_CAPTION).setValue((Object)folderCaption);
            if (inNavigation) {
                if (navText == null) {
                    navText = name;
                }
                String sitemapCaption = CmsResourceIcon.getTreeCaptionHTML(navText, resUtil, null, false);
                resourceItem.getItemProperty((Object)PROPERTY_SITEMAP_CAPTION).setValue((Object)sitemapCaption);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected String getName(CmsObject cms, CmsResource resource, CmsUUID parentId) {
        return parentId == null ? resource.getRootPath() : resource.getName();
    }
}

