/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.contextmenu;

import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.UserError;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.TextField;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsResourceTableProperty;
import org.opencms.ui.components.I_CmsFilePropertyEditHandler;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsContextMenuEditHandler
implements I_CmsFilePropertyEditHandler {
    private static final Log LOG = CmsLog.getLog(CmsContextMenuEditHandler.class);
    private static final long serialVersionUID = -9160838301862765592L;
    private I_CmsDialogContext m_context;
    private CmsUUID m_editId;
    private CmsResourceTableProperty m_editProperty;
    private CmsFileTable m_fileTable;
    private CmsLockActionRecord m_lockActionRecord;

    public CmsContextMenuEditHandler(CmsUUID editId, CmsResourceTableProperty editProperty, CmsFileTable fileTable, I_CmsDialogContext context) {
        this.m_editId = editId;
        this.m_editProperty = editProperty;
        this.m_fileTable = fileTable;
        this.m_context = context;
    }

    @Override
    public void cancel() {
        if (this.m_lockActionRecord.getChange() == CmsLockActionRecord.LockChange.locked) {
            CmsObject cms = A_CmsUI.getCmsObject();
            try {
                CmsResource res = cms.readResource(this.m_editId);
                cms.unlockResource(res);
            }
            catch (CmsException e) {
                LOG.warn((Object)("Failed to unlock resource " + this.m_editId.toString()), (Throwable)e);
            }
        }
        CmsAppWorkplaceUi.get().enableGlobalShortcuts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String value) {
        try {
            CmsObject cms = A_CmsUI.getCmsObject();
            CmsResource res = cms.readResource(this.m_editId);
            try {
                if (CmsResourceTableProperty.PROPERTY_RESOURCE_NAME.equals(this.m_editProperty)) {
                    String sourcePath = cms.getSitePath(res);
                    cms.renameResource(sourcePath, CmsStringUtil.joinPaths(CmsResource.getParentFolder(sourcePath), value));
                } else if (this.m_editProperty.isEditProperty()) {
                    CmsProperty prop = new CmsProperty(this.m_editProperty.getEditPropertyId(), value, null);
                    cms.writePropertyObject(cms.getSitePath(res), prop);
                }
            }
            finally {
                if (this.m_lockActionRecord.getChange() == CmsLockActionRecord.LockChange.locked) {
                    CmsResource updatedRes = cms.readResource(res.getStructureId(), CmsResourceFilter.ALL);
                    try {
                        cms.unlockResource(updatedRes);
                    }
                    catch (CmsLockException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                CmsAppWorkplaceUi.get().enableGlobalShortcuts();
                this.m_fileTable.clearSelection();
            }
            this.m_context.finish(Collections.singletonList(this.m_editId));
        }
        catch (CmsException e) {
            LOG.error((Object)("Exception while saving changed " + this.m_editProperty + " to resource " + this.m_editId), (Throwable)e);
            this.m_context.error(e);
        }
    }

    @Override
    public void start() {
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            CmsResource res = cms.readResource(this.m_editId);
            this.m_lockActionRecord = CmsLockUtil.ensureLock(cms, res);
            CmsAppWorkplaceUi.get().disableGlobalShortcuts();
            this.m_fileTable.startEdit(this.m_editId, this.m_editProperty, this);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void textChange(FieldEvents.TextChangeEvent event) {
        TextField tf = (TextField)event.getSource();
        try {
            this.validate(event.getText());
            tf.setComponentError(null);
        }
        catch (Validator.InvalidValueException e) {
            tf.setComponentError((ErrorMessage)new UserError(e.getHtmlMessage(), AbstractErrorMessage.ContentMode.HTML, null));
        }
    }

    public void validate(Object value) throws Validator.InvalidValueException {
        if (this.m_editProperty == CmsResourceTableProperty.PROPERTY_RESOURCE_NAME && value instanceof String) {
            try {
                String sourcePath;
                String newName = (String)value;
                CmsResource.checkResourceName(newName);
                CmsObject cms = A_CmsUI.getCmsObject();
                CmsResource res = cms.readResource(this.m_editId);
                if (!res.getName().equals(newName) && cms.existsResource(CmsStringUtil.joinPaths(CmsResource.getParentFolder(sourcePath = cms.getSitePath(res)), newName))) {
                    throw new Validator.InvalidValueException("The selected filename already exists.");
                }
            }
            catch (CmsIllegalArgumentException e) {
                throw new Validator.InvalidValueException(e.getLocalizedMessage(A_CmsUI.get().getLocale()));
            }
            catch (CmsException e) {
                LOG.warn((Object)"Error while validating new filename", (Throwable)e);
                throw new Validator.InvalidValueException(e.getLocalizedMessage(A_CmsUI.get().getLocale()));
            }
        }
    }
}

